/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.video.ajaxservice;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.video.domain.WCMContextHelper;
import com.trs.components.video.domain.XVideoMgr;
import com.trs.components.video.persistent.XVideo;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoRecycleServiceProvider
implements ISelfDefinedServiceProvider {
    private static final Logger LOG;
    private static final String DENIED_IP = "deniedIp";
    private static final String DB_ERROR = "dbError";
    private static final String RESULT = "result";
    private static final String THUMB_DELETE_FAILED = "thumbDeleteFailed";
    private static final String VIDEO_DELETE_FAILED = "videoDeleteFailed";
    private static final String OK = "ok";
    private static final String DENIED = "denied";
    private XVideoMgr xvideoMgr = WCMContextHelper.getXVideoMgr();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.components.video.domain.DBTransfer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public Reports deleteVideos(MethodContext methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String ids = methodContext.getObjectIds();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.validateDeleteRight(loginUser, ids, 33, I18NMessage.get((Class)clazz, (String)"VideoRecycleServiceProvider.label1", (String)"\u5220\u9664"));
        ChnlDocs chnldocs = ChnlDocs.findByIds((User)loginUser, (String)ids);
        this.validateChnlDocsRight(loginUser, chnldocs, false);
        return this.deleteFromChnldocs(loginUser, chnldocs);
    }

    public Reports clearRecycleVideos(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel siteOrChannel = this.makeCurrChannelOrSite(_methodContext);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.validateClearRight(loginUser, siteOrChannel, 33, I18NMessage.get((Class)clazz, (String)"VideoRecycleServiceProvider.label2", (String)"\u6e05\u7a7a\u56de\u6536\u7ad9\u7684\u6587\u6863"));
        ChnlDocs chnldocs = this.chnlDocsFromSiteORChannel(siteOrChannel);
        this.validateChnlDocsRight(loginUser, chnldocs, siteOrChannel.isSite());
        return this.deleteFromChnldocs(loginUser, chnldocs);
    }

    private Reports deleteFromChnldocs(User loginUser, ChnlDocs chnldocs) throws WCMException {
        StringBuffer tokens = new StringBuffer();
        int deleteCount = 0;
        int total = chnldocs.size();
        int i = 0;
        int size = total;
        while (i < size) {
            ChnlDoc chnldoc = (ChnlDoc)chnldocs.getAt(i);
            if (chnldoc != null) {
                if (!chnldoc.isEntity()) {
                    chnldocs.removeAt(i, false);
                    --i;
                    --size;
                    chnldoc.delete(loginUser);
                    ++deleteCount;
                } else {
                    List xvideos = XVideo.findXVideosByDocId(chnldoc.getDocId());
                    if (xvideos.size() != 0) {
                        XVideo xvideo = (XVideo)((Object)xvideos.get(0));
                        LOG.info((Object)("deleted xvideo is : " + (Object)((Object)xvideo)));
                        if (xvideo.isCopied() == 1 && this.xvideoMgr.isUsedByOthers(xvideo)) {
                            chnldocs.removeAt(i, false);
                            --i;
                            --size;
                            this.delete(loginUser, chnldoc, xvideos);
                            ++deleteCount;
                        } else {
                            String srcFileName = xvideo.getSrcFileName();
                            LOG.info((Object)("video to be deleted srcFileName is: " + srcFileName));
                            if (srcFileName == null || "".equals(srcFileName.trim())) {
                                LOG.info((Object)("video to be deleted file name is: " + xvideo.getFileName()));
                                srcFileName = xvideo.getFileName().substring(0, 11);
                            }
                            tokens.append(srcFileName);
                            tokens.append(';');
                        }
                    }
                }
            }
            ++i;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Reports reports = new Reports(I18NMessage.get((Class)clazz, (String)"VideoRecycleServiceProvider.label3", (String)"\u5220\u9664\u89c6\u9891\u9519\u8bef"));
        if (tokens.length() == 0) {
            return null;
        }
        LOG.info((Object)("deleteFromChnldocs tokens is: " + tokens));
        String responseText = this.xvideoMgr.sendDeleteReuqest(tokens.toString());
        if (responseText != null) {
            JSONObject json = null;
            try {
                json = new JSONObject(responseText);
            }
            catch (JSONException e) {
                return null;
            }
            String result = this.jsonStringValue(json, RESULT);
            StringBuffer failedTokens = new StringBuffer();
            if (DENIED.equals(result)) {
                String failedInfo = null;
                String reason = this.jsonStringValue(json, "reason");
                if (reason == null) {
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(I18NMessage.get((Class)clazz2, (String)"VideoRecycleServiceProvider.label4", (String)"WCM\u8bf7\u6c42TRSVIDEO\u5220\u9664\u89c6\u9891\u6587\u4ef6\u5931\u8d25: WCM\u7684IP["))).append(this.jsonStringValue(json, DENIED_IP));
                    Class<?> clazz3 = class$1;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    failedInfo = stringBuffer.append(I18NMessage.get((Class)clazz3, (String)"VideoRecycleServiceProvider.label5", (String)"]\u88ab\u62d2\u7edd!")).toString();
                } else {
                    Class<?> clazz4 = class$1;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    failedInfo = I18NMessage.get((Class)clazz4, (String)"VideoRecycleServiceProvider.label6", (String)"TRSVIDEO\u5220\u9664\u89c6\u9891\u6587\u4ef6\u5931\u8d25\uff1a\u975e\u6cd5\u7684\u5ba2\u6237\u7aef\uff01");
                }
                reports.addFailedReport(failedInfo, null);
                LOG.error((Object)failedInfo);
            } else {
                ChnlDoc chnldoc;
                if (!OK.equals(result)) {
                    String videoFailed = this.jsonStringValue(json, VIDEO_DELETE_FAILED);
                    String thumbFailed = this.jsonStringValue(json, THUMB_DELETE_FAILED);
                    String dbError = this.jsonStringValue(json, DB_ERROR);
                    if (videoFailed != null) {
                        failedTokens.append(videoFailed);
                        Class<?> clazz5 = class$1;
                        if (clazz5 == null) {
                            try {
                                clazz5 = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        reports.addFailedReport(String.valueOf(I18NMessage.get((Class)clazz5, (String)"VideoRecycleServiceProvider.label7", (String)"\u89c6\u9891\u5220\u9664\u5931\u8d25\uff0c\u89c6\u9891\u6587\u4ef6\u65e0\u6cd5\u5220\u9664\u3002( TOKEN : ")) + videoFailed + " )", null);
                    }
                    if (thumbFailed != null) {
                        failedTokens.append(thumbFailed);
                        Class<?> clazz6 = class$1;
                        if (clazz6 == null) {
                            try {
                                clazz6 = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        reports.addFailedReport(String.valueOf(I18NMessage.get((Class)clazz6, (String)"VideoRecycleServiceProvider.label8", (String)"\u89c6\u9891\u5220\u9664\u5931\u8d25\uff0c\u7f29\u7565\u56fe\u65e0\u6cd5\u5220\u9664\u3002( TOKEN \uff1a")) + thumbFailed + " )", null);
                    }
                    if (dbError != null) {
                        failedTokens.append(dbError);
                        Class<?> clazz7 = class$1;
                        if (clazz7 == null) {
                            try {
                                clazz7 = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        reports.addFailedReport(String.valueOf(I18NMessage.get((Class)clazz7, (String)"VideoRecycleServiceProvider.label9", (String)"\u89c6\u9891\u5220\u9664\u5931\u8d25\uff0cTRSVIDEO\u6570\u636e\u5e93\u5f02\u5e38\u3002( TOKEN \uff1a")) + dbError + " )", null);
                    }
                }
                if (failedTokens.length() == 0) {
                    int i2 = 0;
                    int size2 = chnldocs.size();
                    while (i2 < size2) {
                        chnldoc = (ChnlDoc)chnldocs.getAt(i2);
                        List xvideos = XVideo.findXVideosByDocId(chnldoc.getDocId());
                        this.delete(loginUser, chnldoc, xvideos);
                        ++i2;
                    }
                    deleteCount += chnldocs.size();
                } else {
                    int i3 = 0;
                    int size3 = chnldocs.size();
                    while (i3 < size3) {
                        XVideo xvideo;
                        chnldoc = (ChnlDoc)chnldocs.getAt(i3);
                        List xvideos = XVideo.findXVideosByDocId(chnldoc.getDocId());
                        if (xvideos.size() != 0 && failedTokens.indexOf((xvideo = (XVideo)((Object)xvideos.get(0))).getSrcFileName()) == -1) {
                            this.delete(loginUser, chnldoc, xvideos);
                            ++deleteCount;
                        }
                        ++i3;
                    }
                }
                if (deleteCount > 0) {
                    Class<?> clazz8 = class$1;
                    if (clazz8 == null) {
                        try {
                            clazz8 = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    reports.setTitle(I18NMessage.get((Class)clazz8, (String)"VideoRecycleServiceProvider.label10", (String)"\u5220\u9664\u89c6\u9891\u63d0\u793a"));
                    Class<?> clazz9 = class$1;
                    if (clazz9 == null) {
                        try {
                            clazz9 = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    reports.addSucessedReport(String.valueOf(I18NMessage.get((Class)clazz9, (String)"VideoRecycleServiceProvider.label11", (String)"\u6210\u529f\u5220\u9664\u7684\u89c6\u9891\u4e2a\u6570\uff1a")) + String.valueOf(deleteCount));
                }
            }
        } else {
            Class<?> clazz10 = class$1;
            if (clazz10 == null) {
                try {
                    clazz10 = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String failedInfo = I18NMessage.get((Class)clazz10, (String)"VideoRecycleServiceProvider.label12", (String)"\u8bf7\u6c42TRSVIDEO\u670d\u52a1\u5931\u8d25\uff0cTRSVIDEO\u6ca1\u6709\u542f\u52a8\u6216\u7f51\u7edc\u8bbf\u95ee\u6709\u95ee\u9898\u3002");
            reports.addFailedReport(failedInfo, null);
            LOG.error((Object)failedInfo);
        }
        return deleteCount == total ? null : reports;
    }

    private void delete(User loginUser, ChnlDoc chnldoc, List xvideos) throws WCMException {
        this.getChnlDocs(chnldoc.getDocId(), 0, null).removeAll(true);
        chnldoc.delete(loginUser);
        int i = 0;
        while (i < xvideos.size()) {
            XVideo xvideo = (XVideo)((Object)xvideos.get(i));
            if (xvideo != null) {
                xvideo.delete(loginUser);
            }
            ++i;
        }
    }

    private void validateChnlDocsRight(User loginUser, ChnlDocs chnldocs, boolean clearInSite) throws WCMException {
        if (clearInSite) {
            int i = 0;
            int size = chnldocs.size();
            while (i < size) {
                ChnlDoc chnldoc = (ChnlDoc)chnldocs.getAt(i);
                if (!DocumentAuthServer.hasRight((User)loginUser, (ChnlDoc)chnldoc, (int)33)) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    throw new WCMException(CMyString.format((String)I18NMessage.get((Class)clazz, (String)"VideoRecycleServiceProvider.label13", (String)"\u60a8[{0}]\u5bf9\u6587\u6863[DocId={1}]\u6ca1\u6709\u6743\u9650\u5220\u9664"), (String[])new String[]{loginUser.getName(), String.valueOf(chnldoc.getDocId())}));
                }
                ++i;
            }
        } else {
            int i = 0;
            int size = chnldocs.size();
            while (i < size) {
                ChnlDoc chnldoc = (ChnlDoc)chnldocs.getAt(i);
                if (DocumentAuthServer.isDefineRightOnDocument((int)chnldoc.getDocId()) && !DocumentAuthServer.hasRight((User)loginUser, (ChnlDoc)chnldoc, (int)33)) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    throw new WCMException(CMyString.format((String)I18NMessage.get((Class)clazz, (String)"VideoRecycleServiceProvider.label14", (String)"\u60a8[[{0}]\u5bf9\u6587\u6863[DocId={1}]\u6ca1\u6709\u6743\u9650\u5220\u9664"), (String[])new String[]{loginUser.getName(), String.valueOf(chnldoc.getDocId())}));
                }
                ++i;
            }
        }
    }

    private ChnlDocs chnlDocsFromSiteORChannel(BaseChannel siteOrChannel) throws WCMException {
        String sQueryChnlDocsSQL = siteOrChannel.isSite() ? "(DocStatus<0 or Modal<0) and exists( select c.ChannelId from WCMChannel c   Where c.Status>=0 and c.SiteId=? and WCMChnlDoc.ChnlId=c.ChannelId)" : "ChnlId=? and (DocStatus<0 or Modal<0)";
        WCMFilter filter = new WCMFilter("WCMChnlDoc", sQueryChnlDocsSQL, "");
        filter.addSearchValues(siteOrChannel.getId());
        ChnlDocs chnlDocs = ChnlDocs.openWCMObjs(null, (WCMFilter)filter);
        return chnlDocs;
    }

    private ChnlDocs getChnlDocs(int _nDocId, int _nDocModal, WCMFilter _extraFilter) throws WCMException {
        String sWhere = "DOCID=" + _nDocId;
        if (_nDocModal != 0) {
            sWhere = String.valueOf(sWhere) + " AND MODAL=" + _nDocModal;
        }
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.mergeWith(_extraFilter);
        return ChnlDocs.openWCMObjs((User)this.getLoginUser(), (WCMFilter)filter);
    }

    private void validateClearRight(User _loginUser, BaseChannel _oSiteOrChannel, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (!AuthServer.hasRight((User)_loginUser, (CMSObj)_oSiteOrChannel, (int)_nRightIndex)) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new WCMException(CMyString.format((String)I18NMessage.get((Class)clazz, (String)"VideoRecycleServiceProvider.label16", (String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8[{0}]\u6ca1\u6709\u6743\u9650\u5728[{1}]\u4e0a\u6267\u884c[{2}]\u64cd\u4f5c\uff01"), (String[])new String[]{_loginUser.getName(), _oSiteOrChannel.getName(), _sOperDesc}));
        }
    }

    private void validateDeleteRight(User _loginUser, String _sChnlDocIds, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return;
        }
        Channels channels = this.findChannelsByChnlDocIds(_loginUser, _sChnlDocIds);
        int i = 0;
        int nSize = channels.size();
        while (i < nSize) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel != null) {
                this.validateClearRight(_loginUser, (BaseChannel)channel, _nRightIndex, _sOperDesc);
            }
            ++i;
        }
    }

    private Channels findChannelsByChnlDocIds(User _loginUser, String _sChnlDocIds) throws WCMException {
        WCMFilter filter = new WCMFilter("WCMChnlDoc", "RecId in(" + _sChnlDocIds + ")", "", "ChnlId As ChannelId");
        return Channels.openWCMObjs((User)_loginUser, (WCMFilter)filter);
    }

    private BaseChannel makeCurrChannelOrSite(MethodContext _methodContext) throws WCMException {
        int nSiteId = _methodContext.getValue("SiteID", 0);
        int nChannelId = _methodContext.getValue("ChannelId", 0);
        if (nSiteId <= 0 && nChannelId <= 0) {
            return null;
        }
        if (nSiteId > 0 && nChannelId > 0) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(I18NMessage.get((Class)clazz, (String)"VideoRecycleServiceProvider.label20", (String)"\u6307\u5b9a\u7684\u53c2\u6570\u6709\u8bef\uff01\u540c\u65f6\u6307\u5b9a\u4e86\u7ad9\u70b9ID["))).append(nSiteId);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new WCMException(stringBuffer.append(I18NMessage.get((Class)clazz2, (String)"VideoRecycleServiceProvider.label21", (String)"]\u548c\u680f\u76eeID[")).append(nChannelId).append("]!").toString());
        }
        WebSite channelOrSite = null;
        if (nSiteId > 0) {
            channelOrSite = WebSite.findById((int)nSiteId);
        }
        if (nChannelId > 0) {
            channelOrSite = Channel.findById((int)nChannelId);
            _methodContext.putContextCacheData((Object)"CurrChannel", (Object)channelOrSite);
        }
        if (channelOrSite == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(I18NMessage.get((Class)clazz, (String)"VideoRecycleServiceProvider.label22", (String)"\u6307\u5b9a\u7684\u53c2\u6570\u6709\u8bef\uff01\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ad9\u70b9[ID="))).append(nSiteId);
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("com.trs.components.video.ajaxservice.VideoRecycleServiceProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new WCMException(stringBuffer.append(I18NMessage.get((Class)clazz3, (String)"VideoRecycleServiceProvider.label23", (String)"]\u6216\u680f\u76ee[ID=")).append(nChannelId).append("]!").toString());
        }
        return channelOrSite;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private String jsonStringValue(JSONObject json, String key) {
        try {
            return json.getString(key);
        }
        catch (JSONException e) {
            return null;
        }
    }
}

