/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.filter;

import com.trs.idm.client.actor.ActorException;
import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.actor.v2.IServletAppActorV2;
import com.trs.idm.client.filter.IdsAgentAccessHelper;
import com.trs.idm.client.filter.VerifyReqInfo;
import com.trs.idm.client.filter.VerifyResult;
import com.trs.idm.client.filter.logicProcessor.AddGroupProcessor;
import com.trs.idm.client.filter.logicProcessor.AddUserProcessor;
import com.trs.idm.client.filter.logicProcessor.DelGroupProcessor;
import com.trs.idm.client.filter.logicProcessor.DelUserProcessor;
import com.trs.idm.client.filter.logicProcessor.DisableUserProcessor;
import com.trs.idm.client.filter.logicProcessor.EnableUserProcessor;
import com.trs.idm.client.filter.logicProcessor.IDSCmdProcessor;
import com.trs.idm.client.filter.logicProcessor.LoginProcessor;
import com.trs.idm.client.filter.logicProcessor.LogoutProcessor;
import com.trs.idm.client.filter.logicProcessor.MoveToGroupProcessor;
import com.trs.idm.client.filter.logicProcessor.NullProcessor;
import com.trs.idm.client.filter.logicProcessor.PingProcessor;
import com.trs.idm.client.filter.logicProcessor.RemoveFromGroupProcessor;
import com.trs.idm.client.filter.logicProcessor.UpdateGroupProcessor;
import com.trs.idm.client.filter.logicProcessor.UpdateSSOUrlProcessor;
import com.trs.idm.client.filter.logicProcessor.UpdateUserProcessor;
import com.trs.idm.exception.ClientTransferException;
import com.trs.idm.exception.NoSuchSSOIDException;
import com.trs.idm.interact.agent.AgentFactory;
import com.trs.idm.interact.agent.AgentUtil;
import com.trs.idm.interact.agent.IAgent;
import com.trs.idm.interact.agent.LoginResult;
import com.trs.idm.model.sso.samedomain.SameDomainSSOHelper;
import com.trs.idm.util.Base64Util;
import com.trs.idm.util.CookieHelper;
import com.trs.idm.util.LoginEncoder;
import com.trs.idm.util.P3PUtil;
import com.trs.idm.util.RequestUtil;
import com.trs.idm.util.StringHelper;
import com.trs.idm.util.UrlUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class GeneralSSOFilter
implements Filter {
    public static final String APP_GUEST_FLG = "com.trs.ids.guest";
    private static final Logger LOG = Logger.getLogger(GeneralSSOFilter.class);
    protected IAgent agent;
    protected String encryptAgentName;
    protected String[] onlyProcessPrefixes;
    protected String[] justVerifyPrefixes;
    protected String userParamOfJustVerify;
    protected String pwdParamOfJustVerify;
    protected String verifyFailUri;
    protected Map idsCmdProcessors;
    private int domainLevel;
    private IServletAppActorV2 servletAppActor;
    private IdsAgentAccessHelper idsAgentAccessHelper;

    public void doFilter(ServletRequest srq, ServletResponse sresp, FilterChain fc) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)srq;
        HttpServletResponse resp = (HttpServletResponse)sresp;
        String relativePathWithPara = RequestUtil.getRelativePathWithPara((HttpServletRequest)req);
        String method = req.getMethod();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("relativePathWithPara: " + relativePathWithPara + "; method: " + method));
        }
        if (this.agent == null) {
            throw new ServletException("IDS Agent\u542f\u52a8\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u7cfb\u7edf\u65e5\u5fd7\uff0c\u4ee5\u83b7\u5f97\u51c6\u786e\u7684\u542f\u52a8\u5931\u8d25\u539f\u56e0\uff01");
        }
        if (this.idsAgentAccessHelper == null) {
            LOG.error((Object)("idsAgentAccessHelper is null ,so let it go directly. agent info [" + this.agent + "]"));
            fc.doFilter(srq, sresp);
            return;
        }
        if (this.idsAgentAccessHelper.isIDSURL(relativePathWithPara)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RequestUrl [" + relativePathWithPara + "] is a request for IDS, let it go ."));
            }
            fc.doFilter(srq, sresp);
            return;
        }
        if (this.idsAgentAccessHelper.isAgentDebugJsp(relativePathWithPara)) {
            String agentJsp = "/WEB-INF/idsAgentPages/" + RequestUtil.getCurrentPage((HttpServletRequest)req);
            RequestDispatcher rdDug = req.getRequestDispatcher(agentJsp);
            if (rdDug != null) {
                rdDug.forward((ServletRequest)req, (ServletResponse)resp);
            } else {
                resp.sendError(500, "[IDSAgent]page not found: " + agentJsp);
            }
            return;
        }
        if ("TRS Identity Server".equals(req.getHeader("user-agent")) && "updAgentSsoSwitch".equals(req.getHeader("trs-ids-cmd"))) {
            this.updateSsoSwitch(req, resp);
            return;
        }
        if (!this.agent.useSSO()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"IDS SSO Feature is stop now, so pass directly");
            }
            fc.doFilter(srq, sresp);
            return;
        }
        if (this.isFilterNotInited()) {
            this.initFilterByAgent(req.getSession().getServletContext());
        }
        if (!StringHelper.isEmpty((String)this.agent.getOriginalClientIPHttpHeader())) {
            req.setAttribute("XForwardedFor-Name", (Object)this.agent.getOriginalClientIPHttpHeader());
        }
        if (!StringHelper.isEmpty((String)this.agent.getOriginalHostHttpHeader())) {
            req.setAttribute("XForwardedHost-Name", (Object)this.agent.getOriginalHostHttpHeader());
        }
        String coSessionId = this.servletAppActor.getSessionId(req, resp, true);
        this.refreshSSOSession((HttpServletRequest)srq, (HttpServletResponse)sresp, coSessionId);
        boolean mustProcessUrls = this.idsAgentAccessHelper.isMustProcessUrls(relativePathWithPara, method);
        if (!mustProcessUrls && this.idsAgentAccessHelper.needIgnore(relativePathWithPara)) {
            this.logRequestInfoForDeBug(req);
            fc.doFilter(srq, sresp);
            return;
        }
        if (this.idsAgentAccessHelper.isCheckAgentPropertiesRequest(req.getRequestURI())) {
            fc.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (!this.agent.isStarted()) {
            if (!this.agent.getPropertiesValidator().check()) {
                req.getRequestDispatcher("checkIDSAgentConfig.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            throw new ServletException("IDS Agent\u542f\u52a8\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u7cfb\u7edf\u65e5\u5fd7\uff0c\u4ee5\u83b7\u5f97\u51c6\u786e\u7684\u542f\u52a8\u5931\u8d25\u539f\u56e0\uff01");
        }
        String appDomain = this.agent.getProperty("cookie.Domain", null);
        boolean sameDomainForPeopleDotCom = appDomain != null && RequestUtil.getServerName((HttpServletRequest)req).endsWith(appDomain);
        CookieHelper ckHelper = new CookieHelper(req, resp, this.domainLevel);
        if (!this.agent.isSocketAlive()) {
            LOG.warn((Object)"IDS is down, pass all request!");
            fc.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (this.idsAgentAccessHelper.isIDSRequest(req.getHeader("user-agent"))) {
            LOG.info((Object)("IDS Server send Request to Agent,header:" + req.getHeader("user-agent")));
            this.processIDSRequest(req, resp);
            return;
        }
        if (this.idsAgentAccessHelper.isRegRequest(relativePathWithPara)) {
            this.processRegRequest(req, resp);
            return;
        }
        P3PUtil.accept3rdPartyCookie((HttpServletResponse)resp);
        if (this.idsAgentAccessHelper.isSSOLoginReqByLocalPage(relativePathWithPara, method)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("isSSOLoginReqByLocalPage=true, so forward. relativePathWithPara=" + relativePathWithPara + ",loginAction.uri=" + StringHelper.toString((Object[])this.agent.getLoginActionURIs())));
            }
            this.checkIsSSOAlive(coSessionId, ckHelper);
            this.processSSOLoginByLocalPage(fc, req, resp);
            return;
        }
        if (this.idsAgentAccessHelper.isVerifyButNotLoginRequest(relativePathWithPara)) {
            this.processVerifyNotLoginRequest(fc, req, resp);
            return;
        }
        if (this.idsAgentAccessHelper.isLogoutRequest(relativePathWithPara)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("isLogoutRequest=true, so forward. relativePathWithPara=" + relativePathWithPara + ",logout.uri=" + StringHelper.toString((Object[])this.agent.getLogoutURIs())));
            }
            this.processLogouRequest(req, resp, this.servletAppActor, coSessionId, sameDomainForPeopleDotCom, ckHelper);
            return;
        }
        if (this.agent.supportSameDomainSSO()) {
            this.processSameDomainSSOAccessing(req, resp, fc, coSessionId);
            return;
        }
        if (this.servletAppActor.checkLocalLogin(req, resp)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("coSessId=" + coSessionId + ", checkLocalLogin() return  true"));
            }
            AgentUtil.removeSSOBind((CookieHelper)ckHelper, (IAgent)this.agent);
            fc.doFilter(srq, sresp);
            return;
        }
        if (sameDomainForPeopleDotCom) {
            this.processSameDomainRequest(fc, req, resp, coSessionId, ckHelper);
            return;
        }
        boolean alreadyBindSSO = AgentUtil.alreadyBindSSO((CookieHelper)ckHelper, (IAgent)this.agent);
        boolean matchProcessUrl = this.idsAgentAccessHelper.isUrlInProcessUrlPrefix(relativePathWithPara);
        boolean allowGuest = this.allowGuest(matchProcessUrl);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("alreadyBindSSO: " + alreadyBindSSO + "; allowGuest: " + allowGuest));
        }
        if (alreadyBindSSO && allowGuest && this.agent.getAuthBy() == 0) {
            String ssoIdInUrl = AgentUtil.getBindSSOIdInUrl((HttpServletRequest)req);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ssoIdInUrl: " + ssoIdInUrl));
            }
            if (ssoIdInUrl != null && ssoIdInUrl.length() > 0) {
                AgentUtil.saveSSOId((String)ssoIdInUrl, (CookieHelper)ckHelper, (IAgent)this.agent);
                String originUrl = this.agent.restoreOriginAccessUrl(req);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("originUrl: " + originUrl));
                }
                if (!this.agent.needSavePostParamAndPostBack() || !AgentUtil.havePostParamInCookie((CookieHelper)ckHelper)) {
                    RequestUtil.sendRedirectSecure((HttpServletRequest)req, (HttpServletResponse)resp, (String)originUrl, null, (boolean)true);
                    return;
                }
                AgentUtil.forwardToAutosubmitPageWithPostParam((HttpServletRequest)req, (HttpServletResponse)resp, (CookieHelper)ckHelper, (String)originUrl);
                return;
            }
            this.servletAppActor.loadAnonymous(req, resp);
            if (resp.isCommitted()) {
                return;
            }
            fc.doFilter(srq, sresp);
            return;
        }
        String ssoSessionId = AgentUtil.getBindSSOId((CookieHelper)ckHelper, (IAgent)this.agent);
        SSOUser ssoUser = null;
        try {
            ssoUser = ssoSessionId == null ? this.agent.findSSOUserByLocalSessionId(coSessionId) : this.agent.findLoginSSOUser(ssoSessionId, coSessionId);
            String ssoUserWithoutPwd = this.getSSOUserInfoForLOG(ssoUser);
            LOG.info((Object)("find ssoUser from server: " + ssoUserWithoutPwd));
        }
        catch (ClientTransferException ex) {
            this.handleServerException(req, resp, (Exception)((Object)ex), coSessionId, ssoSessionId);
            return;
        }
        catch (Exception e) {
            this.handleServerException(req, resp, e, coSessionId, ssoSessionId);
            return;
        }
        if (ssoUser != null) {
            AgentUtil.removeSSOBind((CookieHelper)ckHelper, (IAgent)this.agent);
            try {
                this.servletAppActor.loadLoginUser(req, resp, ssoUser);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("actor loadLoginUser ok. coSessId=" + coSessionId + ", user=" + ssoUser.getUserName()));
                }
                if (AgentUtil.havePostParamInCookie((CookieHelper)ckHelper)) {
                    AgentUtil.forwardToAutosubmitPageWithPostParam((HttpServletRequest)req, (HttpServletResponse)resp, (CookieHelper)ckHelper, (String)req.getRequestURL().toString());
                } else {
                    fc.doFilter((ServletRequest)req, (ServletResponse)resp);
                }
            }
            catch (RuntimeException e) {
                LOG.error((Object)(String.valueOf(this.agent.getAgentName()) + " actor addUser/loadLoginUser fail! sessId=" + coSessionId + ", user=" + ssoUser.getUserName()), (Throwable)e);
                this.handleServerException(resp, e);
            }
            return;
        }
        if (resp.isCommitted()) {
            return;
        }
        String ssoLoginUrl = this.agent.getGlobalLoginUrl();
        if (StringHelper.isEmpty((String)ssoLoginUrl)) {
            if (!this.agent.isAllowAnonymous()) {
                StringBuffer sb = new StringBuffer();
                sb.append("<p>\u7531\u4e8e\u73b0\u5728\u65e0\u6cd5\u8fde\u63a5TRS\u8eab\u4efd\u670d\u52a1\u5668, \u7528\u6237\u73b0\u5728\u4e0d\u80fd\u767b\u5f55\u548c\u8bbf\u95ee\u534f\u4f5c\u5e94\u7528" + this.agent.getAgentName() + ", \u8bf7\u7a0d\u5019\u518d\u8bd5");
                sb.append("<p>\u539f\u56e0: ").append("IDS\u80fd\u591f\u8fde\u63a5\uff0c\u4f46\u662f\u65e0\u6cd5\u4eceIDS\u4e2d\u83b7\u53d6\u5fc5\u8981\u7684SSO URL\u53c2\u6570\uff0c\u8bf7\u8054\u7cfbIDS\u7ba1\u7406\u5458\u786e\u5b9aSSO URL\u662f\u5426\u6b63\u786e\u914d\u7f6e").append("</BR>");
                RequestUtil.outPrintMessage((HttpServletResponse)resp, (String)sb.toString());
                return;
            }
            fc.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (this.agent.needSavePostParamAndPostBack()) {
            AgentUtil.savePostParamInCookie((HttpServletRequest)req, (CookieHelper)ckHelper);
        }
        AgentUtil.saveCoSessionIdInCookie((CookieHelper)ckHelper, (IAgent)this.agent);
        resp.sendRedirect(this.agent.buildParamsForSSOUrl(matchProcessUrl, coSessionId, req));
    }

    private void refreshSSOSession(HttpServletRequest srq, HttpServletResponse sresp, String coSessionId) {
        String needRefreshStr = this.agent.getProperty("coapp.need.refresh", String.valueOf(true));
        if (!StringHelper.parseBoolean((String)needRefreshStr)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get needRefreshStr[" + needRefreshStr + "] is false, so return!"));
            }
            return;
        }
        CookieHelper refreshedTimestampCookie = new CookieHelper(srq, sresp);
        long refreshedTimestamp = StringHelper.parseLong((String)refreshedTimestampCookie.getValue("refreshedTimestamp"));
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - refreshedTimestamp < 300000L) {
            return;
        }
        try {
            String ssoId = this.agent.findSSOID(coSessionId);
            if (StringHelper.isEmpty((String)ssoId)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ssoId is null by agent.findSSOID(" + coSessionId + "). no need to refresh ."));
                }
                return;
            }
            refreshedTimestampCookie.addCookie("refreshedTimestamp", String.valueOf(currentTimeMillis));
            this.agent.refresh(ssoId, this.servletAppActor.getSessionId(srq, sresp, true), RequestUtil.getRemoteAddr((HttpServletRequest)srq, (String)this.agent.getOriginalClientIPHttpHeader()));
        }
        catch (ActorException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LOG.error((Object)e.getMessage(), e);
        }
    }

    private boolean isFilterNotInited() {
        return this.servletAppActor == null;
    }

    private void checkIsSSOAlive(String coSessionId, CookieHelper ckHelper) {
        String ssoId;
        try {
            ssoId = this.agent.findSSOID(coSessionId);
        }
        catch (Throwable e) {
            LOG.error((Object)("failed to find SSOID from IDS by coSession[" + coSessionId + "], remove the agent's SSOBind."), e);
            AgentUtil.removeSSOBind((CookieHelper)ckHelper, (IAgent)this.agent);
            return;
        }
        if (ssoId == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SSOId from IDS by coSession [" + coSessionId + "] is null, remove the SSOBind."));
            }
            AgentUtil.removeSSOBind((CookieHelper)ckHelper, (IAgent)this.agent);
        }
    }

    private void handleServerException(HttpServletRequest req, HttpServletResponse resp, Exception e, String coSessionId, String ssoSessionId) {
        LOG.error((Object)("Error while finding SSOUser from IDSServer using socket, current ssoid[" + ssoSessionId + "] or coSessionId[" + coSessionId + "], this might happen because network error or IDS is stopped."), (Throwable)e);
        req.setAttribute("com.trs.ids.agent.exception", (Object)e);
        this.showHaltPage(req, resp, e);
    }

    private void updateSsoSwitch(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOG.debug((Object)("update sso switch request!trs-ids-cmd : " + req.getHeader("trs-ids-cmd")));
        String ssoSwitchValue = req.getHeader("agentSsoSwitchValue");
        LOG.debug((Object)("ssoSwitchValue:" + ssoSwitchValue));
        boolean isUseSSO = new Boolean(ssoSwitchValue);
        this.agent.setSSOSwitch(isUseSSO);
        resp.getOutputStream().print(this.agent.getProperty("agent.name"));
    }

    private void logRequestInfoForDeBug(HttpServletRequest req) {
        StringBuffer debugStr = new StringBuffer(256);
        debugStr.append("original serletPath: ").append(req.getServletPath()).append("; ");
        debugStr.append("pathInfo: ").append(req.getPathInfo()).append("; ");
        debugStr.append("queryString: ").append(req.getQueryString()).append("; ");
        debugStr.append("actualFullPath: " + req.getServletPath());
        LOG.debug((Object)debugStr.toString());
    }

    private void processSameDomainSSOAccessing(HttpServletRequest req, HttpServletResponse resp, FilterChain fc, String coSessionId) throws IOException, ServletException {
        boolean isAlreadyLocalLogin = this.agent.getServletAppActorV2().checkLocalLogin(req, resp);
        CookieHelper sdCookieHelper = new CookieHelper(req, resp);
        String sdToken = sdCookieHelper.getValue("trsidssdssotoken");
        LOG.debug((Object)("SDToken in Cookie: " + sdToken + "; isAlreadyLocalLogin: " + isAlreadyLocalLogin));
        if (sdToken == null) {
            if (isAlreadyLocalLogin) {
                LOG.warn((Object)"SameDomainCookie is not found, but App is already localLogin, so excute local logout method in actor");
                this.agent.getServletAppActorV2().logout(req, resp);
            }
            this.excuteAutoLogin(req, resp, fc, coSessionId, isAlreadyLocalLogin, sdCookieHelper);
            LOG.debug((Object)("SameDomainCookie is not found, and localLogin status now is:[" + this.agent.getServletAppActorV2().checkLocalLogin(req, resp) + "], so this is an anonymous access, pass directly"));
            fc.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        String ssoIdInSDToken = SameDomainSSOHelper.getSSOIdFromSDToken((String)sdToken);
        long tokenValidTime = SameDomainSSOHelper.getValidTimeFromSDToken((String)sdToken);
        if (System.currentTimeMillis() >= tokenValidTime) {
            sdCookieHelper.removeCookie("trsidssdssotoken", this.agent.getSDSSOCookiePath(), this.agent.getSDSSOCookieDomain());
            LOG.info((Object)("SSOSession[" + ssoIdInSDToken + "] is already timeout or not exist in IDS, so clear SameDomain Cookie"));
            this.agent.getServletAppActorV2().logout(req, resp);
            this.excuteAutoLogin(req, resp, fc, coSessionId, isAlreadyLocalLogin, sdCookieHelper);
            LOG.info((Object)"Excute logout method in Actor Done");
            fc.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (isAlreadyLocalLogin && ssoIdInSDToken.equals(SameDomainSSOHelper.getAppCurrentLoginedSSOID((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.agent.getAgentName()))) {
            LOG.debug((Object)"SameDomainCookie is found, and App is already localLogoin, so pass directly");
            fc.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        SSOUser ssoUser = null;
        try {
            ssoUser = this.agent.findSSOUser(ssoIdInSDToken, coSessionId, RequestUtil.getRemoteAddr((HttpServletRequest)req, (String)this.agent.getOriginalClientIPHttpHeader()));
        }
        catch (Exception e) {
            LOG.error((Object)"Find SSOUser from IDS by SameDomain SSOSessionID error", (Throwable)e);
        }
        LOG.info((Object)("ssoUser found by SSOId[" + ssoIdInSDToken + "] in SDToken from IDS Server: " + ssoUser));
        if (ssoUser == null) {
            LOG.warn((Object)("Can not find SSOUser by SSOId[" + ssoIdInSDToken + "]"));
            sdCookieHelper.removeCookie("trsidssdssotoken", this.agent.getSDSSOCookiePath(), this.agent.getSDSSOCookieDomain());
            LOG.info((Object)"clear samedomain cookie");
            if (isAlreadyLocalLogin) {
                LOG.warn((Object)("Can not find SSOUser by sso SSOId[" + ssoIdInSDToken + "], but App is already localLogin, so excute localLogout method in actor"));
                this.agent.getServletAppActorV2().logout(req, resp);
            }
            LOG.info((Object)("localLogin status now is:[" + this.agent.getServletAppActorV2().checkLocalLogin(req, resp) + "], pass directly"));
            fc.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        SameDomainSSOHelper.plantAppCurrentLoginedSSOIDCookie((HttpServletRequest)req, (HttpServletResponse)resp, (boolean)true, (String)ssoIdInSDToken, (String)this.agent.getSDSSOCookieDomain(), (String)this.agent.getSDSSOIDSCookiePath(), (String)this.agent.getAgentName());
        this.agent.getServletAppActorV2().loadLoginUser(req, resp, ssoUser);
        LOG.info((Object)("user SSOUser[" + ssoUser.getUserName() + "] to do localLogin by actor.loadLoginUser finished"));
        LOG.info((Object)("localLogin status now is:[" + this.agent.getServletAppActorV2().checkLocalLogin(req, resp) + "], pass directly"));
        fc.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    private void excuteAutoLogin(HttpServletRequest req, HttpServletResponse resp, FilterChain fc, String coSessionId, boolean isAlreadyLocalLogin, CookieHelper sdCookieHelper) throws UnsupportedEncodingException, IOException, ServletException {
        String ckAutoLoginInfo = sdCookieHelper.getValue("idsALInfo");
        if (!StringHelper.isEmpty((String)ckAutoLoginInfo)) {
            ckAutoLoginInfo = URLDecoder.decode(ckAutoLoginInfo, "GBK");
            ckAutoLoginInfo = ckAutoLoginInfo.replace('*', '=');
        }
        String ckSourceName = sdCookieHelper.getValue("idsALUserSource");
        String ckUsr = null;
        String ckPwd = null;
        if (ckAutoLoginInfo != null && ckAutoLoginInfo.trim().length() > 0) {
            if (isAlreadyLocalLogin) {
                LOG.debug((Object)"autoLoginCookie is found, and App is already localLogoin, so pass directly");
                fc.doFilter((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            ckUsr = LoginEncoder.decodeUser((String)ckAutoLoginInfo);
            ckPwd = LoginEncoder.decodePwd((String)ckAutoLoginInfo);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("(ckAutoLoginInfo, usr, pwd, sourceName)=" + ckAutoLoginInfo + ", " + ckUsr + ", " + ckPwd + ", sourceName: " + ckSourceName));
            }
        }
        LoginResult lr = new LoginResult();
        lr = this.agent.loginUserForSameDomainSSO(ckUsr, ckPwd, ckSourceName, coSessionId, RequestUtil.getRemoteAddr((HttpServletRequest)req, (String)this.agent.getOriginalClientIPHttpHeader()));
        if (lr.isSuccess()) {
            String sdTokenInLoginResult = lr.getSdToken();
            String ssoId = SameDomainSSOHelper.getSSOIdFromSDToken((String)sdTokenInLoginResult);
            SameDomainSSOHelper.plantSameDomainCookie((HttpServletRequest)req, (HttpServletResponse)resp, (String)sdTokenInLoginResult, (boolean)true, (String)this.agent.getSDSSOCookieDomain(), (String)this.agent.getSDSSOCookiePath(), (String)this.agent.getOriginalHostHttpHeader());
            SameDomainSSOHelper.plantIDSCookie((HttpServletRequest)req, (HttpServletResponse)resp, (boolean)true, (String)ssoId, (String)this.agent.getSDSSOCookieDomain(), (String)this.agent.getSDSSOIDSCookiePath(), (String)this.agent.getOriginalHostHttpHeader());
            SSOUser ssoUser = lr.getSSOUser();
            if (ssoUser == null) {
                LOG.warn((Object)"Login in IDS OK, but SSOUser from IDS is null!");
            }
            SameDomainSSOHelper.plantAppCurrentLoginedSSOIDCookie((HttpServletRequest)req, (HttpServletResponse)resp, (boolean)true, (String)ssoId, (String)this.agent.getSDSSOCookieDomain(), (String)this.agent.getSDSSOIDSCookiePath(), (String)this.agent.getAgentName());
            this.agent.getServletAppActorV2().loadLoginUser(req, resp, ssoUser);
            LOG.info((Object)"localLogin by actor done with autoLoing");
            resp.sendRedirect(req.getRequestURL().toString());
            return;
        }
        this.clearAutoLoginCookie(req, resp);
        LOG.warn((Object)"AutoLogin with auto login cookie fail");
    }

    public void clearAutoLoginCookie(HttpServletRequest req, HttpServletResponse resp) {
        Cookie cookieUser = new Cookie("idsALInfo", "");
        Cookie cookieSource = new Cookie("idsALUserSource", "");
        if (cookieUser != null) {
            cookieUser.setMaxAge(0);
            cookieUser.setDomain(this.agent.getSDSSOCookieDomain());
            cookieUser.setPath(this.agent.getSDSSOCookiePath());
            resp.addCookie(cookieUser);
        }
        if (cookieSource != null) {
            cookieUser.setMaxAge(0);
            cookieSource.setDomain(this.agent.getSDSSOCookieDomain());
            cookieSource.setPath(this.agent.getSDSSOCookiePath());
            resp.addCookie(cookieSource);
        }
    }

    private void processSSOLoginByLocalPage(FilterChain fc, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (!this.agent.isAllowAnonymous()) {
            LOG.info((Object)"this request is SSOLoginReqByLocalPage,but this is an notAllowAnonymous CoApp, so pass directly");
            fc.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        boolean isFromIDSAutoSubmitPage = RequestUtil.getParameterAsBool((HttpServletRequest)req, (String)"isFromIDSAutoSubmitPage");
        LOG.info((Object)("isFromIDSAutoSubmitPage: " + isFromIDSAutoSubmitPage));
        LOG.info((Object)("agent.continueLocalLoginIfUserNotFoundOnIDS(): " + this.agent.continueLocalLoginIfUserNotFoundOnIDS()));
        if (isFromIDSAutoSubmitPage && this.agent.continueLocalLoginIfUserNotFoundOnIDS()) {
            fc.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        RequestDispatcher rdProxy = req.getRequestDispatcher("/TRSIdSSSOProxyServlet");
        if (rdProxy == null) {
            throw new ServletException("The Servlet Not Found: /TRSIdSSSOProxyServlet");
        }
        rdProxy.forward((ServletRequest)req, (ServletResponse)resp);
    }

    protected VerifyReqInfo getVerifyReqInfo(HttpServletRequest req) {
        VerifyReqInfo vrInfo = new VerifyReqInfo();
        vrInfo.setUserName(req.getParameter(this.userParamOfJustVerify));
        vrInfo.setPassword(req.getParameter(this.pwdParamOfJustVerify));
        vrInfo.setClientIP(RequestUtil.getRemoteAddr((HttpServletRequest)req, (String)this.agent.getOriginalClientIPHttpHeader()));
        return vrInfo;
    }

    public void init(FilterConfig fc) throws ServletException {
        this.agent = AgentFactory.getInstance().initAndStart();
        if (this.agent == null) {
            LOG.error((Object)"get agent is null while GeneralSSOFilter init!");
            return;
        }
        ServletContext application = fc.getServletContext();
        application.setAttribute("IDSAgent", (Object)this.agent);
        String appServerInfo = RequestUtil.getServletContainerInfo((ServletContext)application);
        LOG.info((Object)("appServer: " + appServerInfo));
        this.agent.setServerInfo(appServerInfo);
        if (this.agent.isStarted()) {
            this.initFilterByAgent(fc.getServletContext());
            LOG.info((Object)("encryptAgentName=" + this.encryptAgentName + "; ignoreUrl.prefix=" + this.agent.getIgnoreUrlPrefixes() + ", servletAppActor[" + this.servletAppActor + "]"));
        }
        try {
            this.idsAgentAccessHelper = new IdsAgentAccessHelper(this.agent);
        }
        catch (Throwable t) {
            LOG.error((Object)("failed to init idsAgentAccessHelper by agent[" + this.agent + "]"), t);
        }
    }

    private void initFilterByAgent(ServletContext servletContext) {
        this.getAgentProperty();
        this.initIDSCmdProcessors();
        this.initServletAppActor(servletContext);
    }

    private void initServletAppActor(ServletContext servletContext) {
        this.servletAppActor = this.agent.getServletAppActorV2();
        if (this.servletAppActor == null) {
            throw new NullPointerException("\u534f\u4f5c\u5e94\u7528\u6ca1\u6709\u6b63\u786e\u96c6\u6210! agent.getServletAppActor() returns null!");
        }
        try {
            this.servletAppActor.start(servletContext);
        }
        catch (AbstractMethodError e) {
            LOG.error((Object)("Error while IDS GeneralSSOFilter start , please check you Actor[" + this.agent.getCoAppActorClassName() + "] implements start(ServletContext) and stop methods, whick is added in IDS Agent version v4.0"), (Throwable)e);
        }
    }

    private void getAgentProperty() {
        this.onlyProcessPrefixes = StringHelper.split((String)this.agent.getProperty("processUrl.prefix", null), (String)",");
        this.justVerifyPrefixes = StringHelper.split((String)this.agent.getProperty("verifyButNotLogin.uri", null), (String)",");
        this.userParamOfJustVerify = this.agent.getProperty("verifyButNotLogin.paramName.userName");
        this.pwdParamOfJustVerify = this.agent.getProperty("verifyButNotLogin.paramName.password");
        this.verifyFailUri = this.agent.getProperty("verifyButNotLogin.fail.uri");
        this.encryptAgentName = this.encryStr(this.agent.getAgentName());
        this.domainLevel = Integer.parseInt(this.agent.getProperty("cookie.domain.level", "0"));
    }

    protected void initIDSCmdProcessors() {
        LogoutProcessor logoutProcessor = new LogoutProcessor(this.agent);
        LoginProcessor loginProcessor = new LoginProcessor(this.agent);
        AddUserProcessor addUserProcessor = new AddUserProcessor(this.agent);
        DelUserProcessor delUserProcessor = new DelUserProcessor(this.agent);
        UpdateUserProcessor updateUserProcessor = new UpdateUserProcessor(this.agent);
        UpdateSSOUrlProcessor updateSSOUrlProcessor = new UpdateSSOUrlProcessor(this.agent);
        PingProcessor pingProcessor = new PingProcessor(this.agent);
        EnableUserProcessor enableUserProcessor = new EnableUserProcessor(this.agent);
        DisableUserProcessor disableUserProcessor = new DisableUserProcessor(this.agent);
        AddGroupProcessor addGroupProcessor = new AddGroupProcessor(this.agent);
        UpdateGroupProcessor updateGroupProcessor = new UpdateGroupProcessor(this.agent);
        DelGroupProcessor deleteGroupProcessor = new DelGroupProcessor(this.agent);
        MoveToGroupProcessor moveToGroupProcessor = new MoveToGroupProcessor(this.agent);
        RemoveFromGroupProcessor removeFromGroupProcessor = new RemoveFromGroupProcessor(this.agent);
        this.idsCmdProcessors = new HashMap();
        this.idsCmdProcessors.put(logoutProcessor.getIDSCmd(), logoutProcessor);
        this.idsCmdProcessors.put(loginProcessor.getIDSCmd(), loginProcessor);
        this.idsCmdProcessors.put(addUserProcessor.getIDSCmd(), addUserProcessor);
        this.idsCmdProcessors.put(delUserProcessor.getIDSCmd(), delUserProcessor);
        this.idsCmdProcessors.put(updateUserProcessor.getIDSCmd(), updateUserProcessor);
        this.idsCmdProcessors.put(updateSSOUrlProcessor.getIDSCmd(), updateSSOUrlProcessor);
        this.idsCmdProcessors.put(pingProcessor.getIDSCmd(), pingProcessor);
        this.idsCmdProcessors.put(enableUserProcessor.getIDSCmd(), enableUserProcessor);
        this.idsCmdProcessors.put(disableUserProcessor.getIDSCmd(), disableUserProcessor);
        this.idsCmdProcessors.put(addGroupProcessor.getIDSCmd(), addGroupProcessor);
        this.idsCmdProcessors.put(updateGroupProcessor.getIDSCmd(), updateGroupProcessor);
        this.idsCmdProcessors.put(deleteGroupProcessor.getIDSCmd(), deleteGroupProcessor);
        this.idsCmdProcessors.put(moveToGroupProcessor.getIDSCmd(), moveToGroupProcessor);
        this.idsCmdProcessors.put(removeFromGroupProcessor.getIDSCmd(), removeFromGroupProcessor);
    }

    public void destroy() {
        if (this.servletAppActor != null) {
            try {
                this.servletAppActor.stop();
            }
            catch (AbstractMethodError e) {
                LOG.error((Object)("Error while IDS GeneralSSOFilter start , please check you Actor[" + this.agent.getCoAppActorClassName() + "] implements start(ServletContext) and stop methods, whick is added  in IDS Agent version 3.5.3500"), (Throwable)e);
            }
        }
        if (this.agent != null) {
            this.agent.stop();
        }
        this.clearIDSCmdProcessors();
        LOG.info((Object)"Filter Destoryed!");
    }

    protected void clearIDSCmdProcessors() {
        if (this.idsCmdProcessors != null) {
            this.idsCmdProcessors.clear();
        }
    }

    protected IDSCmdProcessor getIDSCmdProcesser(String cmd) {
        if (this.idsCmdProcessors == null) {
            return new NullProcessor("not yet init!");
        }
        Object obj = this.idsCmdProcessors.get(cmd);
        if (obj instanceof IDSCmdProcessor) {
            return (IDSCmdProcessor)obj;
        }
        return new NullProcessor("nosuch idscmd: " + cmd);
    }

    protected void showHaltPage(HttpServletRequest req, HttpServletResponse resp, Exception ex) {
        if (ex instanceof ClientTransferException && ((ClientTransferException)((Object)ex)).getErrCode() == -102) {
            String coAppUrlNotConnectIds = this.buildCoAppUrlNotConnectIds(req, ex);
            try {
                resp.sendRedirect(coAppUrlNotConnectIds);
                return;
            }
            catch (Exception e) {
                LOG.error((Object)("fail on sendRedirect to coAppUrlNotConnectIds[" + coAppUrlNotConnectIds + "]"), (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"run error\uff0c and forward to halt error page", (Throwable)ex);
        }
        try {
            RequestDispatcher rdErr = req.getRequestDispatcher("/WEB-INF/idsHalt.jsp");
            if (rdErr == null) {
                throw new Exception("the page not exist: /WEB-INF/idsHalt.jsp");
            }
            rdErr.forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (Exception e) {
            LOG.warn((Object)"fail! use DefaultHaltResponse.", (Throwable)e);
            try {
                this.showMessagePage(resp, "TRS\u8eab\u4efd\u670d\u52a1\u5668\u505c\u6b62\u8fd0\u884c\u6216\u7f51\u7edc\u8fde\u63a5\u5b58\u5728\u6545\u969c!");
            }
            catch (IOException e1) {
                LOG.error((Object)"fail on showDefaultHaltPage!", (Throwable)e1);
            }
        }
    }

    private String buildCoAppUrlNotConnectIds(HttpServletRequest req, Exception e) {
        String coAppUrlNotConnectIds = this.agent.getProperty("coApp.url.not_connect_ids");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get coAppUrlNotConnectIds[" + coAppUrlNotConnectIds + "] by agentConfig[" + "coApp.url.not_connect_ids" + "]"));
        }
        if (StringHelper.isEmpty((String)coAppUrlNotConnectIds)) {
            coAppUrlNotConnectIds = this.agent.restoreOriginAccessUrl(req);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get coAppUrlNotConnectIds[" + coAppUrlNotConnectIds + "] to sendRedirect"), (Throwable)e);
        }
        return coAppUrlNotConnectIds;
    }

    protected boolean allowGuest(boolean matchProcessUrl) {
        if (!this.agent.isAllowAnonymous()) {
            return false;
        }
        return !matchProcessUrl;
    }

    protected void handleServerException(HttpServletResponse resp, Exception e) throws IOException {
        resp.setContentType("text/html; charset=GBK");
        PrintWriter pw = resp.getWriter();
        StringBuffer sb = new StringBuffer(256);
        sb.append("<html><head><title>TRS IDS Agent \u63d0\u793a\u4fe1\u606f</title><body>");
        sb.append("<p>\u60a8\u5df2\u6210\u529f\u767b\u5f55\u4e86\u534f\u4f5c\u5e94\u7528").append(this.agent.getAgentName()).append(", \u4f46\u662f\u8be5\u5e94\u7528\u5185\u90e8\u53d1\u751f\u4e86\u9519\u8bef!");
        sb.append("\u9519\u8bef\u4fe1\u606f: ").append(e).append("</br>");
        pw.println(sb);
        e.printStackTrace(pw);
        pw.println("</body></html>");
    }

    protected void showMessagePage(HttpServletResponse resp, String htmlMsg) throws IOException {
        resp.setContentType("text/html; charset=GBK");
        PrintWriter pw = resp.getWriter();
        StringBuffer sb = new StringBuffer(256);
        sb.append("<HTML><HEAD><TITLE>TRS\u8eab\u4efd\u670d\u52a1\u5668\uff0c" + this.agent.getAgentName() + "\u5e94\u7528</TITLE><body>");
        sb.append(htmlMsg);
        pw.println(sb);
        pw.println("</body></html>");
    }

    protected String encryStr(String origin) {
        return Base64Util.encode((String)origin);
    }

    private void processLogouRequest(HttpServletRequest req, HttpServletResponse resp, IServletAppActorV2 servletAppActor, String coSessionId, boolean sameDomain, CookieHelper ckHelper) throws IOException {
        String actualRetUrl = AgentUtil.getLogoutReturnUrl((HttpServletRequest)req, (IAgent)this.agent);
        String referURL = RequestUtil.getReferUrl((HttpServletRequest)req);
        LOG.info((Object)("isLogoutRequest(req)=true, actualRetUrl=" + actualRetUrl));
        if (sameDomain) {
            ckHelper.removeCookie("idsSDToken", "/", this.agent.getProperty("cookie.Domain", null));
        }
        AgentUtil.removeSSOBind((CookieHelper)ckHelper, (IAgent)this.agent);
        boolean logoutSuccess = true;
        try {
            logoutSuccess = this.agent.logout(coSessionId);
        }
        catch (IOException e) {
            LOG.error((Object)"I/O error", (Throwable)e);
            req.setAttribute("com.trs.ids.agent.exception", (Object)e);
            return;
        }
        if (logoutSuccess) {
            servletAppActor.logout(req, resp);
            if (resp.isCommitted()) {
                return;
            }
            this.agent.notifyTimeout(coSessionId);
            String ssoUrl = this.agent.getGlobalLoginUrl();
            if (ssoUrl == null) {
                resp.sendRedirect(actualRetUrl);
            } else {
                StringBuffer sb = new StringBuffer(160);
                sb.append(this.agent.getGlobalLoginUrl());
                sb.append("?clearAL=1&r=").append(UrlUtil.encode((String)actualRetUrl)).append("&referURL=").append(UrlUtil.encode((String)referURL)).append("&appName=").append(this.agent.getAgentName());
                resp.sendRedirect(sb.toString());
            }
        } else {
            LOG.warn((Object)("logout fail(by user)! sessId=" + coSessionId));
        }
    }

    private void processIDSRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String cmd = req.getHeader("trs-ids-cmd");
        LOG.debug((Object)("processIDSRequest cmd:" + cmd + ", by HttpConst.HEADER_IDS_CMD:" + "trs-ids-cmd"));
        IDSCmdProcessor processor = this.getIDSCmdProcesser(cmd);
        LOG.debug((Object)("getIDSCmdProcesser processor.getIDSCmd():" + processor.getIDSCmd() + ", by cmd:" + cmd));
        try {
            processor.process(req, resp);
        }
        catch (Throwable e) {
            LOG.error((Object)(processor + " process IDSCmd fail,cmd=" + req.getHeader("trs-ids-cmd")), e);
            resp.sendError(500, "process ids request(cmd=) fail ,error:" + e.getMessage() + ", errro type:" + e.getClass());
        }
    }

    private void processRegRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!StringHelper.isEmpty((String)this.agent.getRegUserFullUrl())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("regist user from " + this.agent.getAgentName()));
            }
            resp.sendRedirect(this.agent.getRegUserFullUrl());
        } else {
            resp.sendError(500, "[IDSAgent]servlet not found: " + req.getContextPath() + "/idsAgents/CoAppUserRegServlet");
        }
    }

    private void processVerifyNotLoginRequest(FilterChain fc, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        VerifyReqInfo vrInfo = this.getVerifyReqInfo(req);
        VerifyResult vrResult = this.agent.verifyUser(vrInfo);
        if (vrResult.isLegal()) {
            fc.doFilter((ServletRequest)req, (ServletResponse)resp);
        } else {
            LOG.info((Object)vrResult);
            req.setAttribute("ids.verifyUser.failInfo", (Object)vrResult.getFailInfo());
            req.getRequestDispatcher(this.verifyFailUri).forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private void processSameDomainRequest(FilterChain fc, HttpServletRequest req, HttpServletResponse resp, String coSessionId, CookieHelper ckHelper) throws IOException, ServletException {
        SSOUser ssoUser = null;
        String ssoId = ckHelper.getValue("idsSDToken");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("sameDomain. ssoId=" + ssoId));
        }
        if (ssoId != null && ssoId.trim().length() > 0) {
            try {
                ssoUser = this.agent.findSSOUser(ssoId, coSessionId, RequestUtil.getRemoteAddr((HttpServletRequest)req, (String)this.agent.getOriginalClientIPHttpHeader()));
            }
            catch (NoSuchSSOIDException e) {
                ckHelper.removeCookie("idsSDToken", "/", this.agent.getProperty("cookie.Domain", null));
            }
            catch (Exception e) {
                LOG.error((Object)("agent.findUserBySSOSessionId(" + ssoId + ", " + coSessionId + ") fail!"), (Throwable)e);
            }
            if (ssoUser != null) {
                this.servletAppActor.loadLoginUser(req, resp, ssoUser);
                if (resp.isCommitted()) {
                    return;
                }
            }
        }
        fc.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    private String getSSOUserInfoForLOG(SSOUser ssoUser) {
        String ssoUserWithoutPwd = null;
        if (ssoUser != null) {
            String ssoUserStr = ssoUser.toString();
            ssoUserWithoutPwd = ssoUserStr != null && ssoUserStr.indexOf("plainUserPwd") >= 0 ? String.valueOf(ssoUserStr.substring(0, ssoUserStr.indexOf("plainUserPwd"))) + ssoUserStr.substring(ssoUserStr.indexOf(ssoUser.getProperty("plainUserPwd")) + ssoUser.getProperty("plainUserPwd").length() + 1) : ssoUserStr;
        }
        return ssoUserWithoutPwd;
    }
}

