/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.servlet;

import com.trs.idm.client.actor.ActorException;
import com.trs.idm.client.authorization.IAuthorizationActor;
import com.trs.idm.client.authorization.processor.GetUGAProcessor;
import com.trs.idm.client.authorization.processor.GetURAProcessor;
import com.trs.idm.client.authorization.processor.IAuthorizationProcessor;
import com.trs.idm.client.authorization.processor.UpdUGAProcessor;
import com.trs.idm.client.authorization.processor.UpdURAProcessor;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AuthorizationServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(AuthorizationServiceServlet.class);
    private IAuthorizationActor actor;
    private Map processors;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String actorClassName = config.getInitParameter("Actor");
        if (StringHelper.isEmpty((String)actorClassName)) {
            logger.error((Object)"AuthorizationServiceServlet configure error,need init-param:Actor");
            return;
        }
        Object objActor = null;
        try {
            objActor = Class.forName(actorClassName).newInstance();
        }
        catch (Exception e) {
            logger.error((Object)("create actor failed,Actor Class Name :" + actorClassName), (Throwable)e);
        }
        if (objActor != null) {
            this.actor = objActor;
            this.processors = new HashMap();
            this.processors.put("112", new GetUGAProcessor(this.actor));
            this.processors.put("113", new GetURAProcessor(this.actor));
            this.processors.put("212", new UpdUGAProcessor(this.actor));
            this.processors.put("213", new UpdURAProcessor(this.actor));
            logger.info((Object)"Authorization Service started successfully!");
        } else {
            logger.error((Object)"Authorization Service started failed!");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object objProcessor;
        if (this.actor == null) {
            return;
        }
        resp.setContentType("text/xml; charset=UTF-8");
        String command = req.getParameter("command");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("command : " + command));
        }
        if ((objProcessor = this.processors.get(command)) == null) {
            logger.error((Object)("unknown command:" + command));
            return;
        }
        IAuthorizationProcessor processor = (IAuthorizationProcessor)objProcessor;
        String data = req.getParameter("data");
        String result = null;
        try {
            result = processor.process(data);
        }
        catch (ActorException e) {
            logger.error((Object)("process request failed,command=" + command + ",data=" + data), (Throwable)e);
        }
        if (!StringHelper.isEmpty((String)result)) {
            resp.getWriter().print(result);
        }
    }
}

