/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent.socket;

import com.trs.idm.interact.agent.AgentBase;
import com.trs.idm.interact.agent.ClientTransferManager;
import com.trs.idm.interact.agent.ClientTransferProxy;
import com.trs.idm.interact.agent.IClientTransfer;
import com.trs.idm.interact.agent.socket.ActiveSocketManager;
import com.trs.idm.interact.agent.socket.ErrorSocketManager;
import com.trs.idm.interact.agent.socket.IdleSocketManager;
import com.trs.idm.interact.agent.socket.SocketHost;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SocketHostManager {
    private static final Logger LOG = Logger.getLogger(ClientTransferManager.class);
    private Map serverObservers = new Hashtable();
    private ClientTransferManager clientTransferManager;
    private String hostIP;
    private int usedCount = 0;
    private int waitedCount = 0;
    private int currentWaitSize = 0;
    private int actualMaxWaitTimes;
    private int[] waitedCounts;
    private int failedCount = 0;
    private IdleSocketManager idleSocketManager = null;
    private ActiveSocketManager activeSocketManager = null;
    private ErrorSocketManager errorSocketManager = null;
    private List<ClientTransferProxy> clientProxies = new ArrayList<ClientTransferProxy>();

    public SocketHostManager(ClientTransferManager clientTransferManager, String hostIP) {
        this.clientTransferManager = clientTransferManager;
        this.hostIP = hostIP;
        this.reInitWaitedCountArray(clientTransferManager);
    }

    public void reInitWaitedCountArray(ClientTransferManager clientTransferManager) {
        this.waitedCounts = new int[clientTransferManager.getMaxRetry()];
    }

    public void start() {
        this.initStatusMgrs();
        this.openProxies();
    }

    void initStatusMgrs() {
        this.errorSocketManager = new ErrorSocketManager(this);
        this.errorSocketManager.start();
        this.idleSocketManager = new IdleSocketManager(this);
        this.idleSocketManager.start();
        this.activeSocketManager = new ActiveSocketManager(this);
        this.activeSocketManager.start();
        this.initSocketHosts();
    }

    private void initSocketHosts() {
        String[] hosts = this.clientTransferManager.getAgent().getHosts();
        int port = this.clientTransferManager.getAgent().getPort();
        int i = 0;
        while (i < hosts.length) {
            if (hosts[i] != null && hosts[i].length() > 0) {
                SocketHost observer = new SocketHost(this, hosts[i], port);
                this.serverObservers.put(hosts[i], observer);
            }
            ++i;
        }
        LOG.info((Object)(String.valueOf(this.serverObservers.size()) + "SocketServerObservers initialized!"));
    }

    public void stop() {
        this.idleSocketManager.stop();
        this.errorSocketManager.stop();
        this.activeSocketManager.stop();
        this.closeProxies();
    }

    void openProxies() {
        IClientTransfer[] clientTransfers = this.getClientTransferManager().createClientTransfers(this.hostIP);
        int i = 0;
        while (i < clientTransfers.length) {
            this.openProxy(clientTransfers[i]);
            ++i;
        }
    }

    ClientTransferProxy openProxy(IClientTransfer clientTransfer) {
        ClientTransferProxy client = new ClientTransferProxy(this.clientTransferManager, clientTransfer);
        this.clientProxies.add(client);
        this.getHost(client).onOpened();
        client.init();
        return client;
    }

    public void initProxies() {
        LOG.info((Object)("socketHostManager init with clientProxies.size[" + this.clientProxies.size() + "]"));
        for (ClientTransferProxy client : this.clientProxies) {
            client.initCoAppConfig();
        }
    }

    void closeProxies() {
        int i = 0;
        while (i < this.clientProxies.size()) {
            this.closeProxy(this.clientProxies.get(i));
            ++i;
        }
        this.clientProxies = null;
    }

    void closeProxy(ClientTransferProxy client) {
        if (client == null) {
            return;
        }
        client.close();
        this.getHost(client).onClosed();
    }

    public ClientTransferProxy[] getClients() {
        return this.clientProxies.toArray(new ClientTransferProxy[0]);
    }

    public ClientTransferProxy getClientTransfer() {
        return this._getClientTransfer(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClientTransferProxy _getClientTransfer(int triedCount) {
        int nMaxRetry = this.clientTransferManager.getMaxRetry();
        int waitTimeMs = this.clientTransferManager.getWaitTime();
        SocketHostManager socketHostManager = this;
        synchronized (socketHostManager) {
            ++this.usedCount;
            while (true) {
                ClientTransferProxy client;
                if ((client = this.idleSocketManager.getClientTransfer()) != null) {
                    if (triedCount >= 1) {
                        --this.currentWaitSize;
                    }
                    if (triedCount > this.actualMaxWaitTimes) {
                        this.actualMaxWaitTimes = triedCount;
                    }
                    this.activeSocketManager.active(client);
                    return client;
                }
                if (nMaxRetry > 5 && triedCount >= nMaxRetry) {
                    ++this.failedCount;
                    --this.currentWaitSize;
                    return null;
                }
                try {
                    ++this.waitedCount;
                    if (triedCount == 0) {
                        ++this.currentWaitSize;
                    }
                    if (triedCount < this.waitedCounts.length) {
                        int n = triedCount;
                        this.waitedCounts[n] = this.waitedCounts[n] + 1;
                    }
                    this.wait(waitTimeMs);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)("getClientTransfer wait error:" + e.getMessage()));
                }
                ++triedCount;
            }
        }
    }

    public String currentSocketsStatus() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("(Idle,Busy,Err)=");
        sb.append(this.idleSocketManager.size());
        sb.append(',');
        sb.append(this.activeSocketManager.size());
        sb.append(',');
        sb.append(this.errorSocketManager.size());
        sb.append(";");
        sb.append("(Used,Wait,Fail)=");
        sb.append(this.usedCount);
        sb.append(',');
        sb.append(this.waitedCount);
        sb.append(',');
        sb.append(this.failedCount);
        sb.append(";");
        sb.append("topWait=");
        sb.append(this.actualMaxWaitTimes);
        sb.append(".");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int socketNum = this.clientProxies.size();
        sb.append("SocketHostManager [").append(socketNum).append(" clientTransfers,");
        int i = 0;
        while (i < socketNum) {
            sb.append(i + 1).append(": ").append(this.clientProxies.get(i)).append("\n");
            ++i;
        }
        return sb.toString();
    }

    public int currentIdleSize() {
        return this.idleSocketManager.size();
    }

    public int currentActiveSize() {
        return this.activeSocketManager.size();
    }

    public int currentErrorSize() {
        return this.errorSocketManager.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failOnResponse(ClientTransferProxy client) {
        ClientTransferProxy clientTransferProxy = client;
        synchronized (clientTransferProxy) {
            this.activeSocketManager.finish(client);
            this.errorSocketManager.enter(client);
        }
    }

    public SocketHost getHost(ClientTransferProxy client) {
        if (client == null) {
            return null;
        }
        return (SocketHost)this.serverObservers.get(client.getClient().getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void successOnResponse(ClientTransferProxy client) {
        ClientTransferProxy clientTransferProxy = client;
        synchronized (clientTransferProxy) {
            this.activeSocketManager.finish(client);
            this.idleSocketManager.enter(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failOnInitialized(ClientTransferProxy client) {
        ClientTransferProxy clientTransferProxy = client;
        synchronized (clientTransferProxy) {
            this.idleSocketManager.remove(client);
            this.errorSocketManager.enter(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void successOnInitialized(ClientTransferProxy client) {
        ClientTransferProxy clientTransferProxy = client;
        synchronized (clientTransferProxy) {
            this.clientTransferManager.getAgent().addServerNodeKey(client.getClient().getNodeKeyOfIDSServer());
            this.errorSocketManager.leave(client);
            this.idleSocketManager.enter(client);
        }
    }

    public ClientTransferManager getClientTransferManager() {
        return this.clientTransferManager;
    }

    public AgentBase getAgent() {
        return this.clientTransferManager.getAgent();
    }

    public String[] getActiveHosts() {
        ArrayList<String> hosts = new ArrayList<String>();
        Iterator iterator = this.serverObservers.keySet().iterator();
        while (iterator.hasNext()) {
            SocketHost observer = (SocketHost)this.serverObservers.get(iterator.next());
            if (!observer.isActive()) continue;
            hosts.add(observer.getServerHost());
        }
        return hosts.toArray(new String[0]);
    }

    public int getActiveSize() {
        return this.currentActiveSize();
    }

    public int getErrorSize() {
        return this.currentErrorSize();
    }

    public int getIdleSize() {
        return this.currentIdleSize();
    }

    public int getClientSize() {
        return this.clientProxies.size();
    }

    public int getUsedCount() {
        return this.usedCount;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public String[] getProxies() {
        ClientTransferProxy[] clients = this.getClients();
        String[] proxies = new String[clients.length];
        int i = 0;
        while (i < clients.length) {
            proxies[i] = clients[i].toString();
            ++i;
        }
        return proxies;
    }

    public int getWaitedCount() {
        return this.waitedCount;
    }

    public String getWaitedCountArrayDetail() {
        StringBuffer sb = new StringBuffer(16);
        sb.append("Retry: ");
        int sumWaitedArray = 0;
        int i = 0;
        while (i < this.waitedCounts.length) {
            sb.append("[").append(i + 1).append("]: ").append(this.waitedCounts[i]);
            sumWaitedArray += this.waitedCounts[i];
            ++i;
        }
        if (this.waitedCount - sumWaitedArray > 0) {
            sb.append("; Others: ").append(this.waitedCount - sumWaitedArray);
        }
        return sb.toString();
    }

    public void setWaitedCount(int waitCount) {
        this.waitedCount = waitCount;
    }

    public int getCurrentWaitSize() {
        return this.currentWaitSize;
    }

    public String getClientActiveCountDetail() {
        ClientTransferProxy[] clients = this.getClients();
        StringBuffer sb = new StringBuffer(16);
        int i = 0;
        while (i < clients.length) {
            sb.append("[Client ").append(i).append("]: ").append(clients[i].getActiveCount());
            ++i;
        }
        return sb.toString();
    }

    public int getActualMaxWaitTimes() {
        return this.actualMaxWaitTimes;
    }

    public synchronized void resetIdleSockets(String host) {
        LOG.info((Object)("Idle Sockets reset invoked.host:" + host));
        ClientTransferProxy[] clientTransfers = this.idleSocketManager.removeByHost(host);
        int i = 0;
        while (i < clientTransfers.length) {
            LOG.debug((Object)(String.valueOf(clientTransfers[i].toString()) + "reset to errorSocketManager."));
            this.errorSocketManager.enter(clientTransfers[i]);
            ++i;
        }
        LOG.info((Object)("Idle Sockets reset successfully.Size=" + clientTransfers.length));
    }

    public Map getServerObservers() {
        return this.serverObservers;
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public boolean isAlive() {
        return this.currentErrorSize() == 0;
    }
}

