/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.utils.DateUtil;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.format.PeriodFormatterBuilder;

public class Moment {
    private DateTime dt;

    public Moment() {
        this.dt = new DateTime(System.currentTimeMillis());
    }

    public Moment(long milliSeconds) {
        this.dt = new DateTime(milliSeconds);
    }

    public Moment(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        this.dt = new DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
    }

    public long getTimeMillis() {
        return this.dt.getMillis();
    }

    public String toShortForm() {
        return DateUtil.formatMillis(this.getTimeMillis(), "yy-M-d H:m");
    }

    public String toMediumForm() {
        return DateUtil.formatMillis(this.getTimeMillis(), "yyyy-M-d HH:mm:ss");
    }

    public String toMonthDateWeekForm() {
        return DateUtil.formatMillis(this.getTimeMillis(), "M-d E");
    }

    public String toLongForm() {
        return DateUtil.formatMillis(this.getTimeMillis(), "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public String toFullForm() {
        return DateUtil.formatMillis(this.getTimeMillis(), "yyyy-MM-dd HH:mm:ss.SSS E");
    }

    public String toRelativeForm() {
        return this.toRelativeForm(System.currentTimeMillis());
    }

    public String toRelativeForm(long refer) {
        String suffix;
        Period period;
        Duration duration = new Duration(this.getTimeMillis(), refer);
        if (duration.getMillis() == 0L) {
            return "\u6b64\u523b";
        }
        if (duration.getMillis() > 0L) {
            period = new Period(this.getTimeMillis(), refer);
            suffix = "\u524d";
        } else {
            period = new Period(refer, this.getTimeMillis());
            suffix = "\u540e";
        }
        PeriodFormatterBuilder pfBuilder = this.calcFormatter(period);
        pfBuilder.appendSuffix(suffix);
        return period.toString(pfBuilder.toFormatter());
    }

    PeriodFormatterBuilder calcFormatter(Period period) {
        PeriodFormatterBuilder pfBuilder = new PeriodFormatterBuilder();
        if (period.getYears() > 0) {
            pfBuilder.appendYears().appendSuffix("\u5e74").printZeroNever();
        }
        if (period.getMonths() > 0) {
            pfBuilder.appendMonths().appendSuffix("\u4e2a\u6708").printZeroNever();
            return pfBuilder;
        }
        if (period.getWeeks() > 0) {
            pfBuilder.appendWeeks().appendSuffix("\u5468").printZeroNever();
        }
        if (period.getDays() > 0) {
            pfBuilder.appendDays().appendSuffix("\u5929").printZeroNever();
            return pfBuilder;
        }
        if (period.getHours() > 0) {
            pfBuilder.appendHours().appendSuffix("\u5c0f\u65f6").printZeroNever();
            return pfBuilder;
        }
        if (period.getMinutes() > 0) {
            pfBuilder.appendMinutes().appendSuffix("\u5206\u949f").printZeroNever();
            return pfBuilder;
        }
        pfBuilder.appendSeconds().appendSuffix("\u79d2");
        return pfBuilder;
    }

    public String getTimeZone() {
        return this.dt.getZone().toTimeZone().getDisplayName();
    }

    public String toString() {
        return this.toLongForm();
    }
}

