/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.job.impl;

import com.trs.dev4.jdk16.dao.PagedList;
import com.trs.dev4.jdk16.dao.SearchFilter;
import com.trs.dev4.jdk16.job.IJobDetailManager;
import com.trs.dev4.jdk16.job.IJobExecutor;
import com.trs.dev4.jdk16.job.IJobService;
import com.trs.dev4.jdk16.job.JobDetail;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.log4j.Logger;

public abstract class BaseJobService
implements IJobService {
    protected final Map<String, IJobExecutor> jobExecutors = new HashMap<String, IJobExecutor>();
    private static final Logger logger = Logger.getLogger(BaseJobService.class);
    @Resource(name="jobDetailManager")
    private IJobDetailManager jobDetailManager;

    @Override
    public String getModuleName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void start() {
        this.initializeLoader();
        this.scheduleJobs();
        logger.debug((Object)"JobService started.");
    }

    protected void initializeLoader() {
        JobDetail jobDetail = (JobDetail)this.jobDetailManager.findUnique("JOBNAME", "jobDetailLoader");
        if (jobDetail == null) {
            jobDetail = new JobDetail();
            jobDetail.setJobName("jobDetailLoader");
            jobDetail.setExecutorName("jobDetailLoader");
            jobDetail.setExecutorNode("*");
            jobDetail.setDelay(10);
            jobDetail.setPeriod(60);
            this.saveOrUpdate(jobDetail);
        }
    }

    protected abstract void cancelJob(JobDetail var1);

    @Override
    public void scheduleJob(JobDetail jobDetail) {
        logger.debug((Object)"scheduleJob invoked.");
    }

    @Override
    public void stop() {
    }

    @Override
    public void restart() {
    }

    @Override
    public void resetExecutorNode(List<JobDetail> jobDetails) {
        for (JobDetail jobDetail : jobDetails) {
            this.resetExecutorNode(jobDetail);
        }
    }

    @Override
    public void resetExecutorNode(JobDetail jobDetail) {
        this.jobDetailManager.saveOrUpdate(jobDetail);
    }

    @Override
    public void saveOrUpdate(JobDetail jobDetail) {
        this.jobDetailManager.saveOrUpdate(jobDetail);
    }

    @Override
    public List<String> listExecutorNames() {
        return Arrays.asList(this.jobExecutors.keySet().toArray(new String[0]));
    }

    @Override
    public IJobExecutor getJobExecutor(String name) {
        return this.jobExecutors.get(name);
    }

    @Override
    public void delete(JobDetail jobDetail) {
        this.jobDetailManager.delete(jobDetail);
    }

    @Override
    public List<JobDetail> listAllAvailableJobs() {
        ArrayList<JobDetail> jobDetails = new ArrayList<JobDetail>();
        SearchFilter sfCurrent = SearchFilter.getDefault();
        sfCurrent.setMaxResults(-1);
        sfCurrent.addEqCondition("EXECUTORNODE", this.getNodeName());
        jobDetails.addAll(this.jobDetailManager.pagedObjects(sfCurrent).getPageItems());
        SearchFilter sfCommon = SearchFilter.getDefault();
        sfCommon.setMaxResults(-1);
        sfCommon.addEqCondition("EXECUTORNODE", "*");
        jobDetails.addAll(this.jobDetailManager.pagedObjects(sfCommon).getPageItems());
        if (this.isMaster()) {
            SearchFilter sfMaster = SearchFilter.getDefault();
            sfMaster.setMaxResults(-1);
            sfMaster.addEqCondition("EXECUTORNODE", "-");
            jobDetails.addAll(this.jobDetailManager.pagedObjects(sfMaster).getPageItems());
        }
        return jobDetails;
    }

    protected boolean isMaster() {
        return true;
    }

    protected String getNodeName() {
        return "127.0.0.1";
    }

    @Override
    public PagedList<JobDetail> pagedJobs(SearchFilter searchFilter) {
        return this.jobDetailManager.pagedObjects(searchFilter);
    }

    IJobExecutor getExecutor(JobDetail jobDetail) {
        String executorName = jobDetail.getExecutorName();
        return this.getJobExecutor(executorName);
    }

    @Override
    public void registerExecutor(IJobExecutor jobExecutor) {
        this.jobExecutors.put(jobExecutor.getName(), jobExecutor);
    }

    @Override
    public void scheduleJobs() {
        List<JobDetail> jobDetails = this.listAllAvailableJobs();
        this.preSchedule();
        for (JobDetail jobDetail : jobDetails) {
            this.scheduleJob(jobDetail);
        }
        this.postScheduled();
    }

    protected void preSchedule() {
    }

    protected void postScheduled() {
    }

    @Override
    public List<JobDetail> listScheduledJobs() {
        return new ArrayList<JobDetail>();
    }

    @Override
    public boolean existsJob(String jobName) {
        return false;
    }

    @Override
    public boolean existsExecutor(String executorName) {
        return this.jobExecutors.containsKey(executorName);
    }

    public void setJobDetailManager(IJobDetailManager jobDetailManager) {
        this.jobDetailManager = jobDetailManager;
    }

    @Override
    public int countExecutors() {
        return this.jobExecutors.size();
    }
}

