/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.cacheserver;

import com.thimbleware.jmemcached.Cache;
import com.thimbleware.jmemcached.MemCacheDaemon;
import com.thimbleware.jmemcached.storage.CacheStorage;
import com.thimbleware.jmemcached.storage.hash.LRUCacheStorageDelegate;
import com.trs.dev4.jdk16.model.IModuleLifecycle;
import java.io.IOException;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMemcacheServer
implements IModuleLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(JMemcacheServer.class);
    MemCacheDaemon daemon = new MemCacheDaemon();

    @Override
    public void start() {
        LRUCacheStorageDelegate cacheStorage = new LRUCacheStorageDelegate(2048000, 2048000L, 1024000L);
        this.daemon.setCache(new Cache((CacheStorage)cacheStorage));
        this.daemon.setAddr(AddrUtil.getOneAddress((String)"127.0.0.1:12111"));
        this.daemon.setReceiveBufferSize(1024);
        this.daemon.setSendBufferSize(1024);
        this.daemon.setVerbose(true);
        this.daemon.setBinary(false);
        try {
            this.daemon.start();
            logger.info("JMemcache Server started successfully@127.0.0.1:12111");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void stop() {
        if (this.daemon != null) {
            this.daemon.stop();
            logger.info("JMemcache Server stop successfully.");
        }
    }

    @Override
    public String getModuleName() {
        return "JMemcacheServer";
    }

    @Override
    public void restart() {
    }
}

