/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.model.impl;

import com.trs.dev4.jdk16.dao.PagedList;
import com.trs.dev4.jdk16.dao.SearchFilter;
import com.trs.dev4.jdk16.exception.BussinessException;
import com.trs.dev4.jdk16.exception.ConfigException;
import com.trs.dev4.jdk16.exception.ValidateAssertionException;
import com.trs.dev4.jdk16.model.BaseManager;
import com.trs.dev4.jdk16.model.Configuration;
import com.trs.dev4.jdk16.model.GroupedConfiguration;
import com.trs.dev4.jdk16.model.IConfigurable;
import com.trs.dev4.jdk16.model.IConfigurationManager;
import com.trs.dev4.jdk16.model.IModuleLifecycle;
import com.trs.dev4.jdk16.model.ValidationErrors;
import com.trs.dev4.jdk16.thread.DaemonThreadControllor;
import com.trs.dev4.jdk16.thread.IThreadWorkload;
import com.trs.dev4.jdk16.utils.AssertUtil;
import com.trs.dev4.jdk16.utils.CollectionUtil;
import com.trs.dev4.jdk16.utils.NumberUtil;
import com.trs.dev4.jdk16.utils.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.util.StringHelper;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(objectName="dev4:name=configurationManager")
public class ConfigurationManager
extends BaseManager<Configuration>
implements IConfigurationManager,
IModuleLifecycle {
    public static final String SPEARATOR_FOR_MVC = "_";
    private static final Logger LOG = Logger.getLogger(ConfigurationManager.class);
    private DaemonThreadControllor reloadThread;
    private Map<String, Map<String, Configuration>> configurationIndexes = new HashMap<String, Map<String, Configuration>>();
    private Map<String, IConfigurable> configurables = new HashMap<String, IConfigurable>();

    public Map<String, IConfigurable> getConfigurables() {
        return this.configurables;
    }

    public void setConfigurables(Map<String, IConfigurable> configurables) {
        this.configurables = configurables;
    }

    @Override
    public void start() {
        this.loadConfigs();
        this.reloadThread = new DaemonThreadControllor();
        this.reloadThread.start("ConfigurationManager-reloadThread", 300, new IThreadWorkload(){

            @Override
            public void onExecute() {
                ConfigurationManager.this.loadConfigs();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfigs() {
        List configurations = this.getAccessor().listObjects();
        ConfigurationManager configurationManager = this;
        synchronized (configurationManager) {
            this.configurationIndexes.clear();
            for (Configuration configuration : configurations) {
                this.loadConfiguration(configuration);
            }
        }
        LOG.debug((Object)("Loaded (" + configurations.size() + ") configurations."));
    }

    private void loadConfiguration(Configuration configuration) {
        Map<String, Configuration> moduleConfigurations;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Name=" + configuration.getName() + ",Value=" + configuration.getValue()));
        }
        if ((moduleConfigurations = this.configurationIndexes.get(configuration.getPrefix())) == null) {
            moduleConfigurations = new Hashtable<String, Configuration>();
            this.configurationIndexes.put(configuration.getPrefix(), moduleConfigurations);
        }
        moduleConfigurations.put(configuration.getName(), configuration);
    }

    @Override
    public void stop() {
        this.configurationIndexes.clear();
        if (this.reloadThread != null) {
            this.reloadThread.stop(1000L);
        }
    }

    @Override
    public void update(Configuration configuration) {
        this.update(configuration, true);
    }

    private void update(Configuration configuration, boolean notify) {
        IConfigurable configurable;
        AssertUtil.notNull(configuration, "configuration is null");
        if (configuration.isForbidModify()) {
            throw new BussinessException(configuration + " update forbid.");
        }
        this.getAccessor().update(configuration);
        this.loadConfiguration(configuration);
        if (notify && (configurable = this.configurables.get(configuration.getPrefix())) != null) {
            LOG.info((Object)("notify Configurable(" + configurable + ") to refreshConfigs."));
            configurable.refreshConfigs();
        }
    }

    @Override
    public int getConfigurationAsInt(IConfigurable configurable, String name) {
        String strValue = this.getConfiguration(configurable, name);
        return NumberUtil.parseInt(strValue);
    }

    @Override
    public long getConfigurationAsLong(IConfigurable configurable, String name) {
        String strValue = this.getConfiguration(configurable, name);
        return NumberUtil.parseLong(strValue);
    }

    @Override
    public void addSetupKey(IConfigurable configurable, String name, String cname, String comment) {
        this.addSetupKey(configurable, name, cname, comment, null);
    }

    @Override
    public void addSetupKey(IConfigurable configurable, String name, String cname, String comment, String value) {
        Configuration configuration = this._getConfiguration(configurable, name);
        if (configuration != null) {
            this.updateDisplayName(configuration, cname, comment);
            return;
        }
        configuration = this.buildConfiguration(configurable, name, cname);
        configuration.setNeedSetup(true);
        configuration.setComment(comment);
        if (value != null) {
            configuration.setValue(value);
        }
        this.insert(configuration);
    }

    private void insert(Configuration configuration) {
        this.getAccessor().insert(configuration);
        this.loadConfiguration(configuration);
    }

    @Override
    public void addConfigKey(IConfigurable configurable, String name, String cname, String comment, String defValue) {
        Configuration configuration = this._getConfiguration(configurable, name);
        if (configuration != null) {
            this.updateDisplayName(configuration, cname, comment);
            return;
        }
        configuration = this.buildConfiguration(configurable, name, cname);
        configuration.setComment(comment);
        configuration.setDefaultValue(defValue);
        if (defValue != null) {
            configuration.setValue(defValue);
        }
        this.insert(configuration);
    }

    @Override
    @Deprecated
    public void addConfigKey(IConfigurable configurable, String name, String cname) {
        this.addConfigKey(configurable, name, cname, null);
    }

    @Override
    @Deprecated
    public void addConfigKey(IConfigurable configurable, String name, String cname, String defValue) {
        this.addConfigKey(configurable, name, cname, null, defValue);
    }

    @Override
    public void deleteKey(IConfigurable configurable, String name) {
        Configuration configuration = this._getConfiguration(configurable, name);
        if (configuration == null) {
            return;
        }
        this.getAccessor().delete(configuration);
        this.loadConfigs();
    }

    @Override
    public void updateConfigValue(IConfigurable configurable, String name, Object value) {
        Configuration configuration = this._getConfiguration(configurable, name);
        if (configuration != null) {
            configuration.setValueFromObject(value);
            this.getAccessor().update(configuration);
        } else {
            configuration = this.buildConfiguration(configurable, name, value);
            this.getAccessor().insert(configuration);
        }
        configurable.refreshConfigs();
        this.loadConfiguration(configuration);
    }

    @Override
    public void updateConfigMetadata(IConfigurable configurable, String name, Boolean forbidModify, Boolean needEncrypt) {
        Configuration configuration = this._getConfiguration(configurable, name);
        if (configuration == null) {
            return;
        }
        if (forbidModify != null) {
            configuration.setForbidModify(forbidModify);
        }
        if (needEncrypt != null) {
            configuration.setNeedEncrypt(needEncrypt);
        }
        this.getAccessor().update(configuration);
        this.loadConfiguration(configuration);
    }

    @Override
    public void updateConfigValue(IConfigurable configurable, Configuration configWithNewValue) {
        if (configWithNewValue == null) {
            return;
        }
        this.updateConfigValue(configurable, configWithNewValue.getName(), configWithNewValue.getValue());
    }

    @Override
    public void updateModuleConfigs(String prefix, List<Configuration> moduleConfigs) {
        Map<String, Configuration> map = this.convertToMap(moduleConfigs, prefix);
        this.updateModuleConfigs(prefix, map);
    }

    @Override
    public void updateModuleConfigs(String prefix, Map<String, Configuration> moduleConfigs) {
        IConfigurable configurable = this.lookupConfigurable(prefix);
        if (configurable == null) {
            throw new ConfigException("No such configurable! prefix: [" + prefix + "]");
        }
        ValidationErrors errors = configurable.validateConfigs(moduleConfigs);
        AssertUtil.notNull(errors, "ValidationErrors should not null!");
        if (errors.hasErrors()) {
            throw new ValidateAssertionException("\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u4e0d\u80fd\u4fdd\u5b58[" + configurable + "]\u7684\u914d\u7f6e: " + errors);
        }
        Collection<Configuration> configs = moduleConfigs.values();
        for (Configuration configuration : configs) {
            if (configuration.isForbidModify()) continue;
            this.update(configuration, false);
        }
        LOG.info((Object)("notify Configurable(" + configurable + ") to refreshConfigs."));
        configurable.refreshConfigs();
    }

    @Override
    public void updateModuleConfigs(GroupedConfiguration groupedConfiguration) {
        this.updateModuleConfigs(groupedConfiguration.getPrefix(), groupedConfiguration.getListConfigs());
    }

    private IConfigurable lookupConfigurable(String prefix) {
        if (prefix == null) {
            return null;
        }
        return this.configurables.get(prefix);
    }

    private void updateDisplayName(Configuration configuration, String displayName, String comment) {
        if (ObjectUtil.equals(configuration.getCname(), displayName) && ObjectUtil.equals(configuration.getComment(), comment)) {
            return;
        }
        configuration.setCname(displayName);
        configuration.setComment(comment);
        this.getAccessor().update(configuration);
    }

    private Configuration buildConfiguration(IConfigurable configurable, String name, String cname) {
        Configuration configuration = new Configuration();
        configuration.setPrefix(configurable.getPrefix());
        configuration.setName(name);
        if (cname != null) {
            configuration.setCname(cname);
        }
        return configuration;
    }

    private Configuration buildConfiguration(IConfigurable configurable, String name, Object value) {
        Configuration configuration = this.buildConfiguration(configurable, name, null);
        configuration.setValueFromObject(value);
        return configuration;
    }

    private Configuration _getConfiguration(IConfigurable configurable, String name) {
        String prefix;
        Map<String, Configuration> moduleConfigurations;
        if (this.lookupConfigurable(configurable.getPrefix()) == null) {
            this.registerConfigurable(configurable);
        }
        if ((moduleConfigurations = this.configurationIndexes.get(prefix = configurable.getPrefix())) == null) {
            return null;
        }
        return moduleConfigurations.get(name);
    }

    Map<String, Configuration> loadModuleConfigurations(IConfigurable configurable) {
        SearchFilter searchFilter = SearchFilter.getDefault();
        searchFilter.addEqCondition("prefix", configurable.getPrefix());
        PagedList configurations = this.getAccessor().pagedObjects(searchFilter);
        for (Configuration configuration : configurations.getPageItems()) {
            this.loadConfiguration(configuration);
        }
        return this.configurationIndexes.get(configurable.getPrefix());
    }

    @Override
    public String getConfiguration(IConfigurable configurable, String name) {
        Configuration configuration = this._getConfiguration(configurable, name);
        if (configuration == null) {
            return null;
        }
        return configuration.getValue();
    }

    @Override
    public boolean existsOrConfigured(IConfigurable configurable, String name) {
        Configuration configuration = this._getConfiguration(configurable, name);
        if (configuration == null) {
            SearchFilter sf = SearchFilter.getNoPagedFilter();
            sf.addEqCondition("PREFIX", configurable.getPrefix());
            sf.addEqCondition("NAME", name);
            return super.findFirst(sf) != null;
        }
        return true;
    }

    @Override
    public List<Configuration> list(IConfigurable configurable) {
        String prefix = configurable.getPrefix();
        return this.listModuleConfigs(prefix);
    }

    @Override
    public Map<String, Configuration> extractModuleConfig(IConfigurable configurable, List<Configuration> configs) {
        if (configs == null || configurable == null) {
            return null;
        }
        String prefix = configurable.getPrefix();
        ArrayList<Configuration> moduleConfigs = new ArrayList<Configuration>();
        for (Configuration configuration : configs) {
            if (!ObjectUtil.equals(configuration.getPrefix(), prefix)) continue;
            moduleConfigs.add(configuration);
        }
        return this.convertToMap(moduleConfigs, prefix);
    }

    @Override
    public Map<String, Configuration> addPrefixToModuleConfig(String prefix, Map<String, Configuration> cfgMap) {
        AssertUtil.notNull(prefix, "prefix is null.");
        AssertUtil.notNull(cfgMap, "cfgMap is null.");
        HashMap<String, Configuration> resultMap = new HashMap<String, Configuration>();
        for (String key : cfgMap.keySet()) {
            Configuration configuration = cfgMap.get(key);
            resultMap.put(String.valueOf(prefix) + SPEARATOR_FOR_MVC + key, configuration);
        }
        return resultMap;
    }

    @Override
    public Map<String, Configuration> extractModuleConfig(String prefix, Map<String, Configuration> cfgMap) {
        AssertUtil.notNull(prefix, "prefix is null.");
        AssertUtil.notNull(cfgMap, "cfgMap is null.");
        HashMap<String, Configuration> resultMap = new HashMap<String, Configuration>();
        for (String keyFqn : cfgMap.keySet()) {
            if (!keyFqn.startsWith(String.valueOf(prefix) + SPEARATOR_FOR_MVC)) continue;
            Configuration configuration = cfgMap.get(keyFqn);
            resultMap.put(configuration.getName(), configuration);
        }
        return resultMap;
    }

    @Override
    public Map<String, Configuration> extractModuleConfig(IConfigurable configurable, Map<String, Configuration> cfgMap) {
        AssertUtil.notNull(configurable, "configurable is null.");
        String prefix = configurable.getPrefix();
        AssertUtil.notNull(prefix, "the prefix of " + configurable.getClass().getName() + " is null.");
        return this.extractModuleConfig(prefix, cfgMap);
    }

    @Override
    public Map<String, Configuration> toMapWithPrefixs(List<Configuration> configs) {
        HashMap<String, Configuration> resultMap = new HashMap<String, Configuration>();
        for (Configuration configuration : configs) {
            resultMap.put(String.valueOf(configuration.getPrefix()) + SPEARATOR_FOR_MVC + configuration.getName(), configuration);
        }
        return resultMap;
    }

    private Map<String, Configuration> convertToMap(List<Configuration> configs, String prefix) {
        if (CollectionUtil.isEmpty(configs)) {
            return null;
        }
        GroupedConfiguration groupedCfg = new GroupedConfiguration(configs);
        return groupedCfg.getMapConfigs();
    }

    @Override
    public List<Configuration> listModuleConfigs(String prefix) {
        Map<String, Configuration> map = this.getModuleConfigs(prefix);
        return new ArrayList<Configuration>(map.values());
    }

    @Override
    public Map<String, Configuration> getModuleConfigs(String prefix) {
        return this.configurationIndexes.get(prefix);
    }

    @Override
    public String getValueFromModuleConfigMap(Map<String, Configuration> configs, String nameWithoutPrefix) {
        Configuration configuration = configs.get(nameWithoutPrefix);
        if (configuration == null) {
            return null;
        }
        return configuration.getValue();
    }

    @Override
    public boolean containsModuleConfigName(Map<String, Configuration> configs, String nameWithoutPrefix) {
        Configuration configuration = configs.get(nameWithoutPrefix);
        return configuration != null;
    }

    @Override
    public List<IConfigurable> listKnownConfigurable() {
        return Arrays.asList(this.configurables.values().toArray(new IConfigurable[0]));
    }

    @Override
    public void registerConfigurable(IConfigurable configurable) {
        this.configurables.put(configurable.getPrefix(), configurable);
        LOG.info((Object)("IConfigurable (" + configurable + ") registered to configurationManager(" + this + ") with prefix(" + configurable.getPrefix() + "). "));
    }

    @Override
    public List<Configuration> listNeedSetup() {
        SearchFilter sf = this.buildBaseSetupCondition();
        return this.getAccessor().listObjects(sf);
    }

    private SearchFilter buildBaseSetupCondition() {
        SearchFilter sf = SearchFilter.getNoPagedFilter();
        sf.addEqCondition("needSetup", true);
        return sf;
    }

    @Override
    public List<Configuration> listExistedConfig() {
        return this.getAccessor().listObjects();
    }

    @Override
    public List<Configuration> listExistedSetupConfig() {
        SearchFilter sf = this.buildBaseSetupCondition();
        sf.addNotNullCondition("value");
        return this.getAccessor().listObjects(sf);
    }

    @Override
    public List<Configuration> listMissingSetupConfig() {
        SearchFilter sf = this.buildBaseSetupCondition();
        sf.addIsNullCondition("value");
        return this.getAccessor().listObjects(sf);
    }

    @Override
    public Configuration find(int id) {
        return (Configuration)this.getAccessor().getObject(id);
    }

    @Override
    public PagedList<Configuration> pagedObjects(SearchFilter sf) {
        return this.getAccessor().pagedObjects(sf);
    }

    @Override
    public IConfigurable getConfigurable(String prefix) {
        if (StringHelper.isEmpty((String)prefix)) {
            return null;
        }
        return this.configurables.get(prefix);
    }

    @Override
    public void update(List<Configuration> configurations) {
        for (Configuration configuration : configurations) {
            String prefix = configuration.getPrefix();
            IConfigurable configurable = this.getConfigurable(prefix);
            if (configurable == null) continue;
            this.updateConfigValue(configurable, configuration);
        }
    }

    @Override
    public String getConfiguration(IConfigurable configurable, String name, Object defValue) {
        String configurationValue = this.getConfiguration(configurable, name);
        return configurationValue == null ? defValue.toString() : configurationValue;
    }

    @Override
    public int getConfigurationAsInt(IConfigurable configurable, String name, int defValue) {
        String configurationValue = this.getConfiguration(configurable, name);
        return configurationValue == null ? defValue : NumberUtil.parseInt(configurationValue);
    }

    @Override
    public long getConfigurationAsLong(IConfigurable configurable, String name, long defValue) {
        String configurationValue = this.getConfiguration(configurable, name);
        return configurationValue == null ? defValue : NumberUtil.parseLong(configurationValue);
    }

    @Override
    public String getModuleName() {
        return "ConfigurationManager";
    }

    @ManagedOperation
    public List<String> listConfigurableNames() {
        ArrayList<String> configurableNames = new ArrayList<String>();
        for (IConfigurable configurable : this.configurables.values()) {
            configurableNames.add(configurable.getClass().getName());
        }
        return configurableNames;
    }

    @ManagedOperation
    public Map<String, String> listConfigurations() {
        HashMap<String, String> configurations = new HashMap<String, String>();
        for (String configurablePrefix : this.configurationIndexes.keySet()) {
            Map<String, Configuration> moduleConfiguations = this.configurationIndexes.get(configurablePrefix);
            if (moduleConfiguations == null) continue;
            for (String configurationName : moduleConfiguations.keySet()) {
                configurations.put(String.valueOf(configurablePrefix) + SPEARATOR_FOR_MVC + configurationName, moduleConfiguations.get(configurationName).getValue());
            }
        }
        return configurations;
    }

    @ManagedOperation
    public Map<String, String> listConfigurations(String prefix) {
        HashMap<String, String> configurations = new HashMap<String, String>();
        Map<String, Configuration> moduleConfiguations = this.configurationIndexes.get(prefix);
        if (moduleConfiguations == null) {
            return configurations;
        }
        for (String configurationName : moduleConfiguations.keySet()) {
            configurations.put(String.valueOf(prefix) + SPEARATOR_FOR_MVC + configurationName, moduleConfiguations.get(configurationName).getValue());
        }
        return configurations;
    }

    @Override
    public void restart() {
        this.loadConfigs();
    }

    @Override
    public boolean getConfigurationAsBoolean(IConfigurable configurable, String name, boolean defValue) {
        String strValue = this.getConfiguration(configurable, name);
        return StringHelper.isEmpty((String)strValue) ? defValue : Boolean.valueOf(strValue);
    }
}

