/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.mina.impl;

import com.trs.dev4.jdk16.mina.IMessage;
import com.trs.dev4.jdk16.mina.IMessageHandler;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageServerSessionHandler
extends IoHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(MessageServerSessionHandler.class);
    private Map<String, IMessageHandler> messageHandlers;
    private int receivedCount = 0;
    private int divisor = 10;
    private long totalTime = 0L;
    private IMessage[] recentMessages = new IMessage[this.divisor];
    private SortedMap<Long, IMessage> maxTimeMessages;
    private IMessage[] failedMessages = new IMessage[this.divisor];

    public MessageServerSessionHandler() {
        this.maxTimeMessages = new TreeMap<Long, IMessage>();
    }

    public void updateRecentMessages(IMessage message) {
        int position = this.receivedCount % this.divisor;
        this.recentMessages[position] = message;
    }

    public void updateFailedMessages(IMessage message) {
        this.failedMessages[this.receivedCount % this.divisor] = message;
    }

    public void updateMaxTimeMassages(IMessage message, long time) {
        try {
            if (this.maxTimeMessages.isEmpty()) {
                this.maxTimeMessages.put(time, message);
            } else if (this.maxTimeMessages.size() < this.divisor) {
                this.maxTimeMessages.put(time, message);
            } else if (this.maxTimeMessages.lastKey() < time) {
                this.maxTimeMessages.remove(this.maxTimeMessages.firstKey());
                this.maxTimeMessages.put(time, message);
            }
        }
        catch (NoSuchElementException e) {
            logger.error("Method maxTimeMassages Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void messageReceived(IoSession session, Object message) {
        long beginTime = System.currentTimeMillis();
        IMessage am = (IMessage)message;
        this.updateRecentMessages(am);
        ++this.receivedCount;
        Map<String, IMessageHandler> messageHandlers = this.messageHandlers;
        IMessageHandler messageHandler = messageHandlers.get(am.getClass().getName());
        IMessage mr = messageHandler.messageReceived(am);
        try {
            session.write((Object)mr);
        }
        catch (RuntimeException e) {
            this.updateFailedMessages(am);
            logger.error("MessageServerSessionHandler write failure:" + e.getMessage(), (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        long costTime = endTime - beginTime;
        this.updateMaxTimeMassages(am, costTime);
        this.totalTime += costTime;
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        logger.error("ServerSessionHandler exception:" + cause.getMessage(), cause);
        session.close(true);
    }

    public Map<String, IMessageHandler> getMessageHandlers() {
        return this.messageHandlers;
    }

    public void setMessageHandlers(Map<String, IMessageHandler> messageHandlers) {
        this.messageHandlers = messageHandlers;
    }

    public int getDivisor() {
        return this.divisor;
    }

    public void setDivisor(int divisor) {
        if (divisor != 0) {
            this.divisor = divisor;
        }
    }
}

