/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.util;

public class EnvUtil {
    private static final boolean isIBMJDK = EnvUtil.vendorIsIBM();
    private static final String jdkVer = EnvUtil.detectJDKVersion();
    private static final boolean jdk13OrHigher;
    private static final boolean jdk14OrHigher;
    private static final boolean jdk15OrHigher;
    private static final boolean jdk16OrHigher;

    static {
        double dJdkVer = Double.parseDouble(jdkVer);
        jdk13OrHigher = dJdkVer >= 1.3;
        jdk14OrHigher = dJdkVer >= 1.4;
        jdk15OrHigher = dJdkVer >= 1.5;
        jdk16OrHigher = dJdkVer >= 1.6;
    }

    public static boolean isIBMJDK() {
        return isIBMJDK;
    }

    public static boolean isJDK14OrHigher() {
        return jdk14OrHigher;
    }

    public static boolean isJDK13OrHigher() {
        return jdk13OrHigher;
    }

    public static boolean isJDK15OrHigher() {
        return jdk15OrHigher;
    }

    public static boolean isJDK16OrHigher() {
        return jdk16OrHigher;
    }

    public static String getJDKVersion() {
        return jdkVer;
    }

    private EnvUtil() {
    }

    private static final boolean vendorIsIBM() {
        return System.getProperty("java.vendor").toUpperCase().indexOf("IBM") >= 0;
    }

    private static final String detectJDKVersion() {
        String jdkVer = "1.0";
        try {
            Class.forName("java.lang.Void");
            jdkVer = "1.1";
            Class.forName("java.lang.ThreadLocal");
            jdkVer = "1.2";
            Class.forName("java.lang.StrictMath");
            jdkVer = "1.3";
            Class.forName("java.lang.StackTraceElement");
            jdkVer = "1.4";
            Class.forName("java.lang.Enum");
            jdkVer = "1.5";
            Class.forName("javax.script.Bindings");
            jdkVer = "1.6";
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return jdkVer;
    }
}

