/*
 * Decompiled with CFR 0.152.
 */
package com.trs.util.dbcp.impl;

import com.trs.util.dbcp.impl.ConnectionWrapper;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

class ImplConnection
implements Connection {
    private Connection m_actualConn;
    private volatile ConnectionWrapper m_wrapedConn;

    ImplConnection(Connection conn) {
        this.m_actualConn = conn;
        this.m_wrapedConn = null;
    }

    ImplConnection(ConnectionWrapper cw) {
        this.m_actualConn = cw.getConnection();
        this.m_wrapedConn = cw;
    }

    private void assertOpen() throws SQLException {
        if (this.m_actualConn == null) {
            throw new SQLException("Attempted to use Connection after closed() was called.");
        }
    }

    public void clearWarnings() throws SQLException {
        this.assertOpen();
        this.m_actualConn.clearWarnings();
    }

    public void close() throws SQLException {
        this.assertOpen();
        this.m_actualConn = null;
        ConnectionWrapper cw = this.m_wrapedConn;
        this.m_wrapedConn = null;
        if (cw != null) {
            cw.recycle();
        }
    }

    public void commit() throws SQLException {
        this.assertOpen();
        this.m_actualConn.commit();
    }

    public Statement createStatement() throws SQLException {
        this.assertOpen();
        return this.m_actualConn.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpen();
        return this.m_actualConn.createStatement(resultSetType, resultSetConcurrency);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpen();
        return this.m_actualConn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public boolean getAutoCommit() throws SQLException {
        this.assertOpen();
        return this.m_actualConn.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.assertOpen();
        return this.m_actualConn.getCatalog();
    }

    public int getHoldability() throws SQLException {
        this.assertOpen();
        return this.m_actualConn.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.assertOpen();
        return this.m_actualConn.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this.assertOpen();
        return this.m_actualConn.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.assertOpen();
        return this.m_actualConn.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.assertOpen();
        return this.m_actualConn.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this.m_actualConn == null;
    }

    public boolean isReadOnly() throws SQLException {
        this.assertOpen();
        return this.m_actualConn.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        this.assertOpen();
        return this.m_actualConn.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.assertOpen();
        return this.m_actualConn.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpen();
        return this.m_actualConn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpen();
        return this.m_actualConn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.assertOpen();
        return this.m_actualConn.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.assertOpen();
        return this.m_actualConn.prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpen();
        return this.m_actualConn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpen();
        return this.m_actualConn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.assertOpen();
        return this.m_actualConn.prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.assertOpen();
        return this.m_actualConn.prepareStatement(sql, columnNames);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.assertOpen();
        this.m_actualConn.releaseSavepoint(savepoint);
    }

    public void rollback() throws SQLException {
        this.assertOpen();
        this.m_actualConn.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.assertOpen();
        this.m_actualConn.rollback(savepoint);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.assertOpen();
        this.m_actualConn.setAutoCommit(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.assertOpen();
        this.m_actualConn.setCatalog(catalog);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.assertOpen();
        this.m_actualConn.setHoldability(holdability);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.assertOpen();
        this.m_actualConn.setReadOnly(readOnly);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.assertOpen();
        return this.m_actualConn.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.assertOpen();
        return this.m_actualConn.setSavepoint(name);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.assertOpen();
        this.m_actualConn.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.assertOpen();
        this.m_actualConn.setTypeMap(map);
    }
}

