/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.Writer;
import org.apache.soap.Constants;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.MultiRefContext;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.PrefixedName;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;

public class SoapEncUtils {
    public static void generateNullStructure(String inScopeEncStyle, Class javaType, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, ctx, null, null, true);
    }

    public static void generateNullArray(String inScopeEncStyle, Class javaType, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx, QName arrayElementType, String arrayLengthStr) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, ctx, arrayElementType, arrayLengthStr, true);
    }

    public static void generateArrayHeader(String inScopeEncStyle, Class javaType, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx, QName arrayElementType, String arrayLengthStr) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, ctx, arrayElementType, arrayLengthStr, false);
    }

    public static void generateStructureHeader(String inScopeEncStyle, Class javaType, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, ctx, null, null, false);
    }

    private static void generateStructureHeader(String inScopeEncStyle, Class javaType, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx, QName arrayElementType, String arrayLengthStr, boolean isNull) throws IllegalArgumentException, IOException {
        String elementTypeNS;
        String namespaceURI;
        PrefixedName pname;
        QName qname;
        QName elementType = xjmr.queryElementType(javaType, "http://schemas.xmlsoap.org/soap/encoding/");
        String namespaceDecl = "";
        if (context instanceof PrefixedName && (qname = (pname = (PrefixedName)context).getQName()) != null && (namespaceURI = qname.getNamespaceURI()) != null && !namespaceURI.equals("") && pname.getPrefix() == null) {
            String prefix = nsStack.getPrefixFromURI(namespaceURI);
            if (prefix == null) {
                prefix = nsStack.addNSDeclaration(namespaceURI);
                namespaceDecl = " xmlns:" + prefix + "=\"" + namespaceURI + '\"';
            }
            pname.setPrefix(prefix);
        }
        sink.write(60);
        sink.write(context.toString());
        sink.write(namespaceDecl);
        if (context instanceof MultiRefContext) {
            sink.write(" id=\"" + Constants.ATTRVAL_MULTIREF_ID_PREFIX);
            sink.write(((MultiRefContext)context).getId() + "");
            sink.write(34);
        }
        String xsiNamespaceURI = (elementTypeNS = elementType.getNamespaceURI()).startsWith("http://www.w3.org/") && elementTypeNS.endsWith("/XMLSchema") ? elementTypeNS + "-instance" : (xjmr instanceof SOAPMappingRegistry ? ((SOAPMappingRegistry)xjmr).getSchemaURI() + "-instance" : "http://www.w3.org/2001/XMLSchema-instance");
        String xsiNSPrefix = nsStack.getPrefixFromURI(xsiNamespaceURI, sink);
        String elementTypeNSPrefix = nsStack.getPrefixFromURI(elementTypeNS, sink);
        if (ctx == null || !ctx.getDocLitSerialization()) {
            sink.write(32);
            sink.write(xsiNSPrefix);
            sink.write(":type=\"");
            sink.write(elementTypeNSPrefix);
            sink.write(58);
            sink.write(elementType.getLocalPart());
            sink.write(34);
        }
        if (inScopeEncStyle == null || !inScopeEncStyle.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            String soapEnvNSPrefix = nsStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/envelope/", sink);
            sink.write(32);
            sink.write(soapEnvNSPrefix);
            sink.write(":encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"");
        }
        if (arrayElementType != null) {
            String arrayElementTypeNSPrefix = nsStack.getPrefixFromURI(arrayElementType.getNamespaceURI(), sink);
            String arrayTypeValue = arrayElementTypeNSPrefix + ':' + arrayElementType.getLocalPart() + '[' + arrayLengthStr + ']';
            String soapEncNSPrefix = nsStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/encoding/", sink);
            sink.write(32);
            sink.write(soapEncNSPrefix);
            sink.write(":arrayType=\"");
            sink.write(arrayTypeValue);
            sink.write(34);
        }
        if (isNull) {
            sink.write(32);
            sink.write(xsiNSPrefix);
            sink.write(58);
            sink.write(SoapEncUtils.nilName(xsiNamespaceURI));
            sink.write("=\"" + Constants.ATTRVAL_TRUE + "\"/");
        }
        sink.write(62);
    }

    public static void generateNullStructure(String inScopeEncStyle, Class javaType, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, null, null, null, true);
    }

    public static void generateNullArray(String inScopeEncStyle, Class javaType, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, QName arrayElementType, String arrayLengthStr) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, null, arrayElementType, arrayLengthStr, true);
    }

    public static void generateArrayHeader(String inScopeEncStyle, Class javaType, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, QName arrayElementType, String arrayLengthStr) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, null, arrayElementType, arrayLengthStr, false);
    }

    public static void generateStructureHeader(String inScopeEncStyle, Class javaType, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, null, null, null, false);
    }

    private static String nilName(String currentSchemaXSI) {
        return currentSchemaXSI.equals("http://www.w3.org/2001/XMLSchema-instance") ? "nil" : "null";
    }

    public static boolean isNull(Element element) {
        String nullValue = DOMUtils.getAttributeNS(element, "http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (nullValue == null) {
            nullValue = DOMUtils.getAttributeNS(element, "http://www.w3.org/2000/10/XMLSchema-instance", "null");
        }
        if (nullValue == null) {
            nullValue = DOMUtils.getAttributeNS(element, "http://www.w3.org/1999/XMLSchema-instance", "null");
        }
        if (nullValue == null) {
            nullValue = DOMUtils.getAttributeNS(element, "http://www.w3.org/2001/XMLSchema-instance", "null");
        }
        return nullValue != null && SoapEncUtils.decodeBooleanValue(nullValue);
    }

    public static boolean decodeBooleanValue(String value) {
        switch (value.charAt(0)) {
            case '0': 
            case 'F': 
            case 'f': {
                return false;
            }
            case '1': 
            case 'T': 
            case 't': {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid boolean value: " + value);
    }

    public static QName getAttributeValue(Element el, String attrNameNamespaceURI, String attrNameLocalPart, String elDesc, boolean isRequired) throws IllegalArgumentException {
        String attrValue = DOMUtils.getAttributeNS(el, attrNameNamespaceURI, attrNameLocalPart);
        if (attrValue != null) {
            int index = attrValue.indexOf(58);
            if (index != -1) {
                String attrValuePrefix = attrValue.substring(0, index);
                String attrValueLocalPart = attrValue.substring(index + 1);
                String attrValueNamespaceURI = DOMUtils.getNamespaceURIFromPrefix(el, attrValuePrefix);
                if (attrValueNamespaceURI != null) {
                    return new QName(attrValueNamespaceURI, attrValueLocalPart);
                }
                throw new IllegalArgumentException("Unable to resolve namespace URI for '" + attrValuePrefix + "'.");
            }
            throw new IllegalArgumentException("The value of the '" + attrNameNamespaceURI + ':' + attrNameLocalPart + "' attribute must be " + "namespace-qualified.");
        }
        if (isRequired) {
            throw new IllegalArgumentException("The '" + attrNameNamespaceURI + ':' + attrNameLocalPart + "' attribute must be " + "specified for every " + elDesc + '.');
        }
        return null;
    }

    public static QName getTypeQName(Element el) throws IllegalArgumentException {
        String localName;
        QName typeQName = SoapEncUtils.getAttributeValue(el, "http://www.w3.org/2001/XMLSchema-instance", "type", null, false);
        if (typeQName != null) {
            return typeQName;
        }
        typeQName = SoapEncUtils.getAttributeValue(el, "http://www.w3.org/2000/10/XMLSchema-instance", "type", null, false);
        if (typeQName != null) {
            return typeQName;
        }
        typeQName = SoapEncUtils.getAttributeValue(el, "http://www.w3.org/1999/XMLSchema-instance", "type", null, false);
        if (typeQName != null) {
            return typeQName;
        }
        String nsURI = el.getNamespaceURI();
        if (nsURI != null && nsURI.equals("http://schemas.xmlsoap.org/soap/encoding/") && (localName = el.getLocalName()).equals("Array")) {
            typeQName = new QName(nsURI, localName);
        }
        return typeQName;
    }
}

