/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.properties;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.lang.reflect.Field;
import org.jCharts.properties.Properties;
import org.jCharts.properties.PropertyException;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.HTMLTestable;

public final class AxisProperties
extends Properties
implements HTMLTestable {
    public static final transient int X_AXIS = 0;
    public static final transient int Y_AXIS = 1;
    public static final transient Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    public static final transient int TICKS_NONE = 0;
    public static final transient int TICKS_ALL = 1;
    public static final transient int TICKS_ONLY_WITH_LABELS = 2;
    public static final transient int GRID_LINES_NONE = 0;
    public static final transient int GRID_LINES_ALL = 1;
    public static final transient int GRID_LINES_ONLY_WITH_LABELS = 2;
    public static final transient Font DEFAULT_FONT_AXIS_TITLE = new Font("Serif", 1, 12);
    public static final transient Font DEFAULT_FONT_SCALE = new Font("TimesRoman", 0, 10);
    private int[] showTicks = new int[]{1, 1};
    private Stroke[] tickStrokes = new Stroke[]{DEFAULT_STROKE, DEFAULT_STROKE};
    private Paint[] tickColors = new Paint[]{Color.black, Color.black};
    private int[] showGridLines = new int[]{0, 1};
    private Stroke[] gridLineStrokes = new Stroke[]{DEFAULT_STROKE, DEFAULT_STROKE};
    private Paint[] gridLineColors = new Paint[]{Color.lightGray, Color.lightGray};
    private Font axisTitleFont = DEFAULT_FONT_AXIS_TITLE;
    private Paint axisTitleFontColor = Color.black;
    private float[] paddingBetweenAxisTitleAndLabels = new float[]{25.0f, 20.0f};
    private float[] axisTickMarkPixelLength = new float[]{3.0f, 3.0f};
    private float[] paddingBetweenLabelsAndTicks = new float[]{3.0f, 3.0f};
    private float[] paddingBetweenAxisAndLabels = new float[]{3.0f, 3.0f};
    private float paddingBetweenXAxisLabels = 5.0f;
    private int y_AxisNumItems = 5;
    private boolean y_axisUseDollarSigns = false;
    private boolean y_axisUseCommas = true;
    private boolean y_axisUsePercentSigns = false;
    private Font scaleFont = DEFAULT_FONT_SCALE;
    private Paint scaleFontColor = Color.black;
    private boolean y_AxisRoundValues = true;
    private int y_AxisRoundValuesToNearest = 2;
    private boolean showTopBorder = true;
    private boolean showRightBorder = true;
    private Stroke[] axisStroke = new Stroke[]{DEFAULT_STROKE, DEFAULT_STROKE};
    private Paint[] axisColor = new Paint[]{Color.black, Color.black};
    private boolean showZeroLine = true;
    private Paint zeroLinePaint = Color.black;
    private Stroke zeroLineStroke = DEFAULT_STROKE;
    private boolean userDefinedScale = false;
    private double yAxisMinimumValue;
    private double yAxisIncrement;
    private boolean x_AxisVerticalScale = false;

    public AxisProperties() {
    }

    public AxisProperties(double d, double d2) throws PropertyException {
        if (d2 <= 0.0) {
            throw new PropertyException("The yAxisIncrement can not be a negative value or zero.");
        }
        this.userDefinedScale = true;
        this.yAxisMinimumValue = d;
        this.yAxisIncrement = d2;
    }

    public double getUserDefinedYAxisIncrement() {
        return this.yAxisIncrement;
    }

    public double getUserDefinedYAxisMinimum() {
        return this.yAxisMinimumValue;
    }

    public boolean hasUserDefinedScale() {
        return this.userDefinedScale;
    }

    public int getShowTicks(int n) {
        return this.showTicks[n];
    }

    public void setShowTicks(int n, int n2) {
        this.showTicks[n] = n2;
    }

    public Paint getTickColor(int n) {
        return this.tickColors[n];
    }

    public void setTickColor(int n, Paint paint) {
        this.tickColors[n] = paint;
    }

    public Stroke getTickStroke(int n) {
        return this.tickStrokes[n];
    }

    public void setTickStroke(int n, Stroke stroke) {
        this.tickStrokes[n] = stroke;
    }

    public int getShowGridLine(int n) {
        return this.showGridLines[n];
    }

    public void setShowGridLine(int n, int n2) {
        this.showGridLines[n] = n2;
    }

    public Stroke getGridLineStroke(int n) {
        return this.gridLineStrokes[n];
    }

    public void setGridLineStroke(int n, Stroke stroke) {
        this.gridLineStrokes[n] = stroke;
    }

    public Paint getGridLineColor(int n) {
        return this.gridLineColors[n];
    }

    public void setGridLineColor(int n, Paint paint) {
        this.gridLineColors[n] = paint;
    }

    public int getYAxisNumItems() {
        return this.y_AxisNumItems;
    }

    public void setYAxisNumItems(int n) {
        this.y_AxisNumItems = n;
    }

    public boolean getYAxisUseDollarSigns() {
        return this.y_axisUseDollarSigns;
    }

    public void setYAxisUseDollarSigns(boolean bl) {
        this.y_axisUseDollarSigns = bl;
    }

    public boolean getYAxisUseCommas() {
        return this.y_axisUseCommas;
    }

    public void setYAxisUseCommas(boolean bl) {
        this.y_axisUseCommas = bl;
    }

    public int getYAxisRoundValuesToNearest() {
        return this.y_AxisRoundValuesToNearest;
    }

    public void setYAxisRoundValuesToNearest(int n) {
        this.y_AxisRoundValuesToNearest = n;
    }

    public Font getScaleFont() {
        return this.scaleFont;
    }

    public void setScaleFont(Font font) {
        this.scaleFont = font;
    }

    public Paint getScaleFontColor() {
        return this.scaleFontColor;
    }

    public void setScaleFontColor(Paint paint) {
        this.scaleFontColor = paint;
    }

    public Font getAxisTitleFont() {
        return this.axisTitleFont;
    }

    public void setAxisTitleFont(Font font) {
        this.axisTitleFont = font;
    }

    public Paint getAxisTitleColor() {
        return this.axisTitleFontColor;
    }

    public void setAxisTitleColor(Paint paint) {
        this.axisTitleFontColor = paint;
    }

    public boolean getShowTopBorder() {
        return this.showTopBorder;
    }

    public void setShowTopBorder(boolean bl) {
        this.showTopBorder = bl;
    }

    public boolean getShowRightBorder() {
        return this.showRightBorder;
    }

    public void setShowRightBorder(boolean bl) {
        this.showRightBorder = bl;
    }

    public Paint getAxisColor(int n) {
        return this.axisColor[n];
    }

    public void setAxisColor(int n, Paint paint) {
        this.axisColor[n] = paint;
    }

    public Stroke getAxisStroke(int n) {
        return this.axisStroke[n];
    }

    public void setAxisStroke(int n, Stroke stroke) {
        this.axisStroke[n] = stroke;
    }

    public float getPaddingBetweenAxisTitleAndLabels(int n) {
        return this.paddingBetweenAxisTitleAndLabels[n];
    }

    public void setPaddingBetweenAxisTitleAndLabels(int n, float f) {
        this.paddingBetweenAxisTitleAndLabels[n] = f;
    }

    public float getAxisTickMarkPixelLength(int n) {
        return this.axisTickMarkPixelLength[n];
    }

    public void setAxisTickMarkPixelLength(int n, float f) {
        this.axisTickMarkPixelLength[n] = f;
    }

    public float getPaddingBetweenLabelsAndTicks(int n) {
        return this.paddingBetweenLabelsAndTicks[n];
    }

    public void setPaddingBetweenLabelsAndTicks(int n, float f) {
        this.paddingBetweenLabelsAndTicks[n] = f;
    }

    public float getPaddingBetweenAxisAndLabels(int n) {
        return this.paddingBetweenAxisAndLabels[n];
    }

    public void setPaddingBetweenAxisAndLabels(int n, float f) {
        this.paddingBetweenAxisAndLabels[n] = f;
    }

    public float getPaddingBetweenXAxisLabels() {
        return this.paddingBetweenXAxisLabels;
    }

    public void setPaddingBetweenXAxisLabels(float f) {
        this.paddingBetweenXAxisLabels = f;
    }

    public boolean getXAxisVerticalScaleFlag() {
        return this.x_AxisVerticalScale;
    }

    public void setXAxisVerticalScaleFlag(boolean bl) {
        this.x_AxisVerticalScale = bl;
    }

    public boolean getShowZeroLine() {
        return this.showZeroLine;
    }

    public void setShowZeroLine(boolean bl) {
        this.showZeroLine = bl;
    }

    public Paint getZeroLinePaint() {
        return this.zeroLinePaint;
    }

    public void setZeroLinePaint(Paint paint) {
        this.zeroLinePaint = paint;
    }

    public Stroke getZeroLineStroke() {
        return this.zeroLineStroke;
    }

    public void setZeroLineStroke(Stroke stroke) {
        this.zeroLineStroke = stroke;
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableStart(this.getClass().getName());
        super.toHTML(hTMLGenerator);
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            try {
                hTMLGenerator.addField(fieldArray[n].getName(), fieldArray[n].get(this));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            ++n;
        }
        hTMLGenerator.propertiesTableEnd();
    }
}

