/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.sqlj;

import COM.ibm.db2.sqlj.DB2SQLJCustomization;
import COM.ibm.db2.sqlj.DB2SQLJErrors;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import sqlj.mesg.ProfilePrinterErrors;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.Customization;
import sqlj.runtime.profile.DefaultLoader;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.util.ProfilePrinter;

public class DB2SQLJProfilePrinter
extends ProfilePrinter {
    private Profile profile;
    private Connection connection;
    private PrintWriter m_out = new PrintWriter(System.out);
    private static final String m_banner = ProfilePrinterErrors.banner();

    public DB2SQLJProfilePrinter(Profile profile, Connection connection) {
        this.profile = profile;
        this.connection = connection;
    }

    private void banner() {
        this.m_out.println(m_banner);
    }

    public int printCustomizeProfile() {
        int n = 0;
        this.banner();
        this.m_out.println(ProfilePrinterErrors.printing_profile((String)this.profile.getProfileName()));
        this.m_out.println(ProfilePrinterErrors.creation_time((long)this.profile.getTimestamp(), (Date)new Date(this.profile.getTimestamp())));
        this.m_out.println(ProfilePrinterErrors.context((String)this.profile.getContextName()));
        this.m_out.println(ProfilePrinterErrors.loader((String)String.valueOf(this.profile.getLoader())));
        int n2 = 0;
        Enumeration enumeration = this.profile.getCustomizations();
        while (enumeration.hasMoreElements()) {
            ++n2;
            enumeration.nextElement();
        }
        this.m_out.println(ProfilePrinterErrors.customization_count((int)n2));
        this.m_out.flush();
        Enumeration enumeration2 = this.profile.getCustomizations();
        while (enumeration2.hasMoreElements()) {
            Customization customization = (Customization)enumeration2.nextElement();
            if (!(customization instanceof DB2SQLJCustomization)) continue;
            try {
                ConnectedProfile connectedProfile = customization.getProfile(this.connection, this.profile);
                ProfileData profileData = connectedProfile.getProfileData();
                ProfilePrinter profilePrinter = new ProfilePrinter();
                profilePrinter.print(profileData);
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException);
                sQLException.printStackTrace();
            }
            ++n;
        }
        if (n == 0) {
            this.banner();
        }
        this.m_out.flush();
        return n;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        String string = "";
        String string2 = "";
        String string3 = null;
        String string4 = null;
        if (stringArray.length < 1) {
            DB2SQLJProfilePrinter.usage();
        }
        n = 0;
        while (n < stringArray.length) {
            stringArray[n].toLowerCase();
            if (!stringArray[n].startsWith("-")) break;
            if (stringArray[n].startsWith("-user=")) {
                string = stringArray[n].substring(6);
                if (string.length() == 0) {
                    string4 = DB2SQLJErrors.MISS_OPTION_text("userName");
                    System.out.println(string4);
                    DB2SQLJProfilePrinter.usage();
                }
            } else if (stringArray[n].startsWith("-user")) {
                string4 = DB2SQLJErrors.INVALID_SYNTAX_text(stringArray[n]);
                System.out.println(string4);
                DB2SQLJProfilePrinter.usage();
            } else if (stringArray[n].startsWith("-password=")) {
                string2 = stringArray[n].substring(10);
                if (string2.length() == 0) {
                    string4 = DB2SQLJErrors.MISS_OPTION_text("password");
                    System.out.println(string4);
                    DB2SQLJProfilePrinter.usage();
                }
            } else if (stringArray[n].startsWith("-password")) {
                string4 = DB2SQLJErrors.INVALID_SYNTAX_text(stringArray[n]);
                System.out.println(string4);
                DB2SQLJProfilePrinter.usage();
            } else if (stringArray[n].startsWith("-url=")) {
                string3 = stringArray[n].substring(5);
                if (string3.length() == 0) {
                    string4 = DB2SQLJErrors.MISS_OPTION_text("url");
                    System.out.println(string4);
                    DB2SQLJProfilePrinter.usage();
                }
            } else if (stringArray[n].startsWith("-url")) {
                string4 = DB2SQLJErrors.INVALID_SYNTAX_text(stringArray[n]);
                System.out.println(string4);
                DB2SQLJProfilePrinter.usage();
            } else {
                string4 = DB2SQLJErrors.UNKNOWN_OPTION_text(stringArray[n]);
                System.out.println(string4);
                DB2SQLJProfilePrinter.usage();
            }
            ++n;
        }
        if (n + 1 < stringArray.length) {
            string4 = DB2SQLJErrors.INVALID_OPTION_text(stringArray[n]);
            System.out.println(string4);
            DB2SQLJProfilePrinter.usage();
        } else {
            if (string3 == null || string3.length() == 0) {
                if (stringArray[n].startsWith("url")) {
                    string4 = DB2SQLJErrors.INVALID_SYNTAX_text(stringArray[n]);
                    System.out.println(string4);
                    DB2SQLJProfilePrinter.usage();
                } else {
                    string4 = DB2SQLJErrors.MISS_OPTION_text("url");
                    System.out.println(string4);
                    DB2SQLJProfilePrinter.usage();
                }
            }
            if (string == "" ^ string2 == "") {
                if (string == "") {
                    string4 = DB2SQLJErrors.MISS_OPTION_text("userName");
                    System.out.println(string4);
                } else {
                    string4 = DB2SQLJErrors.MISS_OPTION_text("password");
                    System.out.println(string4);
                }
                DB2SQLJProfilePrinter.usage();
            }
            if (n >= stringArray.length) {
                string4 = DB2SQLJErrors.MISS_PROFILE_text();
                System.out.println(string4);
                DB2SQLJProfilePrinter.usage();
            }
        }
        try {
            Class.forName("COM.ibm.db2.jdbc.app.DB2Driver").newInstance();
            Connection connection = null;
            try {
                connection = string == "" ? DriverManager.getConnection(string3) : DriverManager.getConnection(string3, string, string2);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                System.err.println(stringIndexOutOfBoundsException);
            }
            int n2 = n;
            while (n2 < stringArray.length) {
                String string5 = null;
                String string6 = null;
                if (stringArray[n2].endsWith(".ser")) {
                    string6 = stringArray[n2];
                    string5 = stringArray[n2].substring(0, stringArray[n2].length() - 4);
                } else {
                    string5 = stringArray[n2];
                    string6 = String.valueOf(stringArray[n2]) + ".ser";
                }
                try {
                    Profile profile = Profile.instantiate((Loader)new DefaultLoader(null), (String)string5);
                    DB2SQLJProfilePrinter dB2SQLJProfilePrinter = new DB2SQLJProfilePrinter(profile, connection);
                    dB2SQLJProfilePrinter.printCustomizeProfile();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    string4 = DB2SQLJErrors.UNABLE_LOAD_PROFILE_text(string5);
                    System.out.println(string4);
                    System.out.println(classNotFoundException);
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
            return;
        }
    }

    private static String getOptValue(int n, String string, String[] stringArray) {
        String string2 = null;
        try {
            if (++n >= stringArray.length | stringArray[n].startsWith("-")) {
                string2 = DB2SQLJErrors.MISS_OPTION_text(string);
                System.out.println(string2);
                DB2SQLJProfilePrinter.usage();
                return null;
            }
            return stringArray[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string2 = DB2SQLJErrors.MISS_OPTION_text(string);
            System.out.println(string2);
            DB2SQLJProfilePrinter.usage();
            return null;
        }
    }

    private static void usage() {
        System.out.println("");
        System.out.println("(c) Copyright IBM Corporation 1998,1999");
        System.out.println("Usage: db2profp [options] -url=JDBC-url profileName[.ser] ...");
        System.out.println("       options=[-user=userName -password=password]");
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        String string = new String();
        while (enumeration.hasMoreElements() && !string.equalsIgnoreCase("java.vendor")) {
            string = (String)enumeration.nextElement();
        }
        String string2 = properties.getProperty(string).toLowerCase();
        if (string2 == null) {
            System.out.println("       db2profp = java COM.ibm.db2.sqlj.DB2SQLJProfilePrinter");
        } else if (string2.indexOf("microsoft") != -1) {
            System.out.println("       db2profp = jview COM.ibm.db2.sqlj.DB2SQLJProfilePrinter");
        } else {
            System.out.println("       db2profp = java COM.ibm.db2.sqlj.DB2SQLJProfilePrinter");
        }
        System.out.println("");
        System.exit(1);
    }
}

