/*
 * Decompiled with CFR 0.152.
 */
package org.aton.logger;

import com.trs.util.CMyDateTime;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import org.aton.cache.ICachedObj;
import org.aton.exception.ExceptionFire;
import org.aton.logger.ILogger;

public abstract class LoggerBase
implements ILogger,
ICachedObj {
    public static final String CLASS_NAME;
    private String m_sName = CLASS_NAME;
    private boolean m_bTimeStamp = true;
    private String m_sDateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    protected CMyDateTime m_dtNow = new CMyDateTime();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.aton.logger.LoggerBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
    }

    public LoggerBase() {
    }

    public LoggerBase(String p_sName) {
        this.m_sName = p_sName;
    }

    public static final String getLevelName(int p_nLevel, String p_sDefault) {
        switch (p_nLevel) {
            case -2147483648: {
                return "FATAL";
            }
            case 1: {
                return "ERROR";
            }
            case 2: {
                return "WARNING";
            }
            case 3: {
                return "INFO";
            }
            case 4: {
                return "DEBUG";
            }
        }
        return p_sDefault;
    }

    public static final String getLevelName(int p_nLevel) {
        return LoggerBase.getLevelName(p_nLevel, "UNKNOWN");
    }

    public Object getCachedKey() {
        return this.m_sName;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String p_sName) {
        this.m_sName = p_sName;
    }

    public boolean isTimeStamp() {
        return this.m_bTimeStamp;
    }

    public void setTimeStamp(boolean p_bTimeStamp) {
        this.m_bTimeStamp = p_bTimeStamp;
    }

    public String getDateTimeFormat() {
        return this.m_sDateTimeFormat;
    }

    public void setDateTimeFormat(String p_sDateTimeFormat) {
        if (p_sDateTimeFormat != null) {
            this.m_sDateTimeFormat = p_sDateTimeFormat;
        }
    }

    public String getCurrentTimeAsString(String p_sFormat) {
        this.m_dtNow.setDateTimeWithCurrentTime();
        return this.m_dtNow.toString(p_sFormat);
    }

    public String getCurrentTimeAsString() {
        return this.getCurrentTimeAsString(this.m_sDateTimeFormat);
    }

    public void log(String p_sMessage, Throwable p_throwable, int p_nLevel) {
        if (p_throwable == null) {
            return;
        }
        CharArrayWriter buff = new CharArrayWriter();
        PrintWriter writer = new PrintWriter(buff);
        Throwable rootCause = null;
        try {
            buff = new CharArrayWriter();
            writer = new PrintWriter(buff);
            if (p_sMessage == null) {
                p_sMessage = p_throwable.getMessage();
            }
            if (p_sMessage != null) {
                writer.println(p_sMessage);
            }
            if (p_throwable instanceof ExceptionFire) {
                rootCause = ((ExceptionFire)p_throwable).getRootCause();
            } else if (p_throwable instanceof ServletException) {
                rootCause = ((ServletException)p_throwable).getRootCause();
            }
            if (rootCause == null) {
                p_throwable.printStackTrace(writer);
            } else {
                writer.println("----- Root Cause -----");
                rootCause.printStackTrace(writer);
            }
            this.log(buff.toString(), p_nLevel);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    public void log(Throwable p_throwable, int p_nLevel) {
        this.log(null, p_throwable, p_nLevel);
    }

    protected void log(String p_sMessage, int p_nLevel, PrintWriter p_writer) {
        if (p_writer == null) {
            return;
        }
        if (this.isTimeStamp()) {
            p_writer.print(String.valueOf(this.getCurrentTimeAsString()) + " ");
        }
        p_writer.print(String.valueOf(this.getName()) + " -> " + LoggerBase.getLevelName(p_nLevel) + ": ");
        p_writer.println(p_sMessage);
    }

    public void close() {
    }

    public abstract void log(String var1, int var2);
}

