/*
 * Decompiled with CFR 0.152.
 */
package org.aton.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.aton.logger.LoggerBase;

public class FileLogger
extends LoggerBase {
    public static final String CLASS_NAME;
    public static final String FILENAME_DATEFORMAT = "yyyyMMdd";
    private String m_sPath = "../logs";
    private String m_sPrefix = "trslog_";
    private String m_sSuffix = ".log";
    private PrintWriter m_writer = null;
    private String m_sDate = "";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.aton.logger.FileLogger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
    }

    public FileLogger() {
        this.setName(CLASS_NAME);
    }

    public FileLogger(String p_sName) {
        super(p_sName);
    }

    public String getPath() {
        return this.m_sPath;
    }

    public void setPath(String p_sPath) {
        if (p_sPath != null) {
            this.m_sPath = p_sPath.trim();
        }
    }

    public String getPrefix() {
        return this.m_sPrefix;
    }

    public void setPrefix(String p_sPrefix) {
        this.m_sPrefix = p_sPrefix;
    }

    public String getSuffix() {
        return this.m_sSuffix;
    }

    public void setSuffix(String p_sSuffix) {
        this.m_sSuffix = p_sSuffix;
    }

    private void closeLogFile() {
        if (this.m_writer == null) {
            return;
        }
        try {
            this.m_writer.flush();
            this.m_writer.close();
            this.m_writer = null;
            this.m_sDate = "";
        }
        catch (Exception ex) {
            System.out.println("[" + CLASS_NAME + ".close] Failed to close log file:");
            ex.printStackTrace(System.out);
        }
    }

    private void openLogFile() {
        String sFilePathName = null;
        File dir = null;
        try {
            dir = new File(this.getPath());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            sFilePathName = String.valueOf(dir.getAbsolutePath()) + File.separator + this.getPrefix() + this.m_sDate + this.getSuffix();
            this.m_writer = new PrintWriter((Writer)new FileWriter(sFilePathName, true), true);
        }
        catch (Exception ex) {
            this.m_writer = null;
            System.out.println("[" + CLASS_NAME + ".openLogFile] Failed to open log file:");
            ex.printStackTrace(System.out);
        }
    }

    public String getLogFilePathName() {
        String sFilePathName = null;
        File dir = new File(this.getPath());
        String sDate = this.getCurrentTimeAsString(FILENAME_DATEFORMAT);
        sFilePathName = String.valueOf(dir.getAbsolutePath()) + File.separator + this.getPrefix() + sDate + this.getSuffix();
        return sFilePathName;
    }

    public void log(String p_sMessage, int p_nLevel) {
        String sDate = null;
        try {
            sDate = this.getCurrentTimeAsString(FILENAME_DATEFORMAT);
            if (!this.m_sDate.equals(sDate)) {
                FileLogger fileLogger = this;
                synchronized (fileLogger) {
                    if (!this.m_sDate.equals(sDate)) {
                        this.closeLogFile();
                        this.m_sDate = sDate;
                        this.openLogFile();
                    }
                }
            }
            if (this.m_writer != null) {
                this.log(p_sMessage, p_nLevel, this.m_writer);
            }
        }
        catch (Exception ex) {
            System.out.println("[" + CLASS_NAME + ".openLogFile] Failed to write log file:");
            ex.printStackTrace(System.out);
        }
    }

    public void stop() {
        this.closeLogFile();
    }

    public void close() {
        this.closeLogFile();
    }

    public static void main(String[] args) {
        FileLogger logger = new FileLogger();
        System.out.println("Log file:" + logger.getLogFilePathName());
        logger.log("logger started", 3);
        logger.stop();
    }
}

