/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.testing;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.model.LifecycleRule;
import com.aliyun.oss.model.SetBucketLifecycleRequest;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;

public class LifecycleConfigTest {
    static final String endpoint = "<valid endpoint>";
    static final String accessId = "<your access id>";
    static final String accessKey = "<your access key>";
    static final String bucketName = "<your bucket name>";

    @Ignore
    public void testLifecycleConfig() {
        OSSClient client = new OSSClient(endpoint, accessId, accessKey);
        try {
            SetBucketLifecycleRequest req = new SetBucketLifecycleRequest(bucketName);
            req.AddLifecycleRule(new LifecycleRule("delete obsoleted files", "obsoleted/", LifecycleRule.RuleStatus.Enabled, 3));
            req.AddLifecycleRule(new LifecycleRule("delete temporary files", "temporary/", LifecycleRule.RuleStatus.Enabled, DateUtil.parseIso8601Date("2022-10-12T00:00:00.000Z")));
            client.setBucketLifecycle(req);
            List<LifecycleRule> rules = client.getBucketLifecycle(bucketName);
            Assert.assertEquals((long)rules.size(), (long)2L);
            LifecycleRule r0 = rules.get(0);
            Assert.assertEquals((Object)r0.getId(), (Object)"delete obsoleted files");
            Assert.assertEquals((Object)r0.getPrefix(), (Object)"obsoleted/");
            Assert.assertEquals((Object)((Object)r0.getStatus()), (Object)((Object)LifecycleRule.RuleStatus.Enabled));
            Assert.assertEquals((long)r0.getExpriationDays(), (long)3L);
            LifecycleRule r1 = rules.get(1);
            Assert.assertEquals((Object)r1.getId(), (Object)"delete temporary files");
            Assert.assertEquals((Object)r1.getPrefix(), (Object)"temporary/");
            Assert.assertEquals((Object)((Object)r1.getStatus()), (Object)((Object)LifecycleRule.RuleStatus.Enabled));
            Assert.assertEquals((Object)DateUtil.formatIso8601Date(r1.getExpirationTime()), (Object)"2022-10-12T00:00:00.000Z");
            client.deleteBucketLifecycle(bucketName);
            try {
                client.getBucketLifecycle(bucketName);
            }
            catch (OSSException ex) {
                Assert.assertEquals((Object)"NoSuchLifecycle", (Object)ex.getErrorCode());
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

