/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.testing;

import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;

public class ChunkedEncodingTest {
    static final String endpoint = "<valid endpoint>";
    static final String accessId = "<your access id>";
    static final String accessKey = "<your access key>";
    static OSSClient client = new OSSClient("<valid endpoint>", "<your access id>", "<your access key>");
    static final String bucketName = "<your bucket name>";
    static final String key = "<object key>";
    static final String filePath = "<file to upload>";

    @Ignore
    public void testPutObjectChunked() {
        try {
            File f = new File(filePath);
            FileInputStream fin = new FileInputStream(new File(filePath));
            PutObjectResult result = client.putObject(bucketName, key, fin, new ObjectMetadata());
            fin = new FileInputStream(f);
            byte[] binaryData = IOUtils.readStreamAsByteArray(fin);
            String actualETag = BinaryUtil.encodeMD5(binaryData);
            String expectedETag = result.getETag();
            Assert.assertEquals((Object)expectedETag, (Object)actualETag);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Ignore
    public void testPutObjectChunked2() {
        try {
            Date expiration = DateUtil.parseRfc822Date("Wed, 12 Mar 2015 03:15:00 GMT");
            HttpMethod method = HttpMethod.PUT;
            URL signedUrl = client.generatePresignedUrl(bucketName, key, expiration, method);
            File f = new File(filePath);
            FileInputStream fin = new FileInputStream(f);
            HashMap<String, String> customHeaders = new HashMap<String, String>();
            customHeaders.put("x-oss-meta-author", "aliy");
            customHeaders.put("x-oss-tag", "byurl");
            PutObjectResult result = client.putObject(signedUrl, fin, f.length(), customHeaders, true);
            fin = new FileInputStream(f);
            byte[] binaryData = IOUtils.readStreamAsByteArray(fin);
            String expectedETag = BinaryUtil.encodeMD5(binaryData);
            String actualETag = result.getETag();
            Assert.assertEquals((Object)expectedETag, (Object)actualETag);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Ignore
    public void testUploadPartChunked() {
        try {
            InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(bucketName, key);
            InitiateMultipartUploadResult initiateMultipartUploadResult = client.initiateMultipartUpload(initiateMultipartUploadRequest);
            String uploadId = initiateMultipartUploadResult.getUploadId();
            File file = new File(filePath);
            int partSize = 0x500000;
            int fileSize = (int)file.length();
            int partCount = file.length() % 0x500000L != 0L ? fileSize / 0x500000 + 1 : fileSize / 0x500000;
            ArrayList<PartETag> partETags = new ArrayList<PartETag>();
            int i = 0;
            while (i < partCount) {
                BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file));
                ((InputStream)fin).skip(i * 0x500000);
                int size = i + 1 == partCount ? fileSize - i * 0x500000 : 0x500000;
                UploadPartRequest req = new UploadPartRequest();
                req.setBucketName(bucketName);
                req.setKey(key);
                req.setPartNumber(i + 1);
                req.setPartSize(size);
                req.setUploadId(uploadId);
                req.setInputStream(fin);
                req.setUseChunkEncoding(true);
                UploadPartResult result = client.uploadPart(req);
                partETags.add(result.getPartETag());
                ++i;
            }
            String expectedETag = ChunkedEncodingTest.calcMultipartETag(partETags);
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, key, uploadId, partETags);
            CompleteMultipartUploadResult completeMultipartUploadResult = client.completeMultipartUpload(completeMultipartUploadRequest);
            String actualETag = completeMultipartUploadResult.getETag();
            Assert.assertEquals((Object)expectedETag, (Object)actualETag);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private static String calcMultipartETag(List<PartETag> eTags) {
        StringBuffer concatedEtags = new StringBuffer();
        for (PartETag e : eTags) {
            concatedEtags.append(e.getETag());
        }
        String encodedMD5 = BinaryUtil.encodeMD5(concatedEtags.toString().getBytes());
        int partNumber = eTags.size();
        String finalETag = String.format("%s-%d", encodedMD5, partNumber);
        return finalETag;
    }
}

