/*
 * Decompiled with CFR 0.152.
 */
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.UUID;

public class GetStartedSample {
    private static String endpoint = "*** Provide OSS endpoint ***";
    private static String accessKeyId = "*** Provide your AccessKeyId ***";
    private static String accessKeySecret = "*** Provide your AccessKeySecret ***";
    private static OSSClient client = null;

    public static void main(String[] args) throws IOException {
        client = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        String bucketName = "my-first-oss-bucket" + UUID.randomUUID();
        String key = "MyObjectKey";
        System.out.println("===========================================");
        System.out.println("Getting Started with OSS SDK for Java");
        System.out.println("===========================================\n");
        try {
            try {
                System.out.println("Creating bucket " + bucketName + "\n");
                client.createBucket(bucketName);
                boolean exists = client.doesBucketExist(bucketName);
                System.out.println("Does bucket " + bucketName + " exist? " + exists + "\n");
                System.out.println("Listing buckets");
                for (Bucket bucket : client.listBuckets()) {
                    System.out.println(" - " + bucket.getName());
                }
                System.out.println();
                System.out.println("Uploading a new object to OSS from a file\n");
                client.putObject(new PutObjectRequest(bucketName, key, GetStartedSample.createSampleFile()));
                exists = client.doesObjectExist(bucketName, key);
                System.out.println("Does object " + bucketName + " exist? " + exists + "\n");
                System.out.println("Downloading an object");
                OSSObject object = client.getObject(new GetObjectRequest(bucketName, key));
                System.out.println("Content-Type: " + object.getObjectMetadata().getContentType());
                GetStartedSample.displayTextInputStream(object.getObjectContent());
                System.out.println("Listing objects");
                ObjectListing objectListing = client.listObjects(new ListObjectsRequest(bucketName).withPrefix("My"));
                for (OSSObjectSummary objectSummary : objectListing.getObjectSummaries()) {
                    System.out.println(" - " + objectSummary.getKey() + "  " + "(size = " + objectSummary.getSize() + ")");
                }
                System.out.println();
                System.out.println("Deleting an object\n");
                client.deleteObject(bucketName, key);
                System.out.println("Deleting bucket " + bucketName + "\n");
                client.deleteBucket(bucketName);
            }
            catch (OSSException oe) {
                System.out.println("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
                System.out.println("Error Message: " + oe.getErrorCode());
                System.out.println("Error Code:       " + oe.getErrorCode());
                System.out.println("Request ID:      " + oe.getRequestId());
                System.out.println("Host ID:           " + oe.getHostId());
                client.shutdown();
            }
            catch (ClientException ce) {
                System.out.println("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
                System.out.println("Error Message: " + ce.getMessage());
                client.shutdown();
            }
        }
        finally {
            client.shutdown();
        }
    }

    private static File createSampleFile() throws IOException {
        File file = File.createTempFile("oss-java-sdk-", ".txt");
        file.deleteOnExit();
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));
        writer.write("abcdefghijklmnopqrstuvwxyz\n");
        writer.write("0123456789011234567890\n");
        ((Writer)writer).close();
        return file;
    }

    private static void displayTextInputStream(InputStream input) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        while ((line = reader.readLine()) != null) {
            System.out.println("    " + line);
        }
        System.out.println();
        reader.close();
    }
}

