/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.ExtendedField;
import com.trs.cms.content.ExtendedFields;
import com.trs.components.document.DocumentTimeRangeHelper;
import com.trs.components.stat.IChnlDeptMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import java.util.Arrays;
import java.util.List;

public class SearcherTool {
    private static User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public static WCMFilter getFilterFromList(MethodContext _sContext, BaseObjs _sObjects) throws Exception {
        String sqlWhere;
        boolean bIsSearch;
        User loginUser = SearcherTool.getLoginUser();
        WCMFilter filter = new WCMFilter();
        filter.mergeWith(_sContext.getExtraWCMFilter());
        if (ConfigServer.getServer().getSysConfigValue("EXTFIELD_QUERY", "false").toLowerCase().trim().equals("true")) {
            String sLink;
            WCMFilter filterExtend = new WCMFilter("", "TABLENAME = 'WCMDOCUMENT' AND FIELDTYPE != 'DATETIME'", "", "EXTFIELDID");
            ExtendedFields currExtendedFields = ExtendedFields.openWCMObjs(loginUser, filterExtend);
            ExtendedField newExtendedField = null;
            filterExtend = new WCMFilter();
            String sWhere = null;
            String string = sLink = _sContext.getValue("IsOr", false) ? " or " : " and ";
            if (currExtendedFields.size() > 0) {
                for (int i = 0; i < currExtendedFields.size(); ++i) {
                    newExtendedField = (ExtendedField)currExtendedFields.getAt(i);
                    if (newExtendedField == null) continue;
                    String sExtendName = newExtendedField.getName();
                    String sExtendValue = _sContext.getValue(sExtendName);
                    if (!_sContext.containsParameter(sExtendName) || sExtendValue.trim().equals("")) continue;
                    if (newExtendedField.getTypeName().equalsIgnoreCase("string")) {
                        sExtendValue = '%' + sExtendValue + '%';
                    }
                    filterExtend.addSearchValues(sExtendValue);
                    sWhere = sWhere != null ? sWhere + sLink : "";
                    sWhere = sWhere + SearcherTool.extFilter(newExtendedField, _sContext);
                }
                String sLinkOper = " " + sLink + " ";
                StringBuffer sbWhere = new StringBuffer();
                String[] aCondition = new String[]{filter.getWhere(), sWhere};
                for (int i = 0; i < aCondition.length; ++i) {
                    if (CMyString.isEmpty(aCondition[i])) continue;
                    sbWhere.append(aCondition[i]).append(sLinkOper);
                }
                if (sbWhere.length() > 1) {
                    sbWhere.setLength(sbWhere.length() - sLinkOper.length());
                }
                filter.setWhere(sbWhere.toString());
                if (filterExtend.getSearchValues() != null && filter.getSearchValues() != null) {
                    filter.getSearchValues().addAll(filterExtend.getSearchValues());
                } else if (filterExtend.getSearchValues() != null) {
                    filter.setSearchValues(filterExtend.getSearchValues());
                }
            }
        }
        filter.mergeWith(SearcherTool.makeTimeFilterByType(_sContext.getValue("CrTimeInterval", 0), "WCMChnlDoc.CrTime"));
        filter.mergeWith(SearcherTool.makeTimeFilterByType(_sContext.getValue("PubTimeInterval", 0), "WCMChnlDoc.DocPubTime"));
        int nFilterType = _sContext.getValue("FilterType", 0);
        filter.mergeWith(SearcherTool.makeFilterByType(loginUser, _sObjects, nFilterType));
        String sIsSearch = _sContext.getValue("ISSEARCH");
        boolean bl = bIsSearch = sIsSearch != null && sIsSearch.trim().equals("1");
        if (!bIsSearch && _sObjects.size() == 1) {
            filter.mergeWith(DocumentTimeRangeHelper.makeFilterWithTimeLimit((BaseChannel)_sObjects.getAt(0)));
        }
        if (!CMyString.isEmpty(sqlWhere = _sContext.getValue("_sqlWhere_"))) {
            if (filter.getWhere().length() > 0) {
                boolean isOr = _sContext.getValue("IsOr", true);
                filter.setWhere(filter.getWhere() + (isOr ? " or " : " and ") + "(" + sqlWhere + ")");
            } else {
                filter.setWhere("(" + sqlWhere + ")");
            }
        }
        return filter;
    }

    public static String getSqlStrByList(List sqhList, int splitNum, String columnName) {
        if (splitNum > 1000) {
            return null;
        }
        StringBuffer sql = new StringBuffer("");
        if (sqhList != null) {
            sql.append(" ").append(columnName).append(" IN ( ");
            for (int i = 0; i < sqhList.size(); ++i) {
                sql.append(sqhList.get(i) + ",");
                if ((i + 1) % splitNum != 0 || i + 1 >= sqhList.size()) continue;
                sql.deleteCharAt(sql.length() - 1);
                sql.append(" ) OR ").append(columnName).append(" IN (");
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(" )");
        }
        return sql.toString();
    }

    public static String getSqlStrByArrays(String[] sqhArrays, int splitNum, String columnName) {
        return SearcherTool.getSqlStrByList(Arrays.asList(sqhArrays), splitNum, columnName);
    }

    public static WCMFilter makeTimeFilterByType(int _nFilterType, String _sTimeField) throws WCMException {
        WCMFilter filter = new WCMFilter("", _sTimeField + ">=?", "");
        try {
            switch (_nFilterType) {
                case 5: {
                    filter.addSearchValues(0, CMyDateTime.now().dateAdd(3, -3));
                    break;
                }
                case 6: {
                    filter.addSearchValues(0, CMyDateTime.now().dateAdd(12, -1));
                    break;
                }
                case 7: {
                    filter.addSearchValues(0, CMyDateTime.now().dateAdd(2, -1));
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(SearcherTool.class, "SearcherTool.label62", "\u6784\u9020\u65f6\u95f4\u8fc7\u6ee4\u5668\u5931\u8d25!"), e);
        }
        return filter;
    }

    public static WCMFilter makeFilterByType(User _loginUser, BaseObjs _oSitesOrChannels, int _nFilterType) throws Exception {
        if (_nFilterType == 0) {
            return null;
        }
        WCMFilter filter = new WCMFilter();
        String sWhere = null;
        switch (_nFilterType) {
            case 1: {
                sWhere = "WCMChnlDoc.DocStatus=?";
                filter.addSearchValues(0, 1);
                break;
            }
            case 3: {
                sWhere = "WCMChnlDoc.DocStatus=?";
                filter.addSearchValues(0, 10);
                break;
            }
            case 8: {
                sWhere = "WCMChnlDoc.DocStatus=?";
                filter.addSearchValues(0, 15);
                break;
            }
            case 9: {
                sWhere = "WCMChnlDoc.DocStatus=?";
                filter.addSearchValues(0, 2);
                break;
            }
            case 2: {
                if (_oSitesOrChannels.size() > 1) {
                    sWhere = "WCMChnlDoc.DocStatus in(1,2,16,18)";
                    break;
                }
                WebSite site = ((BaseChannel)_oSitesOrChannels.getAt(0)).getSite();
                IFolderPubStatusCacheMgr oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
                int[] pStatus = oCacheMgr.findStatusesCanDoIncreasePub(site.getWCMType(), site.getId());
                if (pStatus == null || pStatus.length == 0) {
                    pStatus = new int[]{-1};
                }
                for (int i = 0; i < pStatus.length; ++i) {
                    sWhere = sWhere == null ? "WCMChnlDoc.DocStatus in(?" : sWhere + ",?";
                    filter.addSearchValues(i, pStatus[i]);
                }
                if (sWhere == null) break;
                sWhere = sWhere + ")";
                break;
            }
            case 4: {
                sWhere = "WCMChnlDoc.CrUser=?";
                filter.addSearchValues(0, _loginUser.getName());
                break;
            }
            case 5: {
                sWhere = "WCMChnlDoc.CrTime>=?";
                filter.addSearchValues(0, CMyDateTime.now().dateAdd(3, -3));
                break;
            }
            case 6: {
                sWhere = "WCMChnlDoc.CrTime>=?";
                filter.addSearchValues(0, CMyDateTime.now().dateAdd(12, -1));
                break;
            }
            case 7: {
                sWhere = "WCMChnlDoc.CrTime>=?";
                filter.addSearchValues(0, CMyDateTime.now().dateAdd(2, -1));
                break;
            }
        }
        filter.setWhere(sWhere);
        return filter;
    }

    private static String extFilter(ExtendedField _sNewExtendedField, MethodContext _sContext) {
        String sTypeName = _sNewExtendedField.getTypeName();
        String sWhere = " ( WCMDocument." + _sNewExtendedField.getName();
        sWhere = sTypeName.equalsIgnoreCase("string") ? sWhere + " like ? ) " : sWhere + " = ? ) ";
        return sWhere;
    }

    public static String makeSelectFields(MethodContext _methContext) throws NumberFormatException, WCMException {
        String sChannelId = _methContext.getValue("ChannelId");
        String sSiteIds = _methContext.getValue("SiteIds");
        if (!CMyString.isEmpty(sSiteIds)) {
            return "";
        }
        if (CMyString.isEmpty(sChannelId)) {
            return "";
        }
        Channel oChnl = Channel.findById(Integer.parseInt(sChannelId));
        String sSelectFields = oChnl.getPropertyAsString("SHOWFIELDS");
        if (CMyString.isEmpty(sSelectFields)) {
            return "";
        }
        String sMustNeed = "WCMDocument.CRUSER,WCMDocument.CRTIME,WCMDocument.DOCTYPE,WCMDocument.DOCTITLE,WCMDocument.DOCID,WCMCHNLDOC.DOCCHANNEL,WCMDocument.ATTACHPIC,WCMDocument.DOCLINKTO,WCMDocument.DOCMIRRORTO,WCMCHNLDOC.CHNLID,WCMCHNLDOC.DOCORDERPRI,WCMCHNLDOC.MODAL,WCMCHNLDOC.INVALIDTIME,WCMCHNLDOC.DOCKIND,WCMChnlDoc.DocStatus,WCMCHNLDOC.RECID,WCMCHNLDOC.DOCID,WCMDocument.FLOWOPERATIONMARK";
        sSelectFields = sSelectFields + "," + sMustNeed;
        return sSelectFields;
    }

    public static WCMFilter getFilterForCopyOnly(MethodContext _methContext) {
        boolean bOnlyForCopy = _methContext.getValue("OnlyForCopy", false);
        WCMFilter extendFilter = new WCMFilter();
        if (bOnlyForCopy) {
            int nModal = _methContext.getValue("DocModal", 0);
            if (nModal == 5) {
                extendFilter.setWhere("WCMChnlDoc.Modal = 2 or WCMChnlDoc.Modal = 3");
            } else if (nModal == 4) {
                extendFilter.setWhere("WCMChnlDoc.Modal = 1 and WCMChnlDoc.DocOutUpId > 0");
            } else if (nModal == 1) {
                extendFilter.setWhere("WCMChnlDoc.Modal = 1 and WCMChnlDoc.DocOutUpId <= 0");
            }
        }
        return extendFilter;
    }

    public static WCMFilter getFilterForStatus(MethodContext _methContext) {
        String status = _methContext.getValue("DOCSTATUS");
        WCMFilter statusFilter = new WCMFilter();
        if (!CMyString.isEmpty(status)) {
            statusFilter.setWhere("WCMChnlDoc.DOCSTATUS in(" + CMyString.filterForSQL(status) + ")");
            return statusFilter;
        }
        return null;
    }

    public static String getFilterWhere(CMSBaseObjs _sObjects, String _sString) {
        String sWhere = "";
        if (_sObjects.size() == 1) {
            sWhere = sWhere + _sString + " = " + _sObjects.getIdAt(0);
        } else {
            sWhere = sWhere + _sString + " =(" + _sObjects.getIdAt(0);
            int nSize = _sObjects.size();
            for (int i = 1; i < nSize; ++i) {
                sWhere = sWhere + "," + _sObjects.getIdAt(i);
            }
            sWhere = sWhere + ")";
        }
        sWhere = sWhere + " and docstatus > 0";
        return sWhere;
    }

    public static void filterForUser(MethodContext _methContext, User loginUser, WCMFilter filter, Channels oQueryChannels) throws WCMException {
        boolean bInStat = _methContext.getValue("IsInStat", false);
        if (bInStat) {
            int nGroupId;
            String CrUser = _methContext.getValue("CrUser");
            String sWhere = "WCMChnlDoc.DocStatus > 0 and WCMChnlDoc.CHNLID>0 and WCMChnlDoc.DocStatus != 1028";
            if (CrUser != null && CrUser != "") {
                sWhere = sWhere + " and WCMChnlDoc.CrUser='" + CrUser + "'";
            }
            WCMFilter newFilter = new WCMFilter("", sWhere, "");
            Channels canManagerChannels = null;
            IChnlDeptMgr m_oChnlDeptMgr = (IChnlDeptMgr)DreamFactory.createObjectById("IChnlDeptMgr");
            Groups canManageGroups = new Groups(null);
            loginUser = ContextHelper.getLoginUser();
            Groups relateGroups = loginUser.getGroups();
            for (int i = 0; i < relateGroups.size(); ++i) {
                Group oGroup = (Group)relateGroups.getAt(i);
                if (!oGroup.isAdministrator(loginUser)) continue;
                canManageGroups.addElement(oGroup);
            }
            boolean isSiteAdmin = false;
            WebSites sites = WebSites.openWCMObjs(loginUser, null);
            for (int i = 0; i < sites.size(); ++i) {
                WebSite site = (WebSite)sites.getAt(i);
                if (!AuthServer.hasRight(loginUser, (CMSObj)site, 1)) continue;
                isSiteAdmin = true;
                break;
            }
            boolean bStat4SiteAdmin = false;
            String sStat4SiteAdmin = ConfigServer.getServer().getSysConfigValue("STAT_BY_SITEADMIN", "false");
            if (sStat4SiteAdmin != null && "true".equalsIgnoreCase(sStat4SiteAdmin.trim())) {
                bStat4SiteAdmin = true;
            }
            if ((nGroupId = _methContext.getValue("GroupId", 0)) != 0) {
                Group currGroup = Group.findById(nGroupId);
                if (isSiteAdmin && bStat4SiteAdmin) {
                    Users users = SearcherTool.getAllUsers(currGroup, loginUser);
                    Users _users = new Users(loginUser);
                    for (int i = 0; i < users.size(); ++i) {
                        if (users.getAt(i) == null) continue;
                        _users.addElement(users.getAt(i));
                    }
                    users = _users;
                    User currUser = null;
                    if (users != null && users.size() > 0) {
                        if (users.size() == 1) {
                            currUser = (User)users.getAt(0);
                            sWhere = sWhere + " and WCMChnlDoc.Cruser = ?";
                            newFilter.setWhere(sWhere);
                            User oTUser = User.findById(currUser.getId());
                            newFilter.addSearchValues(0, oTUser.getName());
                        } else {
                            int nsize = users.size();
                            for (int i = 0; i < nsize; ++i) {
                                currUser = (User)users.getAt(i);
                                sWhere = i == 0 ? sWhere + " and (WCMChnlDoc.CrUser = ? or " : (i != nsize - 1 ? sWhere + "WCMChnlDoc.CrUser = ? or " : sWhere + "WCMChnlDoc.CrUser = ?)");
                                User nTUser = User.findById(currUser.getId());
                                newFilter.addSearchValues(i, nTUser.getName());
                            }
                            newFilter.setWhere(sWhere);
                        }
                    }
                    filter.mergeWith(newFilter);
                } else {
                    Groups _groups = new Groups(loginUser);
                    block4: for (int i = 0; i < canManageGroups.size(); ++i) {
                        Group oGroup = (Group)canManageGroups.getAt(i);
                        for (Group tranGroup = (Group)oGroup.clone(); tranGroup != null; tranGroup = tranGroup.getParent()) {
                            if (tranGroup.getId() != currGroup.getId()) continue;
                            _groups.addElement(oGroup);
                            continue block4;
                        }
                    }
                    canManageGroups = _groups;
                }
            }
            if (isSiteAdmin && bStat4SiteAdmin) {
                String _sSiteIds = "";
                WebSites _sites = WebSites.openWCMObjs(loginUser, null);
                for (int i = 0; i < _sites.size(); ++i) {
                    WebSite site = (WebSite)_sites.getAt(i);
                    if (!AuthServer.hasRight(loginUser, (CMSObj)site, 1)) continue;
                    _sSiteIds = _sSiteIds.length() <= 0 ? _sSiteIds + site.getId() : _sSiteIds + "," + site.getId();
                }
                if (_sSiteIds.length() > 0) {
                    _sSiteIds = "SITEID in (" + _sSiteIds + ")";
                    canManagerChannels = Channels.openWCMObjs(loginUser, new WCMFilter("", _sSiteIds, ""));
                    Channels dChannels = new Channels(null);
                    for (int i = 0; i < oQueryChannels.size(); ++i) {
                        Channel oChannel = (Channel)oQueryChannels.getAt(i);
                        if (canManagerChannels.indexOf(oChannel) < 0) continue;
                        dChannels.addElement(oChannel);
                    }
                    oQueryChannels = dChannels;
                }
            } else if (canManageGroups == null || canManageGroups.size() == 0) {
                oQueryChannels = null;
            } else {
                String oChannelIds = m_oChnlDeptMgr.getChnlIdsByDepts(canManageGroups);
                canManagerChannels = Channels.findByIds(loginUser, oChannelIds);
                Channels dChannels = new Channels(null);
                for (int i = 0; i < oQueryChannels.size(); ++i) {
                    Channel oChannel = (Channel)oQueryChannels.getAt(i);
                    if (canManagerChannels.indexOf(oChannel) < 0) continue;
                    dChannels.addElement(oChannel);
                }
                oQueryChannels = dChannels;
            }
        }
    }

    public static Users getAllUsers(Group _oCurrGroup, User _oUser) throws WCMException {
        Users allUsers = _oCurrGroup.getUsers(_oUser);
        WCMFilter filter = new WCMFilter("", "ParentId = ?", "");
        filter.addSearchValues(0, _oCurrGroup.getId());
        Groups childGroups = Groups.openWCMObjs(_oUser, filter);
        if (childGroups.size() > 0) {
            int nsize = childGroups.size();
            for (int i = 0; i < nsize; ++i) {
                Group tempGroup = (Group)childGroups.getAt(i);
                if (tempGroup == null) continue;
                allUsers.addWith(SearcherTool.getAllUsers(tempGroup, _oUser));
            }
        }
        return allUsers;
    }
}

