/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.DocumentImporter;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.Reports;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FtpSoap4Radar {
    public String importViaFtp(String fn) {
        return Importer.importDocs(fn);
    }

    private static class Importer {
        private static final Logger logger = Logger.getLogger(Importer.class);
        private static final String CONF = "/ftpsoap4radar.properties";
        private boolean m_zServiceable = false;
        private boolean m_zImporteDup = false;
        private String m_sFtpDir = null;
        private String m_sUnerviceAble = null;
        private User m_oUser = null;
        private static final Importer IMPORTER = new Importer();

        private Importer() {
            this.loadConf();
        }

        public static String importDocs(String fn) {
            return IMPORTER.importDocs0(fn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadConf() {
            Class<FtpSoap4Radar> clazz = FtpSoap4Radar.class;
            InputStream ins = null;
            Properties props = null;
            try {
                ins = clazz.getResourceAsStream(CONF);
                if (ins == null) {
                    ins = clazz.getResourceAsStream(CONF.substring(1));
                }
                props = new Properties();
                props.load(ins);
            }
            catch (Exception e) {
                logger.error((Object)"load ftpsoap4radar.properties fail!", (Throwable)e);
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (Exception e) {}
                }
            }
            if (props == null) {
                return;
            }
            String temp = props.getProperty("soapftp.dir");
            if (temp == null || temp.trim().length() == 0) {
                logger.error((Object)"soapftp.dir not set!");
            } else {
                FileService file = new FileService(temp);
                if (!file.exists()) {
                    logger.error((Object)"soapftp.dir doesn't exists!");
                } else if (!file.isDirectory()) {
                    logger.error((Object)"soapftp.dir isn't a directory!");
                } else {
                    this.m_zServiceable = true;
                    this.m_sFtpDir = file.getAbsolutePath() + File.separator;
                    logger.info((Object)("soapftp.dir:" + this.m_sFtpDir));
                    file = null;
                }
            }
            if (this.m_zServiceable) {
                temp = props.getProperty("import.doctitle.duplicated");
                this.m_zImporteDup = "true".equals(temp);
                temp = props.getProperty("import.username", "system");
                ContextHelper.initContext(User.getSystem());
                this.m_oUser = User.findByName(temp);
                if (this.m_oUser == null) {
                    this.m_oUser = User.getSystem();
                }
            } else {
                StringBuffer buff = new StringBuffer(256);
                buff.append("\n<REPORTS>\n<IS-SUCCESS>false</IS-SUCCESS>\n");
                buff.append("<TITLE><![CDATA[");
                buff.append(I18NMessage.get(FtpSoap4Radar.class, "FtpSoap4Radar.label1", "WCM\u670d\u52a1\u662f\u4e0d\u53ef\u53ca\u7684,\u53ef\u80fd\u662f\u4e34\u65f6\u5de5\u4f5c\u76ee\u5f55["));
                buff.append(this.m_sFtpDir);
                buff.append(I18NMessage.get(FtpSoap4Radar.class, "FtpSoap4Radar.label2", "]\u4e0d\u53ef\u7528!"));
                buff.append("]]></TITLE>\n");
                buff.append("<REPORT>\n<IS-SUCCESS>false</IS-SUCCESS>\n");
                buff.append(I18NMessage.get(FtpSoap4Radar.class, "FtpSoap4Radar.label3", "<TITLE><![CDATA[\u4e0d\u80fd\u5bfc\u5165\u6587\u6863]]></TITLE>\n"));
                buff.append(I18NMessage.get(FtpSoap4Radar.class, "FtpSoap4Radar.label4", "<ERROR-INFO><![CDATA[WCM\u4e34\u65f6\u5de5\u4f5c\u76ee\u5f55\u4e0d\u53ef\u7528]]>"));
                buff.append("</ERROR-INFO>\n</REPORT>\n</REPORTS>");
                this.m_sUnerviceAble = buff.toString();
                buff.setLength(0);
                buff = null;
            }
            props.clear();
            props = null;
        }

        private String importDocs0(String fn) {
            if (this.m_zServiceable) {
                Reports reports = new Reports(I18NMessage.get(FtpSoap4Radar.class, "FtpSoap4Radar.label5", "\u5bfc\u5165\u6587\u6863"));
                try {
                    fn = this.m_sFtpDir + fn;
                    ContextHelper.initContext(this.m_oUser);
                    DocumentImporter docimporter = new DocumentImporter();
                    reports = docimporter.importFromFile(fn, null, null, this.m_zImporteDup, false);
                    if (logger.isDebugEnabled()) {
                        StringBuffer debugmsg = new StringBuffer(512);
                        debugmsg.append("Success=[");
                        debugmsg.append(reports.getSucessedReporter().size());
                        debugmsg.append("]Faile=[");
                        debugmsg.append(reports.getFailedReporter().size());
                        debugmsg.append("]Waring=[");
                        debugmsg.append(reports.getWarnedReporter().size());
                        debugmsg.append("]\n");
                        debugmsg.append(reports.toXML());
                        logger.debug((Object)debugmsg);
                    }
                    return reports.toXML();
                }
                catch (Throwable t) {
                    StringBuffer msg = new StringBuffer(64);
                    msg.append(I18NMessage.get(FtpSoap4Radar.class, "FtpSoap4Radar.label6", "\u4ece\u6587\u4ef6["));
                    msg.append(fn);
                    msg.append(I18NMessage.get(FtpSoap4Radar.class, "FtpSoap4Radar.label7", "]\u4e2d\u5bfc\u5165\u6587\u6863!"));
                    reports.setTitle(msg.toString());
                    reports.addFailedReport(msg.toString(), t);
                    return reports.toXML();
                }
            }
            return this.m_sUnerviceAble;
        }
    }
}

