/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cache;

import com.trs.infra.cache.Cache;
import com.trs.infra.cache.CacheKey;
import com.trs.infra.cache.CacheLayer;
import com.trs.infra.cache.JedisHelper;
import com.trs.infra.cache.SerializationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import redis.clients.jedis.Jedis;

public class RedisCache
implements Cache {
    private static Logger logger = Logger.getLogger(RedisCache.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        CacheKey cacheKey = new CacheKey("get", key);
        Object cacheValue = CacheLayer.get(cacheKey);
        if (cacheValue != null) {
            return cacheValue;
        }
        Jedis redis = JedisHelper.getJedis();
        try {
            byte[] value = redis.get(SerializationUtil.serialize(key));
            cacheValue = SerializationUtil.deserialize(value);
            CacheLayer.set(cacheKey, cacheValue);
            Object object = cacheValue;
            return object;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String set(Object key, Object value) {
        Jedis redis = JedisHelper.getJedis();
        try {
            String result = redis.set(SerializationUtil.serialize(key), SerializationUtil.serialize(value));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("key:" + key + ";\nvlaue:" + value + ";\nresult:" + result));
            }
            CacheLayer.disable(key);
            String string = result;
            return string;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean exists(Object key) {
        CacheKey cacheKey = new CacheKey("exists", key);
        Object cacheValue = CacheLayer.get(cacheKey);
        if (cacheValue != null) {
            return (Boolean)cacheValue;
        }
        Jedis redis = JedisHelper.getJedis();
        try {
            Boolean result = redis.exists(SerializationUtil.serialize(key));
            CacheLayer.set(cacheKey, result);
            Boolean bl = result;
            return bl;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    @Override
    public void clear(Object key) {
        Jedis redis = JedisHelper.getJedis();
        try {
            redis.del(SerializationUtil.serialize(key));
            CacheLayer.disable(key);
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lpush(Object key, Object ... values) {
        Jedis redis = JedisHelper.getJedis();
        try {
            byte[][] byteValues = new byte[values.length][];
            for (int i = 0; i < values.length; ++i) {
                byteValues[i] = SerializationUtil.serialize(values[i]);
            }
            Long result = redis.lpush(SerializationUtil.serialize(key), (byte[][])byteValues);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("key:" + key + ";\nvlaue:" + values + ";\nresult:" + result));
            }
            CacheLayer.disable(key);
            Long l = result;
            return l;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpush(Object key, Object value) {
        Jedis redis = JedisHelper.getJedis();
        try {
            Long result = redis.rpush(SerializationUtil.serialize(key), (byte[][])new byte[][]{SerializationUtil.serialize(value)});
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("key:" + key + ";\nvlaue:" + value + ";\nresult:" + result));
            }
            CacheLayer.disable(key);
            Long l = result;
            return l;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> lrange(Object key, long start, long end) {
        CacheKey cacheKey = new CacheKey("lrange", key, start, end);
        Object cacheValue = CacheLayer.get(cacheKey);
        if (cacheValue != null) {
            return (List)cacheValue;
        }
        Jedis redis = JedisHelper.getJedis();
        try {
            List byteList = redis.lrange(SerializationUtil.serialize(key), start, end);
            ArrayList<Object> objectList = new ArrayList<Object>(byteList.size());
            int length = byteList.size();
            for (int i = 0; i < length; ++i) {
                objectList.add(SerializationUtil.deserialize((byte[])byteList.get(i)));
            }
            CacheLayer.set(cacheKey, objectList);
            ArrayList<Object> arrayList = objectList;
            return arrayList;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long llen(Object key) {
        CacheKey cacheKey = new CacheKey("llen", key);
        Object cacheValue = CacheLayer.get(cacheKey);
        if (cacheValue != null) {
            return (Long)cacheValue;
        }
        Jedis redis = JedisHelper.getJedis();
        try {
            Long longValue = redis.llen(SerializationUtil.serialize(key));
            CacheLayer.set(cacheKey, longValue);
            Long l = longValue;
            return l;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lindex(Object key, long index) {
        CacheKey cacheKey = new CacheKey("lindex", key, index);
        Object cacheValue = CacheLayer.get(cacheKey);
        if (cacheValue != null) {
            return cacheValue;
        }
        Jedis redis = JedisHelper.getJedis();
        try {
            byte[] value = redis.lindex(SerializationUtil.serialize(key), index);
            cacheValue = SerializationUtil.deserialize(value);
            CacheLayer.set(cacheKey, cacheValue);
            Object object = cacheValue;
            return object;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lset(Object key, long index, Object value) {
        Jedis redis = JedisHelper.getJedis();
        try {
            String result = redis.lset(SerializationUtil.serialize(key), index, SerializationUtil.serialize(value));
            CacheLayer.disable(key);
            String string = result;
            return string;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lpop(Object key) {
        Jedis redis = JedisHelper.getJedis();
        try {
            byte[] value = redis.lpop(SerializationUtil.serialize(key));
            Object result = SerializationUtil.deserialize(value);
            CacheLayer.disable(key);
            Object object = result;
            return object;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object rpop(Object key) {
        Jedis redis = JedisHelper.getJedis();
        try {
            byte[] value = redis.rpop(SerializationUtil.serialize(key));
            Object result = SerializationUtil.deserialize(value);
            CacheLayer.disable(key);
            Object object = result;
            return object;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lrem(Object key, long count, Object value) {
        Jedis redis = JedisHelper.getJedis();
        try {
            Long result = redis.lrem(SerializationUtil.serialize(key), count, SerializationUtil.serialize(value));
            if (logger.isDebugEnabled()) {
                StringBuffer sbInfo = new StringBuffer();
                sbInfo.append("\nkey-type:").append(key.getClass());
                sbInfo.append("\nkey-value:").append(key);
                sbInfo.append("\ncount:").append(count);
                sbInfo.append("\nvalue-type:").append(value.getClass());
                sbInfo.append("\nvalue-value:").append(value);
                sbInfo.append("\nresult:").append(result);
                logger.debug((Object)sbInfo.toString());
            }
            CacheLayer.disable(key);
            Long l = result;
            return l;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hset(Object key, Object field, Object value) {
        Jedis redis = JedisHelper.getJedis();
        try {
            byte[] byteKey = SerializationUtil.serialize(key);
            byte[] byteField = SerializationUtil.serialize(field);
            byte[] byteValue = SerializationUtil.serialize(value);
            Long result = redis.hset(byteKey, byteField, byteValue);
            if (logger.isDebugEnabled()) {
                StringBuffer sbInfo = new StringBuffer();
                sbInfo.append("\nkey-type:").append(key.getClass());
                sbInfo.append("\nkey-value:").append(key);
                sbInfo.append("\nfield-type:").append(field.getClass());
                sbInfo.append("\nfield-value:").append(field);
                sbInfo.append("\nvalue-type:").append(value.getClass());
                sbInfo.append("\nvalue-value:").append(value);
                sbInfo.append("\nresult:").append(result);
                logger.debug((Object)sbInfo.toString());
            }
            CacheLayer.disable(key);
            Long l = result;
            return l;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object hget(Object key, Object field) {
        CacheKey cacheKey = new CacheKey("hget", key, field);
        Object cacheValue = CacheLayer.get(cacheKey);
        if (cacheValue != null) {
            return cacheValue;
        }
        Jedis redis = JedisHelper.getJedis();
        try {
            byte[] byteKey = SerializationUtil.serialize(key);
            byte[] byteField = SerializationUtil.serialize(field);
            byte[] value = redis.hget(byteKey, byteField);
            Object result = SerializationUtil.deserialize(value);
            if (logger.isDebugEnabled()) {
                StringBuffer sbInfo = new StringBuffer();
                sbInfo.append("\nkey-type:").append(key.getClass());
                sbInfo.append("\nkey-value:").append(key);
                sbInfo.append("\nfield-type:").append(field.getClass());
                sbInfo.append("\nfield-value:").append(field);
                sbInfo.append("\nvalue-value:").append(value);
                sbInfo.append("\nresult:").append(result);
                logger.debug((Object)sbInfo.toString());
            }
            CacheLayer.set(cacheKey, result);
            Object object = result;
            return object;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hmset(Object key, Map<Object, Object> hash) {
        Jedis redis = JedisHelper.getJedis();
        try {
            HashMap<byte[], byte[]> byteHash = new HashMap<byte[], byte[]>(hash.size());
            for (Map.Entry<Object, Object> entry : hash.entrySet()) {
                byteHash.put(SerializationUtil.serialize(entry.getKey()), SerializationUtil.serialize(entry.getValue()));
            }
            String result = redis.hmset(SerializationUtil.serialize(key), byteHash);
            CacheLayer.disable(key);
            String string = result;
            return string;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> hmget(Object key, Object ... fields) {
        CacheKey cacheKey = new CacheKey("hmget", key, fields);
        Object cacheValue = CacheLayer.get(cacheKey);
        if (cacheValue != null) {
            return (List)cacheValue;
        }
        Jedis redis = JedisHelper.getJedis();
        try {
            byte[][] byteFields = new byte[fields.length][];
            for (int i = 0; i < fields.length; ++i) {
                byteFields[i] = SerializationUtil.serialize(fields[i]);
            }
            List byteList = redis.hmget(SerializationUtil.serialize(key), (byte[][])byteFields);
            ArrayList<Object> objectList = new ArrayList<Object>(byteList.size());
            int length = byteList.size();
            for (int i = 0; i < length; ++i) {
                objectList.set(i, SerializationUtil.deserialize((byte[])byteList.get(i)));
            }
            CacheLayer.set(cacheKey, objectList);
            ArrayList<Object> arrayList = objectList;
            return arrayList;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map hgetAll(Object key) {
        CacheKey cacheKey = new CacheKey("hgetAll", key);
        Object cacheValue = CacheLayer.get(cacheKey);
        if (cacheValue != null) {
            return (Map)cacheValue;
        }
        Jedis redis = JedisHelper.getJedis();
        try {
            Map byteValue = redis.hgetAll(SerializationUtil.serialize(key));
            HashMap<Object, Object> objectValue = new HashMap<Object, Object>(byteValue.size());
            for (Map.Entry entry : byteValue.entrySet()) {
                objectValue.put(SerializationUtil.deserialize((byte[])entry.getKey()), SerializationUtil.deserialize((byte[])entry.getValue()));
            }
            CacheLayer.set(cacheKey, objectValue);
            HashMap<Object, Object> hashMap = objectValue;
            return hashMap;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Object> hkeys(Object key) {
        CacheKey cacheKey = new CacheKey("hkeys", key);
        Object cacheValue = CacheLayer.get(cacheKey);
        if (cacheValue != null) {
            return (Set)cacheValue;
        }
        Jedis redis = JedisHelper.getJedis();
        try {
            Set keys = redis.hkeys(SerializationUtil.serialize(key));
            HashSet<Object> result = new HashSet<Object>(keys.size());
            for (byte[] entry : keys) {
                result.add(SerializationUtil.deserialize(entry));
            }
            CacheLayer.set(cacheKey, result);
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hlen(Object key) {
        CacheKey cacheKey = new CacheKey("hlen", key);
        Object cacheValue = CacheLayer.get(cacheKey);
        if (cacheValue != null) {
            return (Long)cacheValue;
        }
        Jedis redis = JedisHelper.getJedis();
        try {
            Long longValue = redis.hlen(SerializationUtil.serialize(key));
            CacheLayer.set(cacheKey, longValue);
            Long l = longValue;
            return l;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean hexists(Object key, Object field) {
        CacheKey cacheKey = new CacheKey("hexists", key, field);
        Object cacheValue = CacheLayer.get(cacheKey);
        if (cacheValue != null) {
            return (Boolean)cacheValue;
        }
        Jedis redis = JedisHelper.getJedis();
        try {
            Boolean result = redis.hexists(SerializationUtil.serialize(key), SerializationUtil.serialize(field));
            CacheLayer.set(cacheKey, result);
            Boolean bl = result;
            return bl;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hdel(Object key, Object ... fields) {
        Jedis redis = JedisHelper.getJedis();
        try {
            byte[][] byteFields = new byte[fields.length][];
            for (int i = 0; i < fields.length; ++i) {
                byteFields[i] = SerializationUtil.serialize(fields[i]);
            }
            Long result = redis.hdel(SerializationUtil.serialize(key), (byte[][])byteFields);
            CacheLayer.disable(key);
            Long l = result;
            return l;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }

    @Override
    public void setMaxSize(long maxSize) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long pexpire(Object key, long milliseconds) {
        Jedis redis = JedisHelper.getJedis();
        try {
            Long l = redis.pexpire(SerializationUtil.serialize(key), milliseconds);
            return l;
        }
        finally {
            JedisHelper.returnResource(redis);
        }
    }
}

