/*
 * Decompiled with CFR 0.152.
 */
package com.trs.database.util;

import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Properties;

public class TableDDLMakerFromMsSql {
    private static final String CONF = "/database.properties";
    private static final String[] DB_TYPES = new String[]{"mssql", "sybase", "oracle", "db2", "mysql", "kingbase"};
    private String dbname;
    private String user;
    private String passwd;
    private Properties props;

    public TableDDLMakerFromMsSql(String dbname, String user, String passwd) {
        this.dbname = dbname;
        this.user = user;
        this.passwd = passwd;
        this.props = new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSql(String tabnames) throws Exception {
        this.loadAndInit();
        Connection conn = null;
        String url = "jdbc:jtds:sqlserver://127.0.0.1:1433/" + this.dbname;
        try {
            conn = DriverManager.getConnection(url, this.user, this.passwd);
            String[] tabs = tabnames.toUpperCase().split(",");
            String[] dbtypes = DB_TYPES;
            for (String tab : tabs) {
                for (String dbtype : dbtypes) {
                    System.out.println("-- ddl for " + dbtype);
                    this.makeTableDDL(conn, tab, dbtype + ".");
                }
                this.makeIndexDDL(conn, tab);
                System.out.println("----------------------");
                System.out.println();
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
            this.props.clear();
        }
    }

    private void loadAndInit() throws Exception {
        InputStream ins = null;
        try {
            Class<?> clazz = this.getClass();
            ins = clazz.getResourceAsStream(CONF);
            if (ins == null) {
                ins = clazz.getResourceAsStream(CONF.substring(1));
            }
            this.props.load(ins);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
        }
        Class.forName("net.sourceforge.jtds.jdbc.Driver");
    }

    private void makeTableDDL(Connection conn, String tabname, String dbtype) throws Exception {
        DatabaseMetaData dbMetaData = conn.getMetaData();
        ResultSet tables = dbMetaData.getTables(null, null, tabname, new String[]{"TABLE"});
        if (!tables.next()) {
            System.out.println("-- No such table: " + tabname);
            return;
        }
        StringBuffer buff = new StringBuffer(128);
        String delimiter = "mysql.".equals(dbtype) ? "`" : "\"";
        String tableName = tables.getString(3).toUpperCase();
        buff.setLength(0);
        buff.append("CREATE TABLE ");
        buff.append(delimiter);
        buff.append(tableName);
        buff.append(delimiter);
        buff.append("(\n");
        String pk = "";
        ResultSet pks = dbMetaData.getPrimaryKeys(null, null, tableName);
        while (pks.next()) {
            pk = pk + "," + delimiter + pks.getString("COLUMN_NAME") + delimiter;
        }
        pks.close();
        ResultSet columns = dbMetaData.getColumns(null, null, tableName, null);
        boolean zNotFirst = false;
        boolean doublelen = !"mssql.".equals(dbtype);
        boolean useNull = "true".equals(this.props.getProperty(dbtype + "useNull"));
        while (columns.next()) {
            boolean zCharType;
            if (zNotFirst) {
                buff.append(",\n");
            }
            String colName = columns.getString("COLUMN_NAME").toUpperCase();
            buff.append("\t");
            buff.append(delimiter);
            buff.append(colName);
            buff.append(delimiter);
            buff.append(" ");
            String typeName = columns.getString("TYPE_NAME").toUpperCase();
            typeName = (String)this.props.get(dbtype + typeName);
            if (typeName == null) {
                typeName = columns.getString("TYPE_NAME").toUpperCase();
            }
            buff.append(typeName.toUpperCase());
            int colType = columns.getInt("DATA_TYPE");
            boolean bl = zCharType = 1 == colType || 12 == colType;
            if (zCharType) {
                buff.append("(");
                int colSize = columns.getInt("COLUMN_SIZE");
                if (doublelen) {
                    colSize = Math.min(colSize * 2, 4000);
                }
                buff.append(colSize);
                buff.append(")");
            } else if (colType == 2) {
                buff.append("(");
                buff.append(columns.getInt("COLUMN_SIZE"));
                buff.append(',');
                buff.append(columns.getInt("DECIMAL_DIGITS"));
                buff.append(")");
            }
            String def = columns.getString("COLUMN_DEF");
            if (def != null) {
                def = def.substring(1, def.length() - 1);
                if (!zCharType) {
                    if (def.charAt(0) == 'g') {
                        def = this.props.getProperty(dbtype + "getdate");
                    } else {
                        while (def.indexOf(40) != -1) {
                            def = def.substring(1, def.length() - 1);
                        }
                    }
                } else if (def.indexOf(39) == -1) {
                    def = '\'' + def + '\'';
                }
                buff.append(" DEFAULT ").append(def);
            }
            if (!"YES".equals(columns.getString("IS_NULLABLE"))) {
                buff.append(" NOT NULL");
            } else if (useNull && pk.indexOf(colName) == -1) {
                buff.append(" NULL");
            }
            zNotFirst = true;
        }
        columns.close();
        if (pk.length() > 1) {
            buff.append(",\n\tPRIMARY KEY (");
            buff.append(pk.substring(1));
            buff.append(")");
        }
        buff.append("\n);\n");
        System.out.println(buff);
        tables.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeIndexDDL(Connection conn, String tabname) throws Exception {
        HashSet<String> indexSet = new HashSet<String>(100, 0.2f);
        StringBuffer buff = new StringBuffer(128);
        CallableStatement callableStmt = null;
        ResultSet rs = null;
        try {
            callableStmt = conn.prepareCall("sp_helpindex ?");
            callableStmt.setString(1, tabname);
            rs = callableStmt.executeQuery();
            while (rs.next()) {
                int dif;
                String indexName = rs.getString(1).toUpperCase();
                String indexDesc = rs.getString(2).toUpperCase();
                String indexKeys = rs.getString(3).toUpperCase();
                String entryKey = tabname + "(" + indexKeys + ")";
                if (indexSet.contains(entryKey)) {
                    System.err.println("-- duplicate index on " + entryKey);
                    continue;
                }
                indexSet.add(entryKey);
                if (indexDesc.indexOf("PRIMARY KEY") != -1) continue;
                buff.append("create ");
                if (indexDesc.indexOf("UNIQUE") != -1) {
                    buff.append("UNIQUE ");
                }
                if (indexDesc.indexOf("NONCLUSTERED") == -1 && indexDesc.indexOf("CLUSTERED") != -1) {
                    buff.append("CLUSTERED ");
                }
                buff.append("index ");
                if (!indexName.startsWith("IX_")) {
                    indexName = "IX_" + indexName;
                }
                if ((dif = indexName.length() - 30) >= 10) {
                    indexName = indexName.substring(0, 28) + dif;
                } else if (dif > 0) {
                    indexName = indexName.substring(0, 29) + dif;
                }
                buff.append(indexName);
                buff.append(" on ").append(tabname);
                buff.append('(');
                indexKeys = indexKeys.replaceAll("\\(-\\)", " desc");
                buff.append(indexKeys);
                buff.append(')');
                buff.append(';');
                buff.append('\n');
                System.out.println(buff.toString().toUpperCase());
                buff.setLength(0);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (callableStmt != null) {
                try {
                    callableStmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

