/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.element;

import com.trs.DreamFactory;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.config.persistent.FileNamedStyle;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import java.util.HashMap;

public abstract class PublishContentImplBase
implements IPublishContent {
    protected IPublishFolder m_folder = null;
    protected IPublishFolder m_realHome = null;
    protected Template m_oDetailTemplate = null;
    protected int m_nDetailTemplateType;

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public IPublishFolder getFolder() {
        return this.m_folder;
    }

    @Override
    public void setFolder(IPublishFolder _folder) {
        this.m_folder = _folder;
        this.m_oDetailTemplate = null;
        this.m_realHome = null;
    }

    @Override
    public String getEncoding() throws WCMException {
        return this.m_folder.getEncoding();
    }

    @Override
    public IPublishFolder getRealHome() throws WCMException {
        if (this.m_realHome == null) {
            if (Math.abs(this.getModal()) == 3) {
                this.m_realHome = this.m_folder;
                if (this.m_realHome == null) {
                    throw new WCMException(1100, "Current folder where this content lies required (call setFolder())!");
                }
            } else {
                this.m_realHome = this.getOriginalHome();
                if (this.m_realHome == null) {
                    throw new WCMException(1100, "Original home folder of content not found!");
                }
            }
        }
        return this.m_realHome;
    }

    @Override
    public HashMap getTemplateArguments() throws WCMException {
        IPublishFolder folder = this.getFolder();
        if (folder == null) {
            return null;
        }
        return folder.getTemplateArguments();
    }

    @Override
    public Template getDetailTemplate() {
        if (this.m_oDetailTemplate == null) {
            TemplateEmployMgr mgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            Template template = null;
            try {
                template = mgr.getDetailTemplate(this, this.getDetailTemplateType());
                String siteIds = "," + ConfigServer.getServer().getSysConfigValue("DOCUMENT_FILTER_OWNERTEMPLATE_BY_SITEIDS", "").trim() + ",";
                if (siteIds.length() > 2) {
                    if (this.m_folder == null) {
                        throw new RuntimeException("[" + this.getInfo() + I18NMessage.get(PublishContentImplBase.class, "PublishContentImplBase.label3", "]\u6ca1\u6709\u8bbe\u7f6e\u6240\u5c5e\u680f\u76ee"));
                    }
                    Channel chnl = Channel.findById(this.getFolder().getId());
                    int id = chnl.getSiteId();
                    String siteId = "," + String.valueOf(id) + ",";
                    if (siteIds.indexOf(siteId) >= 0) {
                        template = null;
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(I18NMessage.get(PublishContentImplBase.class, "PublishContentImplBase.label1", "\u83b7\u53d6\u6a21\u677f[") + this.getInfo() + I18NMessage.get(PublishContentImplBase.class, "PublishContentImplBase.label2", "]\u5931\u8d25!"), e);
            }
            if (template == null) {
                if (this.m_folder == null) {
                    throw new RuntimeException("[" + this.getInfo() + I18NMessage.get(PublishContentImplBase.class, "PublishContentImplBase.label3", "]\u6ca1\u6709\u8bbe\u7f6e\u6240\u5c5e\u680f\u76ee"));
                }
                try {
                    template = this.getModal() == 2 ? this.getOriginalHome().getDetailTemplate() : this.m_folder.getDetailTemplate();
                }
                catch (WCMException e) {
                    throw new RuntimeException(I18NMessage.get(PublishContentImplBase.class, "PublishContentImplBase.label4", "\u83b7\u53d6[") + this.getInfo() + I18NMessage.get(PublishContentImplBase.class, "PublishContentImplBase.label5", "]\u7684Modal\u53d1\u751f\u5f02\u5e38!"), e);
                }
            }
            this.m_oDetailTemplate = template;
        }
        return this.m_oDetailTemplate;
    }

    public int getDetailTemplateType() {
        if (this.m_nDetailTemplateType <= 0) {
            this.m_nDetailTemplateType = 2;
        }
        return this.m_nDetailTemplateType;
    }

    public void setDetailTemplateType(int detailTemplateType) {
        this.m_nDetailTemplateType = detailTemplateType;
    }

    @Override
    public String getInfo() {
        return this.getSubstance().toString();
    }

    @Override
    public boolean canDoPreview() {
        return true;
    }

    public boolean equals(Object _another) {
        if (_another == this) {
            return true;
        }
        if (!(_another instanceof IPublishContent)) {
            return false;
        }
        IPublishContent anotherCMS = (IPublishContent)_another;
        return this.getType() == anotherCMS.getType() && this.getId() == anotherCMS.getId();
    }

    @Override
    public int getId() {
        if (this.getSubstance() == null) {
            return 0;
        }
        return this.getSubstance().getId();
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public String getLinkUrl() {
        return null;
    }

    @Override
    public int getModal() throws WCMException {
        return 1;
    }

    @Override
    public boolean validateCanDoPub() throws WCMException {
        return true;
    }

    @Override
    public boolean isValidElement() {
        return true;
    }

    @Override
    public CMyDateTime getCreatedTime() {
        return this.getSubstance().getCrTime();
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public String getFileName() {
        return null;
    }

    @Override
    public FileNamedStyle getFileNamedStyle() {
        return PublishServerConfigMapper.getDetailFileNamedStyle("CommonFileNamedStyle");
    }
}

