/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.definition.FlowNode;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyBitsValue;

public class FlowNodeBranch
extends CMSObj {
    private static final long serialVersionUID = 1L;
    public static final int OBJ_TYPE = 404;
    public static final String DB_TABLE_NAME = "WCMFLOWBRANCH";
    public static final String DB_ID_NAME = "BRANCHID";
    private FlowNode nextNode = null;
    private boolean bNextNodeLoaded = false;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 404;
    }

    public int getNodeId() {
        return this.getPropertyAsInt("NODEID", 0);
    }

    public FlowNode getNode() throws WCMException {
        return FlowNode.findById(this.getNodeId());
    }

    public boolean setNode(FlowNode _node) throws WCMException {
        if (_node == null || _node.getId() <= 0) {
            throw new WCMException(1100, I18NMessage.get(FlowNodeBranch.class, "FlowNodeBranch.label1", "\u65e0\u6548\u7684\u8282\u70b9\u5bf9\u8c61\uff08FlowNodeBranch.setNode\uff09"));
        }
        return this.setNode(_node.getId());
    }

    public boolean setNode(int _nNodeId) throws WCMException {
        return this.setProperty("NodeId", _nNodeId);
    }

    public String getNextNodeName() {
        return (String)this.getProperty("NextName");
    }

    public boolean setNextNodeName(String _NextName) throws WCMException {
        return this.setPropertyWithString("NextName", _NextName);
    }

    public int getStatusId() {
        return this.getPropertyAsInt("STATUS", 0);
    }

    public Status getStatus() throws WCMException {
        return Status.findById(this.getStatusId());
    }

    public boolean setStatus(int _statusId) throws WCMException {
        Status status = Status.findById(_statusId);
        return this.setStatus(status);
    }

    public boolean setStatus(Status _status) throws WCMException {
        if (_status == null || !_status.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(FlowNodeBranch.class, "FlowNodeBranch.label2", "\u65e0\u6548\u7684Status\u5bf9\u8c61\uff08FlowNodeBranch.setStatus\uff09"));
        }
        return this.setProperty("STATUS", _status.getId());
    }

    public int getNotify() {
        return this.getPropertyAsInt("NOTIFY", 0);
    }

    public String getNotifyTypes() {
        return this.convertToMsgTypes(this.getNotify());
    }

    public boolean setNotify(long _notify) throws WCMException {
        return this.setProperty("NOTIFY", new Long(_notify).intValue());
    }

    public boolean isNotifyBy(int _notifyType) {
        return CMyBitsValue.getBit(this.getNotify(), _notifyType);
    }

    public boolean setNotifyBy(int _notifyType, boolean _bValue) throws WCMException {
        Number iNotifyNew = (Number)this.getNewProperty("NOTIFY");
        long lValue = iNotifyNew != null ? iNotifyNew.intValue() : this.getNotify();
        lValue = CMyBitsValue.setBit(lValue, _notifyType, _bValue);
        return this.setNotify(lValue);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("NODEID") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowNodeBranch.class, "FlowNodeBranch.label3", "\u5c5e\u6027NodeId\u6ca1\u6709\u8bbe\u7f6e(FlowNodeBranch.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(FlowNodeBranch.class, "FlowNodeBranch.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(FlowNodeBranch.isValid)"));
        }
        return true;
    }

    @Override
    public synchronized void update(User _user) throws WCMException {
        String sOldName;
        boolean bNextNodeChanged = false;
        String sNewName = (String)this.getNewProperty("NEXTNAME");
        if (sNewName != null && sNewName.compareTo(sOldName = this.getNextNodeName()) != 0) {
            bNextNodeChanged = true;
        }
        super.update(_user);
        if (bNextNodeChanged && this.bNextNodeLoaded) {
            this.bNextNodeLoaded = false;
            this.nextNode = null;
        }
    }

    public synchronized FlowNode getNextNode(User _currUser) throws WCMException {
        if (!this.bNextNodeLoaded) {
            FlowNode currNode = this.getNode();
            IFlowServer flowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
            this.nextNode = currNode != null && flowServer != null ? FlowNode.findByName(currNode.getFlowId(), this.getNextNodeName()) : null;
            this.bNextNodeLoaded = true;
        }
        return this.nextNode;
    }

    private String convertToMsgTypes(int _nNotify) {
        StringBuffer buff = new StringBuffer(64);
        if (CMyBitsValue.getBitOfInt(_nNotify, 1)) {
            buff.append(',').append("Email");
        }
        if (CMyBitsValue.getBitOfInt(_nNotify, 2)) {
            buff.append(',').append("SMS");
        }
        if (CMyBitsValue.getBitOfInt(_nNotify, 0)) {
            buff.append(',').append("Message");
        }
        if (buff.length() > 0) {
            return buff.substring(1);
        }
        return "Message";
    }

    public String getName() {
        return this.getPropertyAsString("BName");
    }

    public String getOperationMark() {
        return this.getPropertyAsString("OperationMark");
    }

    public boolean isOperationMarkEnable() {
        return this.getPropertyAsBoolean("OperationMarkEnable", false);
    }
}

