/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.xml;

import com.trs.dev4.jdk16.xml.Node;
import com.trs.dev4.jdk16.xml.XMLGenerator;
import com.trs.dev4.jdk16.xml.node.CommonNode;
import java.util.Stack;
import org.apache.log4j.Logger;

public class XMLBuilder {
    protected final Logger LOG = Logger.getLogger(this.getClass());
    private CommonNode currentNode;
    private CommonNode parentNode;
    private CommonNode root;
    private XMLGenerator xg;
    private Stack<Node> traces = new Stack();

    public XMLBuilder(String rootName) {
        this(rootName, "UTF-8");
    }

    public XMLBuilder(String rootName, String encoding) {
        this.currentNode = this.root = new CommonNode(rootName);
        this.xg = new XMLGenerator(encoding);
        this.xg.setRootNode(this.root);
    }

    public XMLBuilder appendChildNode(String nodeName) {
        CommonNode node = new CommonNode(nodeName);
        this.currentNode.addChildNode(node);
        this.traces.push(this.currentNode);
        this.parentNode = this.currentNode;
        this.currentNode = node;
        return this;
    }

    public XMLBuilder appendSiblingNode(String nodeName) {
        CommonNode node = new CommonNode(nodeName);
        this.parentNode.addChildNode(node);
        this.currentNode = node;
        return this;
    }

    public XMLBuilder appendParentNode(String nodeName) {
        this.backToParent();
        return this.appendSiblingNode(nodeName);
    }

    public XMLBuilder backToParent() {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"--------------------");
            this.LOG.debug((Object)("root:" + this.root));
            this.LOG.debug((Object)("traces:" + this.traces));
            this.LOG.debug((Object)("before. currentNode:" + this.currentNode));
            this.LOG.debug((Object)("before. parentNode:" + this.parentNode));
        }
        if (this.isCurrentRootNode()) {
            throw new RuntimeException("\u5df2\u7ecf\u5230\u8fbe\u4e86\u6839\u8282\u70b9");
        }
        if (this.parentNode == this.root) {
            this.currentNode = this.root;
            this.parentNode = null;
        } else {
            this.traces.pop();
            CommonNode grandParent = (CommonNode)this.traces.peek();
            this.currentNode = this.parentNode;
            this.parentNode = grandParent;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("after. currentNode:" + this.currentNode));
            this.LOG.debug((Object)("after. parentNode:" + this.parentNode));
        }
        return this;
    }

    public XMLBuilder backToRoot() {
        while (!this.isCurrentRootNode()) {
            this.backToParent();
        }
        return this;
    }

    public boolean isCurrentRootNode() {
        return this.currentNode == this.root;
    }

    public XMLBuilder addAttribute(String name, int value) {
        this.currentNode.addAttribute(name, value);
        return this;
    }

    public XMLBuilder addAttribute(String name, String value) {
        this.currentNode.addAttribute(name, value);
        return this;
    }

    public XMLBuilder addAttribute(String name, Object value) {
        this.currentNode.addAttribute(name, value);
        return this;
    }

    public XMLBuilder setNodeValue(String nodeValue) {
        this.currentNode.setNodeValue(nodeValue);
        return this;
    }

    public XMLBuilder setNodeValue(String nodeValue, boolean CDATANeeded) {
        this.currentNode.setNodeValue(nodeValue);
        this.currentNode.setCDATANeeded(CDATANeeded);
        return this;
    }

    public XMLBuilder setNodeValue(int nodeValue) {
        this.currentNode.setNodeValue(nodeValue);
        return this;
    }

    public XMLBuilder setNodeValue(boolean nodeValue) {
        this.currentNode.setNodeValue(String.valueOf(nodeValue));
        this.currentNode.setCDATANeeded(false);
        return this;
    }

    public String toXML() {
        return this.xg.generateXML();
    }
}

