/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.actionlog.impl;

import com.trs.dev4.jdk16.actionlog.IActionlog;
import com.trs.dev4.jdk16.actionlog.LogEnums;
import com.trs.dev4.jdk16.model.BaseEntity;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="`ACTIONLOGS`")
@GenericGenerator(name="idStrategy", strategy="native", parameters={@Parameter(name="sequence", value="SEQ_ACTIONLOG")})
public class Actionlog
extends BaseEntity
implements IActionlog {
    private static final long serialVersionUID = -1435378662692038536L;
    @Column(name="`LOGLEVEL`")
    @Enumerated(value=EnumType.STRING)
    private LogEnums.Level logLevel;
    @Column(name="`OBJID`")
    private int objId;
    @Column(name="`OBJTYPE`")
    private String objType;
    @Column(name="`REMOTEADDR`")
    private String remoteAddr;
    @Column(name="`OPERDESC`")
    private String operDesc;
    @Column(name="`OPERTYPE`")
    private String operType;
    @Column(name="`OPERUSERID`")
    private int operUserId;
    @Column(name="`OPERUSERNAME`")
    private String operUserName;
    @Column(name="`RESULT`")
    @Enumerated(value=EnumType.STRING)
    private LogEnums.Result result;
    @Column(name="`SPENTTIME`")
    private long spentTime;
    @Column(name="`STARTTIME`")
    private long startTime;
    @Column(name="ISSCORED")
    private boolean isScored = false;
    @Column(name="SYSFLAG")
    private String sysFlag;
    @Column(name="`ERRORMSG`", length=2000)
    private String errorMsg;
    @Column(name="`OPERTITLE`")
    private String operTitle;
    @Column(name="`PROXYIPS`", length=512)
    private String proxyIPs;
    @Column(name="`USERAGENT`")
    private String userAgent;
    @Column(name="`CALLERSTACKBRIEF`", length=1024)
    private String callerStackBrief;
    @Column(name="EXTENDFIELD1", length=2000)
    private String extendField1;
    @Column(name="EXTENDFIELD2")
    private String extendField2;
    @Column(name="EXTENDFIELD3")
    private String extendField3;
    @Column(name="ROOTLOGID")
    private int rootLogId;

    @Override
    public LogEnums.Level getLogLevel() {
        return this.logLevel;
    }

    @Override
    public int getObjId() {
        return this.objId;
    }

    @Override
    public String getObjType() {
        return this.objType;
    }

    @Override
    public Object[] getOperArgs() {
        if (this.extendField1 == null) {
            return new Object[0];
        }
        if (this.extendField2 == null) {
            return new Object[]{this.extendField1};
        }
        if (this.extendField3 == null) {
            return new Object[]{this.extendField1, this.extendField2};
        }
        return new Object[]{this.extendField1, this.extendField2, this.extendField3};
    }

    @Override
    public String getOperDesc() {
        return this.operDesc;
    }

    @Override
    public String getOperTitle() {
        return this.operTitle;
    }

    @Override
    public String getOperType() {
        return this.operType;
    }

    @Override
    public int getOperUserId() {
        return this.operUserId;
    }

    @Override
    public String getOperUserName() {
        return this.operUserName;
    }

    @Override
    public LogEnums.Result getResult() {
        return this.result;
    }

    @Override
    public long getSpentTime() {
        return this.spentTime;
    }

    @Override
    public Date getStartTime() {
        return new Date(this.startTime);
    }

    @Override
    public void setLogLevel(LogEnums.Level level) {
        this.logLevel = level;
    }

    @Override
    public void setObjId(int i) {
        this.objId = i;
    }

    @Override
    public void setObjType(String s) {
        this.objType = s;
    }

    @Override
    public void setOperArgs(Object ... obj) {
    }

    @Override
    public void setOperDesc(String s) {
        this.operDesc = s;
    }

    @Override
    public void setOperTitle(String s) {
        this.operTitle = s;
    }

    @Override
    public void setOperType(String s) {
        this.operType = s;
    }

    @Override
    public void setOperUserId(int i) {
        this.operUserId = i;
    }

    @Override
    public void setOperUserName(String s) {
        this.operUserName = s;
    }

    @Override
    public void setResult(LogEnums.Result result) {
        this.result = result;
    }

    @Override
    public void setSpentTime(long l) {
        this.spentTime = l;
    }

    @Override
    public void setStartTime(long l) {
        this.startTime = l;
    }

    public String getExtendField1() {
        return this.extendField1;
    }

    public void setExtendField1(String extendField1) {
        this.extendField1 = extendField1;
    }

    public String getExtendField2() {
        return this.extendField2;
    }

    public void setExtendField2(String extendField2) {
        this.extendField2 = extendField2;
    }

    public String getExtendField3() {
        return this.extendField3;
    }

    public void setExtendField3(String extendField3) {
        this.extendField3 = extendField3;
    }

    public String getSysFlag() {
        return this.sysFlag;
    }

    public void setSysFlag(String sysFlag) {
        this.sysFlag = sysFlag;
    }

    public boolean isScored() {
        return this.isScored;
    }

    public void setScored(boolean isScored) {
        this.isScored = isScored;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMessage) {
        this.errorMsg = errorMessage;
    }

    public void setRootLogId(int rootLogId) {
        this.rootLogId = rootLogId;
    }

    public int getRootLogId() {
        return this.rootLogId;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Actionlog [errorMsg=");
        builder.append(this.errorMsg).append(",");
        builder.append(super.toString());
        builder.append(", extendField1=");
        builder.append(this.extendField1);
        builder.append(", extendField2=");
        builder.append(this.extendField2);
        builder.append(", extendField3=");
        builder.append(this.extendField3);
        builder.append(", isScored=");
        builder.append(this.isScored);
        builder.append(", logLevel=");
        builder.append((Object)this.logLevel);
        builder.append(", objId=");
        builder.append(this.objId);
        builder.append(", objType=");
        builder.append(this.objType);
        builder.append(", operDesc=");
        builder.append(this.operDesc);
        builder.append(", operTitle=");
        builder.append(this.operTitle);
        builder.append(", operType=");
        builder.append(this.operType);
        builder.append(", operUserId=");
        builder.append(this.operUserId);
        builder.append(", operUserName=");
        builder.append(this.operUserName);
        builder.append(", result=");
        builder.append((Object)this.result);
        builder.append(", spentTime=");
        builder.append(this.spentTime);
        builder.append(", startTime=");
        builder.append(this.startTime);
        builder.append(", sysFlag=");
        builder.append(this.sysFlag);
        builder.append(", proxyIPs=");
        builder.append(this.proxyIPs);
        builder.append(", userAgent=");
        builder.append(this.userAgent);
        builder.append(", callerStackBrief=");
        builder.append(this.callerStackBrief);
        builder.append(", rootLogId=");
        builder.append(this.rootLogId);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getProxyIPs() {
        return this.proxyIPs == null ? "" : this.proxyIPs;
    }

    public void setProxyIPs(String proxyIPs) {
        this.proxyIPs = proxyIPs;
    }

    public String getCallerStackBrief() {
        return this.callerStackBrief;
    }

    public void setCallerStackBrief(String mainCallerStack) {
        this.callerStackBrief = mainCallerStack;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
}

