/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.session.impl;

import com.trs.infra.session.Session;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

class HttpSessionFacade
implements HttpSession {
    private final Session session;

    public HttpSessionFacade(Session session) {
        this.session = session;
    }

    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        final Iterator itr = this.session.getAttributeNames();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return itr.hasNext();
            }

            public Object nextElement() {
                return itr.next();
            }
        };
    }

    public long getCreationTime() {
        return this.session.getCreateTime();
    }

    public String getId() {
        return this.session.getSessionID();
    }

    public long getLastAccessedTime() {
        return this.session.getThisAccessTime();
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public void setMaxInactiveInterval(int interval) {
        if (interval <= 0) {
            return;
        }
        this.session.setMaxInactiveInterval(interval);
    }

    public void invalidate() {
        this.session.invalidate();
    }

    public ServletContext getServletContext() {
        return this.session.getSessionContext().getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getValue(String name) {
        return this.session.getAttribute(name);
    }

    public String[] getValueNames() {
        return this.session.getAttributeNamesArray();
    }

    public boolean isNew() {
        return this.session.isNew();
    }

    public void putValue(String name, Object value) {
        this.session.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.session.setAttribute(name, null);
    }

    public void removeValue(String name) {
        this.session.setAttribute(name, null);
    }

    public void setAttribute(String name, Object value) {
        this.session.setAttribute(name, value);
    }
}

