/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.io;

import com.trs.infra.cluster.StreamWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class ByteArrayStreamWriter
extends OutputStream
implements StreamWriter {
    byte[] buffer;
    int limit1 = 0;
    int limit2;
    int offset;

    public ByteArrayStreamWriter(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public ByteArrayStreamWriter(byte[] buf, int off) {
        this(buf, off, buf.length);
    }

    public ByteArrayStreamWriter(byte[] buf, int off, int len) {
        this.buffer = buf;
        this.offset = off;
        this.limit1 = off;
        this.limit2 = Math.min(off + len, buf.length);
    }

    public final long size() {
        return this.offset - this.limit1;
    }

    public void flush() throws IOException {
    }

    public final void write(int b) {
        this.buffer[this.offset++] = (byte)b;
    }

    public final void write(byte[] buf) {
        this.write(buf, 0, buf.length);
    }

    public final void write(byte[] buf, int off, int len) {
        System.arraycopy(buf, 0, this.buffer, this.offset, len);
        this.offset += len;
    }

    public final void write_boolean(boolean value) {
        this.buffer[this.offset++] = (byte)(value ? 1 : 0);
    }

    public final void write_byte(byte value) {
        this.buffer[this.offset++] = value;
    }

    public final void write_char(char value) {
        this.buffer[this.offset++] = (byte)(value >>> 8);
        this.buffer[this.offset++] = (byte)(value >>> 0);
    }

    public final void write_short(short value) {
        this.buffer[this.offset++] = (byte)(value >>> 8);
        this.buffer[this.offset++] = (byte)(value >>> 0);
    }

    public final void write_int(int value) {
        this.buffer[this.offset++] = (byte)(value >>> 24);
        this.buffer[this.offset++] = (byte)(value >>> 16);
        this.buffer[this.offset++] = (byte)(value >>> 8);
        this.buffer[this.offset++] = (byte)(value >>> 0);
    }

    public final void write_long(long value) {
        this.buffer[this.offset++] = (byte)(value >>> 56);
        this.buffer[this.offset++] = (byte)(value >>> 48);
        this.buffer[this.offset++] = (byte)(value >>> 40);
        this.buffer[this.offset++] = (byte)(value >>> 32);
        this.buffer[this.offset++] = (byte)(value >>> 24);
        this.buffer[this.offset++] = (byte)(value >>> 16);
        this.buffer[this.offset++] = (byte)(value >>> 8);
        this.buffer[this.offset++] = (byte)(value >>> 0);
    }

    public final void write_float(float value) {
        this.write_int(Float.floatToIntBits(value));
    }

    public final void write_double(double value) {
        this.write_long(Double.doubleToLongBits(value));
    }

    public final void write_string(String value) {
        if (value == null) {
            this.write_int(-1);
            return;
        }
        if (value.length() <= 0) {
            this.write_int(0);
            return;
        }
        byte[] stringBuffer = null;
        try {
            stringBuffer = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            stringBuffer = value.getBytes();
        }
        this.write_byte_array(stringBuffer);
    }

    public final void write_object(Serializable value) throws IOException {
        if (value == null) {
            this.write_byte((byte)0);
            return;
        }
        this.write_byte((byte)85);
        ObjectOutputStream oos = new ObjectOutputStream(this);
        oos.writeUnshared(value);
        oos.flush();
        this.write_byte((byte)85);
    }

    public final void write_byte_array(byte[] buf) {
        if (buf == null) {
            this.write_int(-1);
            return;
        }
        int length = buf.length;
        if (length == 0) {
            this.write_int(0);
            return;
        }
        this.write_int(length);
        this.write(buf, 0, length);
    }
}

