/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FilterTransport
implements SOAPTransport {
    private EnvelopeEditor editor;
    private SOAPTransport transport;

    public FilterTransport(EnvelopeEditor editor, SOAPTransport transport) {
        this.editor = editor;
        this.transport = transport;
    }

    public void send(URL sendTo, String action, Hashtable headers, Envelope env, SOAPMappingRegistry smr, SOAPContext ctx) throws SOAPException {
        try {
            StringWriter sout = new StringWriter();
            env.marshall(sout, smr, ctx);
            StringReader sin = new StringReader(sout.getBuffer().toString());
            if (this.editor != null) {
                sout = new StringWriter();
                this.editor.editOutgoing(sin, sout);
                sout.flush();
                sin = new StringReader(sout.getBuffer().toString());
            }
            Element docElem = XMLParserUtils.parse(sin).getDocumentElement();
            Envelope env2 = Envelope.unmarshall(docElem);
            this.transport.send(sendTo, action, headers, env2, smr, ctx);
        }
        catch (IllegalArgumentException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e.getMessage(), e);
        }
    }

    public BufferedReader receive() {
        try {
            BufferedReader in = this.transport.receive();
            if (this.editor == null || in == null) {
                return in;
            }
            StringWriter sout = new StringWriter();
            this.editor.editIncoming(in, sout);
            sout.flush();
            StringReader sin = new StringReader(sout.getBuffer().toString());
            return new BufferedReader(sin);
        }
        catch (SOAPException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Hashtable getHeaders() {
        return this.transport.getHeaders();
    }

    public SOAPContext getResponseSOAPContext() {
        return this.transport.getResponseSOAPContext();
    }
}

