/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app.classloader;

import COM.ibm.db2.app.classloader.ClassLoaderTemplate;
import COM.ibm.db2.app.classloader.ClassLoaderTracer;
import COM.ibm.db2.app.classloader.ClassProvider;
import COM.ibm.db2.app.classloader.DynamicClassLoader;
import COM.ibm.db2.app.classloader.JarDirClassProvider;
import COM.ibm.db2.app.classloader.JarFileClassProvider;
import COM.ibm.db2.app.classloader.JarFilenameFilter;
import COM.ibm.db2.app.util.InvalidationException;
import COM.ibm.db2.app.util.Validatable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class PowerClassLoader
extends ClassLoaderTemplate
implements Validatable {
    private static DynamicClassLoader loader;
    ClassLoaderTracer tracer = ClassLoaderTracer.instance();
    private Object updateSynch = new Object();

    public PowerClassLoader() {
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader::PowerClassLoader(). Empty constructor.");
        }
    }

    protected Class loadNonSystemClass(String string) throws ClassNotFoundException {
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader::loadNonSystemClass().");
        }
        string = string.replace('/', '.');
        Class<?> clazz = loader.loadClass(string);
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader::loadNonSystemClass(). Returning cls = " + clazz);
        }
        return clazz;
    }

    protected InputStream getNonSystemResourceAsStream(String string) {
        return loader.getResourceAsStream(string);
    }

    protected URL getNonSystemResource(String string) {
        return loader.getResource(string);
    }

    public synchronized void reload() {
        String string = this.getClassPath();
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader::reload()");
        }
        this.reload(string);
    }

    public synchronized void reload(String string) {
        Object object = this.updateSynch;
        synchronized (object) {
            if (this.tracer.isTracing) {
                this.tracer.trace("PowerClassLoader::reload(classpath). classpath = " + string);
            }
            loader = new DynamicClassLoader();
            this.appendPathToClassPath(string);
            if (this.tracer.isTracing) {
                this.tracer.trace("*** " + this.getClass().getName() + " was reloaded ***", 1);
                this.tracer.trace("new reloadable classpath: " + this.getClassPath(), 2);
            }
            return;
        }
    }

    protected void appendPathToClassPath(String string) {
        Object object = this.updateSynch;
        synchronized (object) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                ClassProvider classProvider = this.getClassProvider(string2);
                if (classProvider != null) continue;
                classProvider = this.createClassProvider(string2);
                if (classProvider != null) {
                    this.addClassProvider(classProvider);
                    continue;
                }
                if (!this.tracer.isTracing) continue;
                this.tracer.trace("failed to add path [" + string2 + "] to the classpath", 1);
            }
            return;
        }
    }

    public String getClassPath() {
        return loader.getClassPath();
    }

    public void validate() throws InvalidationException {
        loader.validate();
    }

    public boolean isValid() {
        try {
            if (this.tracer.isTracing) {
                this.tracer.trace("PowerClassLoader::isValid()");
            }
            this.validate();
            return true;
        }
        catch (InvalidationException invalidationException) {
            return false;
        }
    }

    public String getAbsoluteResourcePath(String string) {
        return loader.getAbsoluteResourcePath(string);
    }

    public void finalize() {
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader::finalize()");
        }
    }

    private String convertResourceName(String string) {
        string.replace('\\', '/');
        if (!string.startsWith("/")) {
            string = String.valueOf(string) + "/" + string;
        }
        return string;
    }

    private String formatPath(String string) {
        String string2 = string;
        string2 = string2.trim();
        while (string2.endsWith("/") || string2.endsWith("\\")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    protected ClassProvider getClassProvider(String string) {
        ClassProvider classProvider;
        string = this.formatPath(string);
        String string2 = null;
        Enumeration enumeration = loader.getClassProviders();
        if (enumeration.hasMoreElements() && (string2 = (classProvider = (ClassProvider)enumeration.nextElement()).getClassPath()).indexOf(string) != -1) {
            return classProvider;
        }
        return null;
    }

    protected ClassProvider createClassProvider(String string) {
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                return new JarDirClassProvider(file);
            }
            String string2 = file.getName();
            if (JarFilenameFilter.instance().accept(string2)) {
                return new JarFileClassProvider(file);
            }
        }
        return null;
    }

    private void addClassProvider(ClassProvider classProvider) {
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader:addClassProvider. add ClassProvider for path: " + classProvider.getClassPath());
        }
        loader.addClassProvider(classProvider);
    }
}

