/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.http;

import com.trs.dev4.jdk16.http.Response;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.log4j.Logger;

public class PureClient {
    static final int CODE_EXCEPTION = 600;
    private static final Logger LOG = Logger.getLogger(PureClient.class);
    private static final int CONN_TIMEOUT = 20000;
    private static final int LINGER_TIME = 10000;
    private static HttpClient client;
    private static HttpConnectionManager httpConnMgr;

    static {
        PureClient.init();
    }

    public static Response get(String url) {
        return PureClient.get(url, null);
    }

    public static Response get(String url, Map<String, String> extraHeaders) {
        return PureClient.getHttpResponse(url, extraHeaders, null);
    }

    public static Response post(String url, String formCharset, Map<String, String> extraHeaders, Map<String, String> postParams) {
        PostMethod method = new PostMethod(url);
        formCharset = StringHelper.isEmpty(formCharset) ? "UTF-8" : formCharset;
        method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + formCharset);
        NameValuePair[] parametersBody = null;
        if (postParams != null) {
            int size = postParams.size();
            parametersBody = new NameValuePair[size];
            int i = 0;
            for (String name : postParams.keySet()) {
                NameValuePair valuePair;
                String value = postParams.get(name);
                parametersBody[i] = valuePair = new NameValuePair();
                parametersBody[i].setName(name);
                parametersBody[i].setValue(value);
                ++i;
            }
            method.setRequestBody(parametersBody);
        }
        HttpState state = null;
        return PureClient.getResponseInternal(url, (HttpMethod)method, extraHeaders, state);
    }

    @Deprecated
    static Response getHttpResponse(String url, Map headers, HttpState state) {
        return PureClient.getHttpResponse(url, headers, state, true);
    }

    @Deprecated
    static Response getHttpResponse(String url, Map headers, HttpState state, boolean followRedirect) {
        GetMethod method = new GetMethod(url);
        method.setFollowRedirects(followRedirect);
        return PureClient.getResponseInternal(url, (HttpMethod)method, headers, state);
    }

    @Deprecated
    static Response headHttpResponse(String url, Map headers, HttpState state, NameValuePair[] parametersBody) {
        return PureClient.headHttpResponse(url, headers, state, parametersBody, true);
    }

    @Deprecated
    static Response headHttpResponse(String url, Map headers, HttpState state, NameValuePair[] parametersBody, boolean followRedirect) {
        HeadMethod method = new HeadMethod(url);
        method.setFollowRedirects(followRedirect);
        return PureClient.getResponseInternal(url, (HttpMethod)method, headers, state);
    }

    static Response getResponseInternal(String url, HttpMethod method, Map headers, HttpState state) {
        Response res;
        block12: {
            HttpClient httpClient = PureClient.buildHttpClient();
            HttpMethodParams params = method.getParams();
            if (params != null) {
                params.setCookiePolicy("compatibility");
            }
            method.setRequestHeader("Connection", "Close");
            res = new Response(url);
            if (headers != null) {
                for (Map.Entry e : headers.entrySet()) {
                    method.setRequestHeader((String)e.getKey(), (String)e.getValue());
                }
            }
            if (state != null) {
                httpClient.setState(state);
            }
            try {
                try {
                    res.setActualPath(method.getPath());
                    int respCode = httpClient.executeMethod(method);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("[Request]" + method.getName() + " " + method.getURI() + " [Response]" + method.getStatusLine()));
                    }
                    res.setStatusCode(respCode);
                    res.setStatusText(method.getStatusText());
                    Header[] respHeaders = method.getResponseHeaders();
                    int i = 0;
                    while (i < respHeaders.length) {
                        res.addResponseHeader(respHeaders[i].getName(), respHeaders[i].getValue());
                        ++i;
                    }
                    if (res.statusCodeIsFine()) {
                        res.setResponseBody(method.getResponseBody());
                        break block12;
                    }
                    LOG.warn((Object)("respCode=" + respCode + "! url=" + url));
                }
                catch (Throwable e) {
                    res.setFail(true);
                    res.setError(e);
                    res.setStatusCode(600);
                    res.setStatusText(e.getMessage());
                    method.releaseConnection();
                }
            }
            finally {
                method.releaseConnection();
            }
        }
        return res;
    }

    static Response getResponse(String url, HttpMethod method, Map headers, HttpState state) {
        Response res;
        block10: {
            HttpMethodParams params;
            res = new Response(url);
            if (headers != null) {
                for (Map.Entry e : headers.entrySet()) {
                    method.setRequestHeader((String)e.getKey(), (String)e.getValue());
                }
            }
            if ((params = method.getParams()) != null) {
                params.setCookiePolicy("compatibility");
            }
            client.setState(state == null ? new HttpState() : state);
            try {
                try {
                    int respCode = client.executeMethod(method);
                    res.setStatusCode(respCode);
                    res.setStatusText(method.getStatusText());
                    res.setActualPath(method.getPath());
                    Header[] respHeaders = method.getResponseHeaders();
                    int i = 0;
                    while (i < respHeaders.length) {
                        res.addResponseHeader(respHeaders[i].getName(), respHeaders[i].getValue());
                        ++i;
                    }
                    if (res.statusCodeIsFine()) {
                        res.setResponseBody(method.getResponseBody());
                        break block10;
                    }
                    LOG.warn((Object)("respCode=" + respCode + "! url=" + url));
                }
                catch (Throwable e) {
                    LOG.error((Object)("httpClient.executeMethod failed! url=" + url), e);
                    res.setFail(true);
                    res.setError(e);
                    method.releaseConnection();
                }
            }
            finally {
                method.releaseConnection();
            }
        }
        return res;
    }

    private static void init() {
        httpConnMgr = new MultiThreadedHttpConnectionManager();
        if (httpConnMgr != null) {
            HttpConnectionManagerParams mgrParams = PureClient.buildManagerParams();
            httpConnMgr.setParams(mgrParams);
        }
        client = new HttpClient(httpConnMgr);
    }

    static HttpConnectionManagerParams buildManagerParams() {
        HttpConnectionManagerParams mgrParams = new HttpConnectionManagerParams();
        mgrParams.setSoTimeout(20000);
        mgrParams.setTcpNoDelay(true);
        mgrParams.setConnectionTimeout(20000);
        mgrParams.setLinger(10000);
        mgrParams.setDefaultMaxConnectionsPerHost(10);
        mgrParams.setMaxTotalConnections(15);
        return mgrParams;
    }

    private static HttpClient buildHttpClient() {
        return client;
    }
}

