/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.io;

import java.io.UnsupportedEncodingException;

public final class StreamDataUtil {
    public final boolean read_boolean(byte[] buffer, int offset) {
        return buffer[offset] != 0;
    }

    public static final char read_char(byte[] buffer, int offset) {
        byte b1 = buffer[offset++];
        int b2 = buffer[offset++] & 0xFF;
        return (char)((b1 << 8) + (b2 << 0));
    }

    public static final short read_short(byte[] buffer, int offset) {
        byte b1 = buffer[offset++];
        int b2 = buffer[offset++] & 0xFF;
        return (short)((b1 << 8) + (b2 << 0));
    }

    public static final int read_int(byte[] buffer, int offset) {
        byte b1 = buffer[offset++];
        int b2 = buffer[offset++] & 0xFF;
        int b3 = buffer[offset++] & 0xFF;
        int b4 = buffer[offset++] & 0xFF;
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + (b4 << 0);
    }

    public static final long read_long(byte[] buffer, int offset) {
        return ((long)buffer[offset++] << 56) + ((long)(buffer[offset++] & 0xFF) << 48) + ((long)(buffer[offset++] & 0xFF) << 40) + ((long)(buffer[offset++] & 0xFF) << 32) + ((long)(buffer[offset++] & 0xFF) << 24) + (long)((buffer[offset++] & 0xFF) << 16) + (long)((buffer[offset++] & 0xFF) << 8) + (long)((buffer[offset++] & 0xFF) << 0);
    }

    public static final float read_float(byte[] buffer, int offset) {
        return Float.intBitsToFloat(StreamDataUtil.read_int(buffer, offset));
    }

    public static final double read_double(byte[] buffer, int offset) {
        return Double.longBitsToDouble(StreamDataUtil.read_long(buffer, offset));
    }

    public static final String read_string(byte[] buffer, int offset) {
        int length = StreamDataUtil.read_int(buffer, offset);
        if (length <= 0) {
            return null;
        }
        String s = null;
        try {
            s = new String(buffer, offset + 4, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            s = new String(buffer, offset + 4, length);
        }
        return s;
    }

    public static final byte[] read_byte_array(byte[] buffer, int offset) {
        int length = StreamDataUtil.read_int(buffer, offset);
        byte[] value = new byte[length];
        System.arraycopy(buffer, offset + 4, value, 0, length);
        return value;
    }

    public static final void write_boolean(byte[] buffer, int offset, boolean value) {
        buffer[offset] = (byte)(value ? 1 : 0);
    }

    public static final void write_char(byte[] buffer, int offset, char value) {
        buffer[offset++] = (byte)(value >>> 8);
        buffer[offset++] = (byte)(value >>> 0);
    }

    public static final void write_short(byte[] buffer, int offset, short value) {
        buffer[offset++] = (byte)(value >>> 8);
        buffer[offset++] = (byte)(value >>> 0);
    }

    public static final void write_int(byte[] buffer, int offset, int value) {
        buffer[offset++] = (byte)(value >>> 24);
        buffer[offset++] = (byte)(value >>> 16);
        buffer[offset++] = (byte)(value >>> 8);
        buffer[offset++] = (byte)(value >>> 0);
    }

    public static final void write_long(byte[] buffer, int offset, long value) {
        buffer[offset++] = (byte)(value >>> 56);
        buffer[offset++] = (byte)(value >>> 48);
        buffer[offset++] = (byte)(value >>> 40);
        buffer[offset++] = (byte)(value >>> 32);
        buffer[offset++] = (byte)(value >>> 24);
        buffer[offset++] = (byte)(value >>> 16);
        buffer[offset++] = (byte)(value >>> 8);
        buffer[offset++] = (byte)(value >>> 0);
    }

    public static final void write_float(byte[] buffer, int offset, float value) {
        StreamDataUtil.write_int(buffer, offset, Float.floatToIntBits(value));
    }

    public static final void write_double(byte[] buffer, int offset, double value) {
        StreamDataUtil.write_long(buffer, offset, Double.doubleToLongBits(value));
    }

    public static final void write_string(byte[] buffer, int offset, String value) {
        if (value == null || value.length() <= 0) {
            StreamDataUtil.write_int(buffer, offset, 0);
            return;
        }
        byte[] stringBuffer = null;
        try {
            stringBuffer = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            stringBuffer = value.getBytes();
        }
        StreamDataUtil.write_byte_array(buffer, offset, stringBuffer);
    }

    public static final void write_byte_array(byte[] buffer, int offset, byte[] value) {
        int length = value.length;
        StreamDataUtil.write_int(buffer, offset, length);
        System.arraycopy(value, 0, buffer, offset + 4, length);
    }
}

