/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import org.xmlmiddleware.db.CPConnection;
import org.xmlmiddleware.db.CPConnectionEvent;
import org.xmlmiddleware.db.CPConnectionEventListener;
import org.xmlmiddleware.db.StatementPool;
import org.xmlmiddleware.utils.Pool;
import org.xmlmiddleware.utils.XMLMiddlewareException;

public abstract class ConnectionPool
extends Pool
implements CPConnectionEventListener {
    Hashtable m_statementPools = new Hashtable();

    public Object checkOut(Object object) throws XMLMiddlewareException {
        CPConnection cPConnection;
        Connection connection = (Connection)super.checkOut(object);
        StatementPool statementPool = (StatementPool)this.m_statementPools.get(connection);
        try {
            cPConnection = new CPConnection(connection, statementPool);
        }
        catch (SQLException sQLException) {
            throw new XMLMiddlewareException(sQLException);
        }
        cPConnection.addConnectionEventListener(this);
        return cPConnection;
    }

    public void checkIn(Object object) throws XMLMiddlewareException {
        if (!(object instanceof CPConnection)) {
            throw new XMLMiddlewareException("ConnectionPool requires a CPConnection object.");
        }
        CPConnection cPConnection = (CPConnection)object;
        Connection connection = cPConnection.getConnection();
        StatementPool statementPool = cPConnection.getStatementPool();
        cPConnection.invalidate();
        super.checkIn(connection);
        this.m_statementPools.put(connection, statementPool);
        cPConnection.removeConnectionEventListener(this);
    }

    public void connectionClosed(CPConnectionEvent cPConnectionEvent) {
        try {
            CPConnection cPConnection = (CPConnection)cPConnectionEvent.getSource();
            this.checkIn(cPConnection);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void connectionErrorOccurred(CPConnectionEvent cPConnectionEvent) {
        try {
            CPConnection cPConnection = (CPConnection)cPConnectionEvent.getSource();
            this.remove(cPConnection);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void clear() {
        super.clear();
    }

    protected void remove(Object object) throws XMLMiddlewareException {
        if (!(object instanceof CPConnection)) {
            throw new XMLMiddlewareException("Pool requires a CPConnection object.");
        }
        CPConnection cPConnection = (CPConnection)object;
        Connection connection = cPConnection.getConnection();
        StatementPool statementPool = cPConnection.getStatementPool();
        cPConnection.invalidate();
        super.remove(connection);
        this.m_statementPools.remove(connection);
        cPConnection.removeConnectionEventListener(this);
    }
}

