/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.Table;

public class Row {
    private Hashtable m_columnValues = new Hashtable();
    private static final String EMPTYSTRING = "";

    public void setColumnValue(Column column, Object object) {
        if (object == null) {
            this.m_columnValues.put(column, new Null());
            return;
        }
        this.m_columnValues.put(column, object);
    }

    public Object getColumnValue(Column column) {
        Object v = this.m_columnValues.get(column);
        if (v == null || v instanceof Null) {
            return null;
        }
        return v;
    }

    public void clearColumnValue(Column column) {
        this.m_columnValues.remove(column);
    }

    public void clear() {
        this.m_columnValues.clear();
    }

    public void setColumnValues(Column[] columnArray, Object[] objectArray) {
        int n = 0;
        while (n < columnArray.length) {
            this.setColumnValue(columnArray[n], objectArray[n]);
            ++n;
        }
    }

    public void setColumnValues(ResultSet resultSet, Table table, boolean bl) throws SQLException {
        Column[] columnArray = table.getResultSetColumns();
        int n = 0;
        while (n < columnArray.length) {
            Object object = resultSet.getObject(columnArray[n].getResultSetIndex());
            if (resultSet.wasNull()) {
                object = bl ? EMPTYSTRING : null;
            }
            this.setColumnValue(columnArray[n], object);
            ++n;
        }
    }

    public Object[] getColumnValues(Column[] columnArray) {
        Object[] objectArray = new Object[columnArray.length];
        int n = 0;
        while (n < columnArray.length) {
            objectArray[n] = this.getColumnValue(columnArray[n]);
            ++n;
        }
        return objectArray;
    }

    public Vector getColumnVectorFor(Table table) {
        Vector<Column> vector = new Vector<Column>();
        Enumeration enumeration = table.getColumns();
        while (enumeration.hasMoreElements()) {
            Column column = (Column)enumeration.nextElement();
            if (!this.haveColumn(column)) continue;
            vector.addElement(column);
        }
        return vector;
    }

    public Column[] getColumnsFor(Table table) {
        Vector vector = this.getColumnVectorFor(table);
        Object[] objectArray = new Column[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    boolean haveColumn(Column column) {
        return this.m_columnValues.get(column) != null;
    }

    boolean haveColumns(Column[] columnArray) {
        int n = 0;
        while (n < columnArray.length) {
            if (!this.haveColumn(columnArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    class Null {
        Null() {
            Row.this = Row.this;
        }
    }
}

