/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmlutils;

import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMNormalizer {
    private static String AMPENTITY = "&amp;";
    private static String LTENTITY = "&lt;";
    private static String QUOTENTITY = "&quot;";
    private static final char QUOT = '\"';
    private static final char APOS = '\'';
    private static final char LT = '<';
    private static final char GT = '>';
    private static final char AMP = '&';
    private static final char SPACE = ' ';
    private static final char EQUALS = '=';
    private static final char SLASH = '/';

    public static Node getFirstChild(Node node) {
        return DOMNormalizer.normalizeNode(node.getFirstChild());
    }

    public static Node getNextSibling(Node node) {
        return DOMNormalizer.normalizeNode(node.getNextSibling());
    }

    public static Node normalizeNode(Node node) {
        Node node2 = node;
        while (node2 != null) {
            short s = node2.getNodeType();
            switch (s) {
                case 1: {
                    return node2;
                }
                case 3: 
                case 4: {
                    node2 = DOMNormalizer.normalizeText(node2);
                    return node2;
                }
                case 7: 
                case 8: {
                    node2 = node2.getNextSibling();
                    break;
                }
                case 5: {
                    node2 = DOMNormalizer.expandEntityRef(node2);
                    break;
                }
                default: {
                    node2 = null;
                    break;
                }
            }
        }
        return node2;
    }

    public static Node normalizeText(Node node) {
        short s = node.getNodeType();
        if (s != 3 && s != 4) {
            return node;
        }
        Node node2 = node.getParentNode();
        if (node2 == null) {
            return node;
        }
        Node node3 = node.getNextSibling();
        while (node3 != null) {
            switch (node3.getNodeType()) {
                case 3: 
                case 4: {
                    ((CharacterData)node).appendData(node3.getNodeValue());
                    Node node4 = node3.getNextSibling();
                    node2.removeChild(node3);
                    node3 = node4;
                    break;
                }
                case 5: {
                    node3 = DOMNormalizer.expandEntityRef(node3);
                    break;
                }
                case 7: 
                case 8: {
                    node3 = node3.getNextSibling();
                    break;
                }
                default: {
                    node3 = null;
                    break;
                }
            }
        }
        if (s == 3) {
            return node;
        }
        node3 = node.getOwnerDocument().createTextNode(node.getNodeValue());
        node2.replaceChild(node3, node);
        return node3;
    }

    public static Node expandEntityRef(Node node) {
        if (node.getNodeType() != 5) {
            return null;
        }
        Node node2 = node.getParentNode();
        if (node2 == null) {
            return null;
        }
        Node node3 = node.getNextSibling();
        Node node4 = node.getFirstChild();
        while (node4 != null) {
            node2.insertBefore(node4.cloneNode(true), node3);
            node4 = node4.getNextSibling();
        }
        node3 = node.getNextSibling();
        node2.removeChild(node);
        return node3;
    }

    /*
     * Unable to fully structure code
     */
    public static String serialize(Node var0, boolean var1_1, boolean var2_2) {
        switch (var0.getNodeType()) {
            case 2: {
                if (var1_1) {
                    return var0.getNodeValue();
                }
                return DOMNormalizer.serializeAttr((Attr)var0);
            }
            case 3: 
            case 4: {
                if (var1_1) {
                    return null;
                }
                return var0.getNodeValue();
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return null;
            }
            case 5: 
            case 9: 
            case 11: {
                var1_1 = true;
                break;
            }
        }
        var3_3 = new StringBuffer();
        var5_4 = var1_1 != false ? var0.getFirstChild() : var0;
        block10: while (var5_4 != null) {
            switch (var5_4.getNodeType()) {
                case 1: {
                    var3_3.append('<');
                    var3_3.append(var5_4.getNodeName());
                    var3_3.append(DOMNormalizer.serializeAttrs(var5_4.getAttributes()));
                    var3_3.append('>');
                    break;
                }
                case 3: 
                case 4: {
                    var4_5 = var2_2 != false ? DOMNormalizer.escape(var5_4.getNodeValue()) : var5_4.getNodeValue();
                    var3_3.append(var4_5);
                    break;
                }
            }
            var6_6 = var5_4.getFirstChild();
            if (var6_6 == null) ** GOTO lbl61
            var5_4 = var6_6;
            continue;
lbl-1000:
            // 1 sources

            {
                if (var5_4.getNodeType() == 1) {
                    var3_3.append('<');
                    var3_3.append('/');
                    var3_3.append(var5_4.getNodeName());
                    var3_3.append('>');
                }
                if ((var6_6 = var5_4.getNextSibling()) != null) {
                    var5_4 = var6_6;
                    continue block10;
                }
                if ((var5_4 = var5_4.getParentNode()) != var0) continue;
                if (!var1_1 && var5_4.getNodeType() == 1) {
                    var3_3.append('<');
                    var3_3.append('/');
                    var3_3.append(var5_4.getNodeName());
                    var3_3.append('>');
                }
                var5_4 = null;
lbl61:
                // 3 sources

                ** while (var5_4 != null)
            }
lbl62:
            // 1 sources

        }
        return var3_3.toString();
    }

    private static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            switch (cArray[n2]) {
                case '&': 
                case '<': {
                    stringBuffer.append(cArray, n, n2 - n);
                    n = n2 + 1;
                    if (cArray[n2] == '&') {
                        stringBuffer.append(AMPENTITY);
                        break;
                    }
                    stringBuffer.append(LTENTITY);
                    break;
                }
            }
            ++n2;
        }
        stringBuffer.append(cArray, n, cArray.length - n);
        return stringBuffer.toString();
    }

    private static String serializeAttrs(NamedNodeMap namedNodeMap) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            stringBuffer.append(' ');
            stringBuffer.append(DOMNormalizer.serializeAttr((Attr)namedNodeMap.item(n)));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String serializeAttr(Attr attr) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(attr.getNodeName());
        stringBuffer.append('=');
        stringBuffer.append(DOMNormalizer.getQuotedValue(attr.getNodeValue()));
        return stringBuffer.toString();
    }

    private static String getQuotedValue(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.indexOf(34) == -1) {
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
        } else if (string.indexOf(39) == -1) {
            stringBuffer.append('\'');
            stringBuffer.append(string);
            stringBuffer.append('\'');
        } else {
            stringBuffer.append('\"');
            char[] cArray = string.toCharArray();
            int n = 0;
            int n2 = 0;
            while (n2 < cArray.length) {
                if (cArray[n2] == '\"') {
                    stringBuffer.append(cArray, n, n2 - n);
                    stringBuffer.append(QUOTENTITY);
                    n = n2 + 1;
                }
                ++n2;
            }
            stringBuffer.append(cArray, n, cArray.length - n);
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }
}

