/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.Row;
import org.xmlmiddleware.xmldbms.TransferInfo;
import org.xmlmiddleware.xmldbms.actions.Action;
import org.xmlmiddleware.xmldbms.actions.Actions;
import org.xmlmiddleware.xmldbms.datahandlers.DataHandler;
import org.xmlmiddleware.xmldbms.filters.FilterBase;
import org.xmlmiddleware.xmldbms.filters.FilterConditions;
import org.xmlmiddleware.xmldbms.filters.FilterSet;
import org.xmlmiddleware.xmldbms.filters.RelatedTableFilter;
import org.xmlmiddleware.xmldbms.filters.RootFilter;
import org.xmlmiddleware.xmldbms.filters.TableFilter;
import org.xmlmiddleware.xmldbms.maps.ClassTableMap;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.Key;
import org.xmlmiddleware.xmldbms.maps.LinkInfo;
import org.xmlmiddleware.xmldbms.maps.PropertyTableMap;
import org.xmlmiddleware.xmldbms.maps.RelatedClassTableMap;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;
import org.xmlmiddleware.xmlutils.XMLName;

public class DBMSDelete {
    private static boolean debug;
    private int commitMode = 1;
    private XMLDBMSMap map;
    private TransferInfo transferInfo;
    private Actions actions;
    private FilterBase filterBase;

    public void setCommitMode(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new IllegalArgumentException("Invalid commit mode value: " + n);
        }
        this.commitMode = n;
    }

    public int getCommitMode() {
        return this.commitMode;
    }

    public void deleteDocument(TransferInfo transferInfo, FilterSet filterSet, Hashtable hashtable, int n) throws SQLException, XMLMiddlewareException {
        if (n != 5 && n != 6) {
            throw new IllegalArgumentException("action argument must be Action.DELETE or Action.SOFTDELETE.");
        }
        Actions actions = new Actions(transferInfo.getMap());
        Action action = new Action();
        action.setAction(n);
        actions.setDefaultAction(action);
        this.deleteDocument(transferInfo, filterSet, hashtable, actions);
    }

    public void deleteDocument(TransferInfo transferInfo, FilterSet filterSet, Hashtable hashtable, Actions actions) throws SQLException, XMLMiddlewareException {
        this.transferInfo = transferInfo;
        this.map = transferInfo.getMap();
        this.actions = actions;
        filterSet.setFilterParameters(hashtable);
        Enumeration enumeration = transferInfo.getDataHandlers();
        while (enumeration.hasMoreElements()) {
            ((DataHandler)enumeration.nextElement()).startDocument(this.commitMode);
        }
        this.processRootTables(filterSet);
        enumeration = transferInfo.getDataHandlers();
        while (enumeration.hasMoreElements()) {
            ((DataHandler)enumeration.nextElement()).endDocument();
        }
    }

    private void processRootTables(FilterSet filterSet) throws SQLException, XMLMiddlewareException {
        Vector vector = filterSet.getFilters();
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            this.filterBase = (FilterBase)e;
            if (e instanceof RootFilter) {
                this.processRootTable((RootFilter)e);
            }
            ++n;
        }
    }

    private void processRootTable(RootFilter rootFilter) throws SQLException, XMLMiddlewareException {
        Vector vector = new Vector();
        FilterConditions filterConditions = rootFilter.getRootFilterConditions();
        Table table = filterConditions.getTable();
        ClassTableMap classTableMap = this.map.getClassTableMap(table);
        int n = this.getActionFor(classTableMap.getElementTypeName());
        RowInfo rowInfo = new RowInfo(n, table, null, null, filterConditions);
        ResultSet resultSet = this.getResultSet(rowInfo);
        this.processClassResultSet(classTableMap, resultSet, vector);
        resultSet.close();
        if (n == 5 || n == 6) {
            this.deleteRows(rowInfo);
            this.deleteRows(vector);
        }
    }

    private void processClassResultSet(ClassTableMap classTableMap, ResultSet resultSet, Vector vector) throws SQLException, XMLMiddlewareException {
        Row row = new Row();
        while (resultSet.next()) {
            row.clear();
            row.setColumnValues(resultSet, classTableMap.getTable(), this.map.emptyStringIsNull());
            TableFilter tableFilter = this.filterBase.getTableFilter(classTableMap.getTable());
            this.processRelatedTables(row, classTableMap, tableFilter, vector);
        }
    }

    private void processRelatedTables(Row row, ClassTableMap classTableMap, TableFilter tableFilter, Vector vector) throws SQLException, XMLMiddlewareException {
        this.processRelatedClassTables(row, classTableMap, tableFilter, vector);
        this.processPropertyTables(row, classTableMap, tableFilter, vector);
    }

    private void processRelatedClassTables(Row row, ClassTableMap classTableMap, TableFilter tableFilter, Vector vector) throws SQLException, XMLMiddlewareException {
        Vector vector2 = new Vector();
        Enumeration enumeration = classTableMap.getRelatedClassTableMaps();
        while (enumeration.hasMoreElements()) {
            RelatedClassTableMap relatedClassTableMap = (RelatedClassTableMap)enumeration.nextElement();
            RelatedTableFilter relatedTableFilter = tableFilter == null ? null : tableFilter.getRelatedTableFilter(relatedClassTableMap);
            vector2.removeAllElements();
            int n = this.getActionFor(relatedClassTableMap.getElementTypeName());
            this.isLeafTable(relatedClassTableMap);
            this.processRelatedClassTable(row, relatedClassTableMap, relatedTableFilter, vector2);
            if (n != 5 && n != 6) continue;
            LinkInfo linkInfo = relatedClassTableMap.getLinkInfo();
            Table table = relatedClassTableMap.getClassTableMap().getTable();
            RowInfo rowInfo = new RowInfo(n, table, linkInfo, row, relatedTableFilter);
            if (linkInfo.parentKeyIsUnique()) {
                this.deleteRows(rowInfo);
                this.deleteRows(vector2);
                continue;
            }
            vector.addElement(rowInfo);
            this.copyElements(vector, vector2);
        }
    }

    private void processRelatedClassTable(Row row, RelatedClassTableMap relatedClassTableMap, RelatedTableFilter relatedTableFilter, Vector vector) throws SQLException, XMLMiddlewareException {
        ClassTableMap classTableMap = relatedClassTableMap.getClassTableMap();
        Table table = classTableMap.getTable();
        LinkInfo linkInfo = relatedClassTableMap.getLinkInfo();
        RowInfo rowInfo = new RowInfo(0, table, linkInfo, row, relatedTableFilter);
        ResultSet resultSet = this.getResultSet(rowInfo);
        this.processClassResultSet(classTableMap, resultSet, vector);
        resultSet.close();
    }

    private void processPropertyTables(Row row, ClassTableMap classTableMap, TableFilter tableFilter, Vector vector) throws SQLException, XMLMiddlewareException {
        Enumeration enumeration = classTableMap.getPropertyTableMaps();
        while (enumeration.hasMoreElements()) {
            PropertyTableMap propertyTableMap = (PropertyTableMap)enumeration.nextElement();
            RelatedTableFilter relatedTableFilter = tableFilter == null ? null : tableFilter.getRelatedTableFilter(propertyTableMap);
            int n = this.getActionFor(classTableMap.getElementTypeName());
            if (n != 5 && n != 6) continue;
            LinkInfo linkInfo = propertyTableMap.getLinkInfo();
            RowInfo rowInfo = new RowInfo(n, propertyTableMap.getTable(), linkInfo, row, relatedTableFilter);
            if (linkInfo.parentKeyIsUnique()) {
                this.deleteRows(rowInfo);
                continue;
            }
            vector.addElement(rowInfo);
        }
    }

    private int getActionFor(XMLName xMLName) {
        Action action = this.actions.getAction(xMLName);
        if (action == null) {
            action = this.actions.getDefaultAction();
        }
        if (action == null) {
            throw new IllegalArgumentException("No default action specified.");
        }
        int n = action.getAction();
        if (n != 5 && n != 6 && n != 0) {
            throw new IllegalArgumentException("INSERT, SOFTINSERT, UPDATEORINSERT, and UPDATE actions cannot be used with DBMSDelete.");
        }
        return n;
    }

    private boolean isLeafTable(RelatedClassTableMap relatedClassTableMap) {
        ClassTableMap classTableMap = relatedClassTableMap.getClassTableMap();
        if (classTableMap.getRelatedClassTableMaps().hasMoreElements()) {
            return false;
        }
        return !classTableMap.getPropertyTableMaps().hasMoreElements();
    }

    private void copyElements(Vector vector, Vector vector2) {
        int n = 0;
        while (n < vector2.size()) {
            vector.addElement(vector2.elementAt(n));
            ++n;
        }
    }

    private void deleteRows(RowInfo rowInfo) throws SQLException {
        DataHandler dataHandler = this.transferInfo.getDataHandler(rowInfo.table.getDatabaseName());
        try {
            dataHandler.delete(rowInfo.table, rowInfo.key, rowInfo.keyValue, rowInfo.where, rowInfo.columns, rowInfo.params);
            return;
        }
        catch (SQLException sQLException) {
            if (rowInfo.action != 6) {
                throw sQLException;
            }
            return;
        }
    }

    private void deleteRows(Vector vector) throws SQLException {
        int n = 0;
        while (n < vector.size()) {
            RowInfo rowInfo = (RowInfo)vector.elementAt(n);
            this.deleteRows(rowInfo);
            ++n;
        }
    }

    private ResultSet getResultSet(RowInfo rowInfo) throws SQLException {
        DataHandler dataHandler = this.transferInfo.getDataHandler(rowInfo.table.getDatabaseName());
        return dataHandler.select(rowInfo.table, rowInfo.key, rowInfo.keyValue, rowInfo.where, rowInfo.columns, rowInfo.params, null);
    }

    class RowInfo {
        int action;
        Table table;
        Key key;
        Object[] keyValue;
        String where;
        Column[] columns;
        Object[] params;

        RowInfo(int n, Table table, LinkInfo linkInfo, Row row, FilterConditions filterConditions) throws XMLMiddlewareException {
            DBMSDelete.this = DBMSDelete.this;
            this.action = n;
            this.table = table;
            if (linkInfo != null) {
                this.key = linkInfo.getChildKey();
                this.keyValue = row.getColumnValues(linkInfo.getParentKey().getColumns());
            }
            if (filterConditions != null) {
                this.where = filterConditions.getWhereCondition();
                this.columns = filterConditions.getColumns();
                this.params = filterConditions.getParameterValues();
            }
        }
    }
}

