/*
 * Decompiled with CFR 0.152.
 */
package com.trsupdate;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Rights;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class UnnecessaryRightsCaculator {
    private static Logger logger = Logger.getLogger(UnnecessaryRightsCaculator.class);

    public List caculateUnnecessaryRightsForGroup() throws WCMException {
        WCMFilter filter = new WCMFilter("WCMRight", "OprType=?", "ObjType, ObjId", "RightId,OprType,OprId,ObjType,ObjId,RightValue");
        filter.addSearchValues(201);
        int nCount = DBManager.getDBManager().sqlExecuteCountQuery(filter);
        if (nCount <= 1) {
            return new ArrayList();
        }
        filter.setPageSize(nCount);
        filter.setMaxRowNumber(nCount);
        ArrayList arResult = new ArrayList(nCount / 2);
        Rights rights = Rights.openWCMObjs(null, filter);
        Rights oRightsNeedCaculate = new Rights(null, 100, 2);
        int nCurrObjType = -1;
        int nCurrObjId = -1;
        int nSize = rights.size();
        for (int i = 0; i < nSize; ++i) {
            Right right = (Right)rights.getAt(i);
            if (nCurrObjType == -1) {
                nCurrObjType = right.getObjType();
                nCurrObjId = right.getObjId();
            }
            if (nCurrObjType == right.getObjType() && nCurrObjId == right.getObjId()) {
                oRightsNeedCaculate.addElement(right);
                if (i != nSize - 1) continue;
                arResult.addAll(this.caculateMoreRightIds(oRightsNeedCaculate));
                continue;
            }
            arResult.addAll(this.caculateMoreRightIds(oRightsNeedCaculate));
            oRightsNeedCaculate.clear();
            oRightsNeedCaculate = new Rights(null, 100, 2);
            nCurrObjType = -1;
            --i;
        }
        return arResult;
    }

    private List caculateMoreRightIds(Rights _oRights) throws WCMException {
        int nRightSize = _oRights.size();
        if (nRightSize <= 1) {
            return new ArrayList();
        }
        ArrayList<Integer> arResultContainsRightId = new ArrayList<Integer>(nRightSize - 1);
        for (int i = 0; i < nRightSize; ++i) {
            Right oCurrRight = (Right)_oRights.getAt(i);
            boolean bDefineOnParent = this.isDefineOnParent(oCurrRight, _oRights);
            if (!bDefineOnParent) continue;
            arResultContainsRightId.add(new Integer(oCurrRight.getId()));
        }
        return arResultContainsRightId;
    }

    private boolean isDefineOnParent(Right _currRight, Rights _oRights) throws WCMException {
        Group currGroup = Group.findById(_currRight.getOperatorId());
        if (currGroup == null) {
            logger.error((Object)("\u810f\u6570\u636e\uff0c\u76f8\u5173\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01RightId=" + _currRight.getId() + ", GroupId=" + _currRight.getOperatorId()));
            return true;
        }
        long lCurrRightValue = _currRight.getValueAsLong();
        int[] pCurrRoute = new int[10];
        int nIndexTemp = 0;
        for (Group currParent = currGroup.getParent(); currParent != null; currParent = currParent.getParent()) {
            pCurrRoute[nIndexTemp++] = currParent.getId();
        }
        int nRightSize = _oRights.size();
        for (int j = 0; j < nRightSize; ++j) {
            Right oRightTemp = (Right)_oRights.getAt(j);
            if (oRightTemp.getOperatorType() != 201) continue;
            int nOprIdTemp = oRightTemp.getOperatorId();
            for (int nCurrRouteIndex = 0; nCurrRouteIndex < pCurrRoute.length; ++nCurrRouteIndex) {
                if (nOprIdTemp != pCurrRoute[nCurrRouteIndex] || !UnnecessaryRightsCaculator.containsValue(oRightTemp.getValueAsLong(), lCurrRightValue)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsValue(long _lSrc, long _lDst) {
        if (_lSrc < _lDst) {
            return false;
        }
        if (_lSrc == _lDst) {
            return true;
        }
        long lTemp = _lSrc ^ _lDst;
        return (lTemp &= _lSrc ^ 0xFFFFFFFFFFFFFFFFL) == 0L;
    }

    public static void main(String[] args) {
    }
}

