/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.xml.XmlObjectPersistentor;
import com.trs.service.IChannelService;
import com.trs.service.ITemplateService;
import com.trs.template.domain.SourcePathHelper;
import com.trs.template.persistent.BaseChannelInfoEntity;
import com.trs.template.persistent.InfoEntities;
import com.trs.template.persistent.TemplateInfoEntity;
import com.trs.template.persistent.WebSiteInfoEntity;
import java.util.List;
import org.apache.log4j.Logger;

public class InfoEntityFinder {
    private IChannelService m_oChnlSrv = null;
    private InfoEntities m_oSiteEntities = null;
    private InfoEntities m_oCurrBaseChannelEntities = null;
    private InfoEntities m_oFieldEntities = null;
    private InfoEntities m_oTemplateEntities = null;
    private User m_oLoginUser = ContextHelper.getLoginUser();
    private static Logger s_logger = Logger.getLogger(InfoEntityFinder.class);
    private ITemplateService m_oTemplateSrv;

    public InfoEntityFinder() {
        this.m_oChnlSrv = (IChannelService)DreamFactory.createObjectById("IChannelService");
        this.m_oTemplateSrv = (ITemplateService)DreamFactory.createObjectById("ITemplateService");
    }

    protected void loadSiteInfoEntities() throws WCMException {
        this.m_oSiteEntities = new InfoEntities();
        try {
            User user = this.m_oLoginUser;
            WebSites sites = new WebSites(user);
            sites.open(null);
            if (sites.size() == 0) {
                return;
            }
            for (int i = 0; i < sites.size(); ++i) {
                WebSiteInfoEntity entity;
                WebSite site = (WebSite)sites.getAt(i);
                if (site == null || site.isDeleted() || !this.hasRight(user, site) || (entity = new WebSiteInfoEntity(site.getId(), site.getName(), site.getDesc())) == null) continue;
                this.m_oSiteEntities.add(entity);
            }
        }
        catch (WCMException ex) {
            throw new WCMException(I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label1", "\u67e5\u627e\u7528\u6237[") + this.m_oLoginUser.getName() + I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label2", "]\u53ef\u7f16\u8f91\u7684\u7ad9\u70b9\u65f6\u51fa\u9519!"), ex);
        }
    }

    private boolean hasRight(User user, WebSite site) throws WCMException {
        if (user.isAdministrator() || site.getCrUserName().equals(user.getName())) {
            return true;
        }
        return AuthServer.hasRight(user, (CMSObj)site, 64);
    }

    protected void loadBaseChannelEntities(int _nSiteId) throws WCMException {
        this.m_oCurrBaseChannelEntities = new InfoEntities();
        try {
            WebSite oSite = WebSite.findById(_nSiteId);
            if (oSite == null) {
                throw new WCMException(I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label3", "\u6ca1\u6709\u627e\u5230\u7ad9\u70b9[") + _nSiteId + "]!");
            }
            BaseChannelInfoEntity siteInfoEntity = this.makeBaseChannelInfoEntity(oSite);
            if (siteInfoEntity == null) {
                throw new WCMException(I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label4", "\u65e0\u6cd5\u521b\u5efa\u7ad9\u70b9[") + _nSiteId + I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label5", "]\u7684\u683c\u5f0f\u5316\u4fe1\u606f!"));
            }
            this.m_oCurrBaseChannelEntities.add(siteInfoEntity);
            this.loadChildrenChannels(oSite);
        }
        catch (WCMException ex) {
            throw new WCMException(I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label1", "\u67e5\u627e\u7528\u6237[") + this.m_oLoginUser.getName() + I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label6", "]\u53ef\u7f16\u8f91\u7684\u9891\u9053\u5217\u8868\u65f6\u51fa\u9519!"), ex);
        }
    }

    private void loadChildrenChannels(BaseChannel oBaseChannel) throws WCMException {
        List channels = this.m_oChnlSrv.getChildren(oBaseChannel, 23);
        if (channels.size() == 0) {
            return;
        }
        for (int i = 0; i < channels.size(); ++i) {
            BaseChannel channel = (BaseChannel)channels.get(i);
            BaseChannelInfoEntity entity = this.makeBaseChannelInfoEntity(channel);
            if (entity != null) {
                this.m_oCurrBaseChannelEntities.add(entity);
            }
            this.loadChildrenChannels(channel);
        }
    }

    private BaseChannelInfoEntity makeBaseChannelInfoEntity(BaseChannel _oBaseChannel) throws WCMException {
        BaseChannelInfoEntity result = new BaseChannelInfoEntity();
        result.setChannelId(_oBaseChannel.getId());
        result.setChannelName(_oBaseChannel.getName());
        result.setChannelDesc(_oBaseChannel.getDesc());
        result.setIsRoot(_oBaseChannel.isSite());
        result.setParentId(_oBaseChannel.getParentId());
        result.setChildren(_oBaseChannel.getChildrenSize(this.m_oLoginUser));
        return result;
    }

    public InfoEntities getBaseChannelEntities(int _nSiteId) throws WCMException {
        this.loadBaseChannelEntities(_nSiteId);
        return this.m_oCurrBaseChannelEntities;
    }

    public InfoEntities getSiteEntities() throws WCMException {
        if (this.m_oSiteEntities == null) {
            this.loadSiteInfoEntities();
        }
        return this.m_oSiteEntities;
    }

    public InfoEntities getFieldEntities() throws WCMException {
        if (this.m_oFieldEntities == null) {
            this.loadMockFieldEntities();
        }
        return this.m_oFieldEntities;
    }

    private void loadMockFieldEntities() throws WCMException {
        try {
            XmlObjectPersistentor objPersistentor = new XmlObjectPersistentor();
            objPersistentor.setMappingSrc(SourcePathHelper.getFieldMockMappingFilePath());
            String mockFilePath = SourcePathHelper.getMockFieldInfoFilePath();
            this.m_oFieldEntities = (InfoEntities)objPersistentor.getParsedInstance(mockFilePath);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Has building all the fields from file[" + mockFilePath + "] successfully"));
            }
        }
        catch (CMyException ex) {
            throw new WCMException(I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label7", "\u67e5\u627e\u7528\u6237\u7f6e\u6807\u5b57\u6bb5\u5217\u8868\u65f6\u51fa\u9519!"), ex);
        }
    }

    public InfoEntities getTemplateEntities() throws WCMException {
        if (this.m_oTemplateEntities == null) {
            this.loadTemplateEntities();
        }
        return this.m_oTemplateEntities;
    }

    protected void loadTemplateEntities() throws WCMException {
        this.m_oTemplateEntities = new InfoEntities();
        try {
            User user = this.m_oLoginUser;
            WebSites sites = new WebSites(user);
            sites.open(null);
            if (sites.size() == 0) {
                return;
            }
            for (int i = 0; i < sites.size(); ++i) {
                WebSite site = (WebSite)sites.getAt(i);
                if (site == null || site.isDeleted() || !this.hasRight(user, site)) continue;
                Templates templates = this.m_oTemplateSrv.getManagedTemplates(site, -1, null, true);
                for (int nIndex = 0; nIndex < templates.size(); ++nIndex) {
                    Template template = (Template)templates.getAt(nIndex);
                    TemplateInfoEntity entity = this.makeTemplateInfoEntity(template);
                    if (entity == null) continue;
                    this.m_oTemplateEntities.add(entity);
                }
            }
        }
        catch (WCMException ex) {
            throw new WCMException(I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label1", "\u67e5\u627e\u7528\u6237[") + this.m_oLoginUser.getName() + I18NMessage.get(InfoEntityFinder.class, "InfoEntityFinder.label8", "]\u53ef\u7f16\u8f91\u7684\u6a21\u677f\u5217\u8868\u65f6\u51fa\u9519!"), ex);
        }
    }

    private TemplateInfoEntity makeTemplateInfoEntity(Template template) {
        if (template == null) {
            return null;
        }
        TemplateInfoEntity result = new TemplateInfoEntity();
        result.setTemplateId(template.getId());
        result.setTemplateName(this.getPreparedTemplateName(template));
        result.setTemplateName(template.getName());
        result.setTemplateType(template.getType());
        result.setFolderId(template.getFolderId());
        result.setFolderType(template.getFolderType());
        return result;
    }

    private String getPreparedTemplateName(Template template) {
        String result = null;
        int nFolderType = template.getFolderType();
        boolean bIsSite = nFolderType == 103;
        StringBuffer sb = new StringBuffer(template.getName());
        sb.append("(");
        sb.append(bIsSite ? "S" : "C");
        sb.append(template.getFolderId());
        sb.append(")");
        result = sb.toString();
        sb.setLength(0);
        return result;
    }
}

