/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.stat;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.job.BaseStatefulScheduleWorker;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.publish.domain.SCMMCPublishServer;
import com.trs.scm.sdk.crawler.impl.SCMWeiboCrawlerHelper;
import com.trs.util.CMyString;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class HistoryMicroContentSchWorker
extends BaseStatefulScheduleWorker {
    private static final Logger logger = Logger.getLogger(SCMMCPublishServer.class);
    private static final int m_PageSize = 10;
    private static final int m_PageIndex = 1;
    private static final int m_GetPagesNum = 1;
    private static final int m_PageFlag = 2;
    private static final String m_Accounts = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() throws WCMException {
        logger.info((Object)"HistoryMicroContentSchWorker --> execute start:");
        ContextHelper.initContext(User.getSystem());
        int nMCNums = 10;
        int nIndex = 1;
        int nSize = 1;
        String sAccountIds = m_Accounts;
        try {
            if (!CMyString.isEmpty((String)this.getArgAsString("PAGESIZE"))) {
                nMCNums = Integer.parseInt(this.getArgAsString("PAGESIZE"));
            }
            if (!CMyString.isEmpty((String)this.getArgAsString("PAGEINDEX"))) {
                nIndex = Integer.parseInt(this.getArgAsString("PAGEINDEX"));
            }
            if (!CMyString.isEmpty((String)this.getArgAsString("PAGENUM"))) {
                nSize = Integer.parseInt(this.getArgAsString("PAGENUM"));
            }
            if (!CMyString.isEmpty((String)this.getArgAsString("ACCOUNTS"))) {
                sAccountIds = this.getArgAsString("ACCOUNTS");
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u5fae\u535a\u53c2\u6570\u5931\u8d25\uff1a" + e.getMessage()));
        }
        int nPageSize = nMCNums;
        int nPageFlag = 2;
        if (CMyString.isEmpty((String)sAccountIds)) {
            Accounts accounts = Accounts.createNewInstance(User.getSystem());
            accounts.open(new WCMFilter());
            boolean isFirst = true;
            int nISize = accounts.size();
            for (int i = 0; i < nISize; ++i) {
                Account oAccount = (Account)accounts.getAt(i);
                if (oAccount == null || oAccount.getStatus() != 1 || !oAccount.getPlatform().toLowerCase().equals("sina") && !oAccount.getPlatform().toLowerCase().equals("tencent")) continue;
                if (isFirst) {
                    isFirst = false;
                    sAccountIds = oAccount.getId() + m_Accounts;
                    continue;
                }
                sAccountIds = sAccountIds + "," + oAccount.getId();
            }
        }
        if (CMyString.isEmpty((String)sAccountIds)) {
            logger.debug((Object)"\u83b7\u53d6\u975eSCM\u7aef\u53d1\u5e03\u7684\u5fae\u535a\u5931\u8d25\uff0c\u6ca1\u6709\u8981\u83b7\u53d6\u7684\u5fae\u535a\u8d26\u53f7\uff01");
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("PageIndex", nIndex);
        paramMap.put("PageSize", nPageSize);
        paramMap.put("PageNum", nSize);
        paramMap.put("PageFlag", nPageFlag);
        paramMap.put("AccountIds", sAccountIds);
        try {
            new SCMWeiboCrawlerHelper().execute(paramMap);
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u975eSCM\u7aef\u53d1\u5e03\u7684\u5fae\u535a\u5931\u8d25:" + e.getMessage()));
        }
        finally {
            ContextHelper.clear();
        }
    }
}

