/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.impl;

import com.tencent.weibo.api.TAPI;
import com.tencent.weibo.beans.OAuth;
import com.tencent.weibo.oauthv2.OAuthV2;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.scm.sdk.impl.AbstractFavoriteMgr;
import com.trs.scm.sdk.impl.Fav_API;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.Favorite;
import com.trs.scm.sdk.model.FavoriteWrapper;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.util.TencentException;
import com.trs.scm.sdk.util.TencentObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TencentFavoriteMgr
extends AbstractFavoriteMgr {
    private static Map<String, FavoriteWrapper> m_OAuthFavoriteMap = null;
    private static Map<String, CMyDateTime> m_oLastRefreshDate = null;
    private Fav_API m_oFav_API = new Fav_API();
    private OAuthV2 m_oTencentOAuth = new OAuthV2();

    public TencentFavoriteMgr(com.trs.scm.sdk.model.OAuth auth) {
        super(auth);
        this.m_oTencentOAuth.setAccessToken(auth.getOAuth_token());
        this.m_oTencentOAuth.setOpenid(auth.getOAuth_token_secret());
        this.m_oTencentOAuth.setClientId(auth.getAppKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Favorite createFavorite(String _sMicroContentId) throws Exception {
        String sFormat = "json";
        String sResponse = this.m_oFav_API.addt(this.m_oTencentOAuth, sFormat, _sMicroContentId);
        try {
            TencentObjectUtil.validResult(sResponse, "\u6536\u85cf\u5fae\u535a");
        }
        finally {
            this.reSetCache();
        }
        CMyDateTime oFavoriteTime = CMyDateTime.now();
        TAPI TAPI2 = new TAPI("2.a");
        sResponse = TAPI2.show((OAuth)this.m_oTencentOAuth, sFormat, _sMicroContentId);
        MicroContent microContent = new MicroContent();
        microContent.setId(_sMicroContentId);
        Favorite oFavorite = new Favorite();
        oFavorite.setMicroContent(microContent);
        oFavorite.setFavoriteTime(oFavoriteTime.getDateTime());
        return oFavorite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroyFavorite(String _sMicroContentId) throws Exception {
        String sFormat = "json";
        String sResponse = this.m_oFav_API.delt(this.m_oTencentOAuth, sFormat, _sMicroContentId);
        try {
            TencentObjectUtil.validResult(sResponse, "\u6536\u85cf\u5fae\u535a");
        }
        finally {
            this.reSetCache();
        }
        return true;
    }

    @Override
    public FavoriteWrapper getFavorites(int _nPageIndex, int _nPageSize, ExtraParams _oExtraParams) throws Exception {
        if (_nPageSize > 70 || _nPageSize < 1) {
            throw new Exception("\u9875\u9762\u5927\u5c0f\u5fc5\u987b\u57281\u81f370\u4e4b\u95f4\uff01");
        }
        if (_nPageIndex < 1) {
            _nPageIndex = 1;
        }
        int nMaxPageSize = 100;
        boolean bRefreshed = this.refreshIfNeed(_nPageIndex, _nPageSize, nMaxPageSize);
        String sAccessToken = this.m_oTencentOAuth.getAccessToken();
        FavoriteWrapper oFavoriteWrapper = m_OAuthFavoriteMap.get(sAccessToken);
        if (bRefreshed) {
            return this.constructResult(_nPageIndex, _nPageSize, oFavoriteWrapper);
        }
        if (oFavoriteWrapper == null) {
            return null;
        }
        int nFromIndex = _nPageIndex * _nPageSize - _nPageSize;
        int nToIndex = _nPageIndex * _nPageSize;
        long lTotalNum = oFavoriteWrapper.getTotalNumber();
        List<Favorite> favorites = oFavoriteWrapper.getFavorites();
        int nListSize = favorites.size();
        int nRequestNum = 0;
        if (lTotalNum <= (long)nFromIndex) {
            return null;
        }
        nRequestNum = lTotalNum < (long)nToIndex ? (int)lTotalNum - nListSize : nToIndex - nListSize;
        if (nRequestNum <= 0) {
            return this.constructResult(_nPageIndex, _nPageSize, oFavoriteWrapper);
        }
        oFavoriteWrapper = this.loadFavorites(oFavoriteWrapper, nRequestNum, _nPageSize, nMaxPageSize);
        m_OAuthFavoriteMap.put(sAccessToken, oFavoriteWrapper);
        return this.constructResult(_nPageIndex, _nPageSize, oFavoriteWrapper);
    }

    private boolean refreshIfNeed(int _nPageIndex, int _nPageSize, int _nMaxPageSize) throws Exception {
        int nRequestNum = _nPageIndex * _nPageSize;
        String sAccessToken = this.m_oTencentOAuth.getAccessToken();
        boolean isSatisfied = false;
        if (m_OAuthFavoriteMap != null && m_OAuthFavoriteMap.get(sAccessToken) != null) {
            boolean bl = isSatisfied = m_OAuthFavoriteMap.get(sAccessToken).getTotalNumber() > (long)nRequestNum;
        }
        if (!this.needRefresh() && isSatisfied) {
            return false;
        }
        FavoriteWrapper favoriteWrapper = this.loadFavorites(null, nRequestNum, _nPageSize, _nMaxPageSize);
        if (m_OAuthFavoriteMap == null) {
            m_OAuthFavoriteMap = new HashMap<String, FavoriteWrapper>();
        }
        if (m_oLastRefreshDate == null) {
            m_oLastRefreshDate = new HashMap<String, CMyDateTime>();
        }
        m_OAuthFavoriteMap.put(sAccessToken, favoriteWrapper);
        m_oLastRefreshDate.put(sAccessToken, CMyDateTime.now());
        return true;
    }

    private FavoriteWrapper constructResult(int _nPageIndex, int _nPageSize, FavoriteWrapper _oFavoriteWrapper) {
        if (_oFavoriteWrapper == null) {
            return null;
        }
        List<Favorite> oFavorites = _oFavoriteWrapper.getFavorites();
        int nNum = oFavorites.size();
        int nFromIndex = _nPageIndex * _nPageSize - _nPageSize;
        if (oFavorites == null || nNum == 0 || nNum <= nFromIndex) {
            return null;
        }
        int nToIndex = _nPageIndex * _nPageSize;
        if (nNum < nToIndex) {
            nToIndex = nNum;
        }
        ArrayList<Favorite> oNewFavorites = new ArrayList<Favorite>();
        oNewFavorites.addAll(oFavorites);
        oNewFavorites = oNewFavorites.subList(nFromIndex, nToIndex);
        FavoriteWrapper oResultFavoriteWrapper = new FavoriteWrapper(oNewFavorites, _oFavoriteWrapper.getTotalNumber());
        oResultFavoriteWrapper.setExtraAttributes(_oFavoriteWrapper.getExtraAttributes());
        return oResultFavoriteWrapper;
    }

    private boolean needRefresh() {
        if (m_oLastRefreshDate == null) {
            return true;
        }
        CMyDateTime oLastRefreshTime = m_oLastRefreshDate.get(this.m_oTencentOAuth.getAccessToken());
        if (oLastRefreshTime == null) {
            return true;
        }
        CMyDateTime now = CMyDateTime.now();
        return now.getTimeInMillis() - oLastRefreshTime.getTimeInMillis() > 120000L;
    }

    private FavoriteWrapper loadFavorites(FavoriteWrapper _oFavoriteWrapper, int _nRequestNum, int _nPageSize, int _nMaxPageSize) throws Exception {
        int nPageNum = 1;
        int nRequestNum = _nRequestNum;
        int nPageSize = _nPageSize;
        if (nRequestNum <= 100) {
            nPageNum = 1;
            nPageSize = nRequestNum;
        } else {
            nPageNum = nRequestNum / 100;
            nPageSize = 100;
            int nLastPageNum = nRequestNum % 100;
            if (nLastPageNum > 0) {
                ++nPageNum;
            }
        }
        String sReqnum = Integer.toString(nPageSize);
        String sFormat = "json";
        String sLastId = "0";
        String sPageTime = "0";
        if (_oFavoriteWrapper != null) {
            sLastId = _oFavoriteWrapper.getExtraAttributeAsString("lastid");
            sPageTime = _oFavoriteWrapper.getExtraAttributeAsString("timestamp");
        }
        String sPageFlag = "1";
        FavoriteWrapper allFavoriteWrapper = _oFavoriteWrapper;
        for (int i = 1; i <= nPageNum; ++i) {
            FavoriteWrapper tempFavoriteWrapper;
            String sResponse = this.m_oFav_API.list_t(this.m_oTencentOAuth, sFormat, sPageFlag, sPageTime, sReqnum, sLastId);
            try {
                tempFavoriteWrapper = TencentObjectUtil.constructFavorites(sResponse, _nPageSize);
            }
            catch (Exception e) {
                if (e instanceof TencentException && ((TencentException)e).getMessage().indexOf("\u5f53\u524d\u9875\u65e0\u6570\u636e\u8fd4\u56de") >= 0) {
                    tempFavoriteWrapper = null;
                }
                throw e;
            }
            if (tempFavoriteWrapper == null) break;
            if (allFavoriteWrapper == null) {
                allFavoriteWrapper = tempFavoriteWrapper;
            } else {
                List<Favorite> allFavorites = allFavoriteWrapper.getFavorites();
                List<Favorite> tempFavorites = tempFavoriteWrapper.getFavorites();
                allFavorites.addAll(tempFavorites);
                allFavoriteWrapper.setFavorites(allFavorites);
                allFavoriteWrapper.setTotalNumber(tempFavoriteWrapper.getTotalNumber());
            }
            allFavoriteWrapper.setExtraAttributes(tempFavoriteWrapper.getExtraAttributes());
            sPageTime = tempFavoriteWrapper.getExtraAttributeAsString("nexttime");
            sLastId = tempFavoriteWrapper.getExtraAttributeAsString("lastId");
            if (tempFavoriteWrapper.getExtraAttributeAsInt("hasnext", 1) == 1) break;
        }
        return allFavoriteWrapper;
    }

    private void reSetCache() throws CMyException {
        String sAccessToken = this.m_oTencentOAuth.getAccessToken();
        CMyDateTime oLastRefreshedTime = CMyDateTime.now().dateAdd(5, -2);
        if (m_oLastRefreshDate != null) {
            m_oLastRefreshDate.put(sAccessToken, oLastRefreshedTime);
        }
        if (m_OAuthFavoriteMap != null) {
            m_OAuthFavoriteMap.put(sAccessToken, null);
        }
    }
}

