/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scene.tools;

import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.scene.tools.SceneNode;
import com.trs.scene.tools.SceneNodeAction;
import com.trs.scene.tools.SceneNodeParser;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class SceneNodeToXML {
    public static String toXML(SceneNode _rootSceneNode) throws Exception {
        Element graphModel = DocumentHelper.createElement((String)"FDGraphModel");
        Element root = graphModel.addElement("root");
        SceneNodeToXML.addDefaultContent(root);
        SceneNodeToXML.createNodeXMLNode(root, _rootSceneNode, false);
        SceneNodeToXML.createNodeXMLNode(root, _rootSceneNode, true);
        return SceneNodeToXML.format(graphModel);
    }

    private static void createNodeXMLNode(Element _rootXMLNode, SceneNode _sceneNode, boolean _bIsNode) throws Exception {
        ArrayList arChildrenSceneNode = _sceneNode.getChildren();
        if (arChildrenSceneNode == null || arChildrenSceneNode.isEmpty()) {
            if (_bIsNode) {
                SceneNodeToXML.createOnlyShape(_rootXMLNode, _sceneNode);
            }
            return;
        }
        if (_bIsNode) {
            SceneNodeToXML.createOnlyRect(_rootXMLNode, _sceneNode);
        }
        int nSize = arChildrenSceneNode.size();
        for (int i = 0; i < nSize; ++i) {
            ArrayList arChildren;
            SceneNode sceneNode = (SceneNode)arChildrenSceneNode.get(i);
            if (!_bIsNode) {
                SceneNodeToXML.createOnlyConnector(_rootXMLNode, sceneNode);
            }
            if ((arChildren = sceneNode.getChildren()) == null || arChildren.isEmpty()) continue;
            SceneNodeToXML.createNodeXMLNode(_rootXMLNode, (SceneNode)arChildren.get(0), _bIsNode);
        }
    }

    private static void createOnlyConnector(Element _rootXMLNode, SceneNode _sceneNode) throws Exception {
        if (_sceneNode == null) {
            return;
        }
        if (_sceneNode.getType() != 3) {
            throw new Exception("\u6307\u5b9a\u7684\u8282\u70b9[" + _sceneNode + "]\u4e0d\u662f\u8fde\u7ebf");
        }
        Element connector = _rootXMLNode.addElement("Connector");
        connector.addAttribute("label", _sceneNode.getName());
        connector.addAttribute("id", String.valueOf(_sceneNode.getId()));
        connector.addAttribute("condition", "");
        Element cell = connector.addElement("FDCell");
        cell.addAttribute("edge", "1");
        cell.addAttribute("parent", "1");
        cell.addAttribute("source", String.valueOf(_sceneNode.getParentId()));
        int nFirstChildId = _sceneNode.getFirstChildId();
        if (nFirstChildId > 0) {
            cell.addAttribute("target", String.valueOf(_sceneNode.getFirstChildId()));
        }
        Element geometry = cell.addElement("FDGeometry");
        geometry.addAttribute("relative", "1");
        geometry.addAttribute("as", "geometry");
        if (nFirstChildId <= 0) {
            Element point = geometry.addElement("FDPoint");
            point.addAttribute("x", String.valueOf(_sceneNode.getPositionX()));
            point.addAttribute("y", String.valueOf(_sceneNode.getPositionY()));
            point.addAttribute("as", "targetPoint");
        }
    }

    private static void createOnlyRect(Element _rootXMLNode, SceneNode _sceneNode) {
        Element rect = _rootXMLNode.addElement("Rect");
        rect.addAttribute("label", _sceneNode.getName());
        rect.addAttribute("id", String.valueOf(_sceneNode.getId()));
        Element cell = rect.addElement("FDCell");
        cell.addAttribute("vertex", "1");
        cell.addAttribute("parent", "1");
        Element geometry = cell.addElement("FDGeometry");
        geometry.addAttribute("x", String.valueOf(_sceneNode.getPositionX()));
        geometry.addAttribute("y", String.valueOf(_sceneNode.getPositionY()));
        geometry.addAttribute("width", String.valueOf(80));
        geometry.addAttribute("height", String.valueOf(40));
        geometry.addAttribute("as", "geometry");
    }

    private static void createOnlyShape(Element _rootXMLNode, SceneNode _sceneNode) {
        Element rect = _rootXMLNode.addElement("Shape");
        rect.addAttribute("label", _sceneNode.getName());
        rect.addAttribute("id", String.valueOf(_sceneNode.getId()));
        Element cell = rect.addElement("FDCell");
        cell.addAttribute("style", "doubleEllipse");
        cell.addAttribute("vertex", "1");
        cell.addAttribute("parent", "1");
        Element geometry = cell.addElement("FDGeometry");
        geometry.addAttribute("x", String.valueOf(_sceneNode.getPositionX()));
        geometry.addAttribute("y", String.valueOf(_sceneNode.getPositionY()));
        geometry.addAttribute("width", "60");
        geometry.addAttribute("height", "60");
        geometry.addAttribute("as", "geometry");
    }

    private static void addDefaultContent(Element _root) {
        Element diargram = _root.addElement("Diagram");
        diargram.addAttribute("label", "\u81ea\u52a8\u4ea7\u751fDiagram");
        diargram.addAttribute("id", "0");
        diargram.addElement("FDCell");
        Element layer = _root.addElement("Layer");
        layer.addAttribute("label", "\u81ea\u52a8\u4ea7\u751fLayer");
        layer.addAttribute("id", "1");
        layer.addElement("FDCell").addAttribute("parent", "0");
    }

    public static String format(Element element) {
        StringWriter writer = new StringWriter();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("GBK");
        XMLWriter xmlwriter = new XMLWriter((Writer)writer, format);
        try {
            xmlwriter.write(element);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    public static void main(String[] args) {
        String sPath = "c:\\\u573a\u666f\u5f0f\u670d\u52a1\u6279\u91cf\u521b\u5efa\\";
        try {
            FileService filePath = new FileService(sPath);
            FileStore[] pFiles = filePath.listFiles();
            for (int i = 0; i < pFiles.length; ++i) {
                int nStartPos;
                FileStore file = pFiles[i];
                String sFileName = file.getName();
                int nEndPos = sFileName.indexOf(46, nStartPos = sFileName.lastIndexOf(File.separatorChar));
                if (nEndPos < 0) continue;
                SceneNodeParser util = new SceneNodeParser();
                SceneNode rootNode = util.importFormFileByName(file.getAbsolutePath());
                SceneNodeAction nodeAction = new SceneNodeAction(rootNode);
                nodeAction.confirmPosition(rootNode);
                System.out.println(SceneNodeToXML.toXML(rootNode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

