/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.locale;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.customize.UserSetting;
import com.trs.components.wcm.customize.UserSettings;
import com.trs.infra.BaseServer;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.presentation.locale.LocaleDefinitions;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public final class LocaleServer
extends BaseServer {
    private static final int FAVOR_LOCALE_IDENTY = -10000;
    private static final String BUNDLE_BASENAME = "locale.presentation";
    private static Map m_allBundles;
    private static Map m_allLocales;
    private static Map m_cachedFavorLocales;

    @Override
    protected void doShutdown() {
    }

    @Override
    protected boolean doStart() throws WCMException {
        this.loadBundlesAndLocales();
        this.cacheFavorLocaleSetting();
        Locale.setDefault(Locale.CHINA);
        return true;
    }

    public static String getString(String _sKey, String _sDefaultValue) {
        try {
            String rst = LocaleServer.getServer().getBundle().getString(_sKey);
            return new String(rst.getBytes("8859_1"), "GBK");
        }
        catch (MissingResourceException e) {
            return _sDefaultValue;
        }
        catch (UnsupportedEncodingException e) {
            return _sDefaultValue;
        }
        catch (Exception e) {
            return _sDefaultValue;
        }
    }

    public static CMyDateTime getDateTime(String _sKey) {
        CMyDateTime dateTime = CMyDateTime.now();
        try {
            dateTime.setDateTimeWithString(LocaleServer.getServer().getBundle().getString(_sKey), "yyyy-MM-dd");
            return dateTime;
        }
        catch (Exception e) {
            return dateTime;
        }
    }

    public static Locale getCurrentLocale() {
        return LocaleServer.getServer().getFavorLocale();
    }

    public static void setFavorLanguage(User _currUser, String _sLanguageKey) throws WCMException {
        Locale locale = LocaleServer.getServer().getLoaleByLanguageKey(_sLanguageKey);
        LocaleServer.setFavorLocale(_currUser, locale);
    }

    public static void setFavorLocale(User _currUser, Locale _locale) throws WCMException {
        LocaleServer.getServer().deleteLocaleSettingIfExists(_currUser);
        LocaleServer.getServer().saveFavorLocaleSetting(_currUser, _locale);
        LocaleServer.getServer().refreshFavorLocaleCached(_currUser, _locale);
    }

    public static String getFavorLanguageKey() {
        return LocaleServer.getServer().getFavorLocale().toString();
    }

    public static String[] getLanguageKeys() {
        LocaleServer.getServer();
        Object[] keys = m_allLocales.keySet().toArray();
        String[] result = new String[keys.length - 1];
        for (int i = 0; i < result.length; ++i) {
            String tmp = (String)keys[i];
            if (tmp.length() == 0) continue;
            result[i] = tmp;
        }
        return result;
    }

    private Locale getLoaleByLanguageKey(String _sLanguageKey) {
        return (Locale)m_allLocales.get(_sLanguageKey);
    }

    private void loadBundlesAndLocales() {
        LocaleDefinitions ldfs = new LocaleDefinitions();
        Map locales = ldfs.caculateLocales();
        m_allBundles = new HashMap(locales.size());
        m_allLocales = new HashMap(locales.size());
        Set keys = locales.keySet();
        ResourceBundle bundle = null;
        for (String localeDef : keys) {
            Locale locale = (Locale)locales.get(localeDef);
            m_allLocales.put(locale.toString(), locale);
            bundle = ResourceBundle.getBundle(BUNDLE_BASENAME, locale);
            m_allBundles.put(locale, bundle);
        }
    }

    private void cacheFavorLocaleSetting() throws WCMException {
        UserSettings faveorLocaleSettings = this.findFavorLocaleSettings();
        m_cachedFavorLocales = new HashMap(faveorLocaleSettings.size());
        UserSetting userSetting = null;
        for (int i = 0; i < faveorLocaleSettings.size(); ++i) {
            userSetting = (UserSetting)faveorLocaleSettings.getAt(i);
            if (userSetting == null) continue;
            User owner = userSetting.getOwner();
            String sValue = userSetting.getValue();
            Locale locale = (Locale)m_allLocales.get(sValue);
            if (owner == null) continue;
            m_cachedFavorLocales.put(owner.getKey(), locale);
        }
    }

    private UserSettings findFavorLocaleSettings() throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "ObjType=-10000", "");
        UserSettings localeSettings = UserSettings.openWCMObjs(User.getSystem(), aFilter);
        return localeSettings;
    }

    private void deleteLocaleSettingIfExists(User _currUser) throws WCMException {
        String sSQL = "DELETE FROM WCMUserSetting WHERE UserId=" + _currUser.getId() + " AND ObjType=" + -10000;
        DBManager.getDBManager().sqlExecuteUpdate(sSQL);
    }

    private void saveFavorLocaleSetting(User _currUser, Locale _locale) throws WCMException {
        UserSetting setting = UserSetting.createNewInstance();
        setting.setObjId(10000);
        setting.setObjType(-10000);
        setting.setValue(_locale.toString());
        setting.setUser(_currUser);
        setting.insert(_currUser);
    }

    private void refreshFavorLocaleCached(User _currUser, Locale _locale) {
        m_cachedFavorLocales.put(_currUser.getKey(), _locale);
    }

    private ResourceBundle getBundle() {
        return (ResourceBundle)m_allBundles.get(this.getFavorLocale());
    }

    private Locale getFavorLocale() {
        Locale locale = null;
        try {
            User currUser = ContextHelper.getLoginUser();
            locale = (Locale)m_cachedFavorLocales.get(currUser.getKey());
        }
        catch (Exception e) {
            locale = Locale.getDefault();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private static LocaleServer getServer() {
        LocaleServer aServer = (LocaleServer)DreamFactory.createObjectById("LocaleServer");
        if (!aServer.isStarted()) {
            aServer.startup();
        }
        return aServer;
    }
}

