/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.jsputil;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class JspChecker {
    private static int RESPONSECODE_OK = 200;
    private static List _jsps = new ArrayList();
    private String m_sLocalJSPRootPath;
    private String m_sAppHost = "localhost";
    private int m_nAppPort = 80;
    private String _cookie;
    private String _username;
    private String _password;
    private String _authPage = "/j_security_check";
    protected Logger _logger = Logger.getLogger(this.getClass());
    private boolean _needStore = false;
    private String m_sAppName = "wcm";
    String[] aSubPath = null;
    String[] aJspIncludeFiles = null;

    public JspChecker(String _sJSPRootPath, String _sAppName) {
        this.m_sLocalJSPRootPath = CMyString.setStrEndWith(_sJSPRootPath, File.separatorChar);
        this.m_sAppName = _sAppName;
    }

    public void setSubPath(String[] _aSubPath) {
        this.aSubPath = _aSubPath;
    }

    public void setJspIncludeFiles(String[] _jspIncludeFiles) {
        this.aJspIncludeFiles = _jspIncludeFiles;
    }

    public JspChecker(String _sJSPRootPath, String _sAppName, String host, int port) {
        this.m_sLocalJSPRootPath = CMyString.setStrEndWith(_sJSPRootPath, File.separatorChar);
        this.m_sAppName = _sAppName;
        this.m_sAppHost = host;
        this.m_nAppPort = port;
    }

    public void setAuthDetail(String username, String password, String authPage) {
        this._username = username;
        this._password = password;
        this._authPage = authPage;
    }

    public void setResult(boolean needStore) {
        this._needStore = needStore;
    }

    public void run() {
        this._logger.info((Object)"loading jsp file source...");
        _jsps.clear();
        List jsps = null;
        if (this.aSubPath != null && this.aSubPath.length > 0) {
            for (int i = 0; i < this.aSubPath.length; ++i) {
                jsps = this.loadJsps(this.m_sLocalJSPRootPath + "app" + File.separatorChar + this.aSubPath[i] + File.separatorChar);
            }
        } else {
            jsps = this.loadJsps(this.m_sLocalJSPRootPath);
        }
        this._logger.info((Object)"loaded,checking the files...");
        try {
            this._cookie = this.getCookie();
            this._logger.debug((Object)this._cookie);
        }
        catch (Exception e) {
            this._logger.error((Object)"Connect failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        int numBad = 0;
        ArrayList<String> badJsps = new ArrayList<String>();
        for (int i = 0; i < jsps.size(); ++i) {
            String file = null;
            try {
                file = (String)jsps.get(i);
                int respCode = this.getResponseCodeForHttp("/" + this.m_sAppName + "/" + file);
                if (respCode == RESPONSECODE_OK) continue;
                this._logger.info((Object)("Error: " + file + "---RespCode=" + respCode));
                badJsps.add(file);
                ++numBad;
                continue;
            }
            catch (Exception e) {
                this._logger.error((Object)("Error: " + file), (Throwable)e);
                badJsps.add(file);
                ++numBad;
            }
        }
        this._logger.info((Object)"============ done!");
        try {
            this.storeBadJsps(badJsps);
        }
        catch (Exception e) {
            this._logger.error((Object)"produce a summary file failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean isInJspIncludeFile(String sFileFullName) {
        for (int i = 0; i < this.aJspIncludeFiles.length; ++i) {
            if (sFileFullName.indexOf(this.aJspIncludeFiles[i]) < 0) continue;
            return true;
        }
        return false;
    }

    private List loadJsps(String jsprooturi) {
        FileService file = new FileService(jsprooturi);
        FileStore[] files = file.listFiles();
        FileStore tmp = null;
        for (int i = 0; i < files.length; ++i) {
            tmp = files[i];
            if (tmp.isDirectory()) {
                this.loadJsps(tmp.getPath());
                continue;
            }
            if (!tmp.getName().endsWith("jsp") || this.isInJspIncludeFile(tmp.getAbsolutePath())) continue;
            String path = tmp.getPath();
            int nPos = path.indexOf(this.m_sLocalJSPRootPath);
            if (nPos < 0) {
                System.err.println("\u6307\u5b9a\u7684\u76ee\u5f55\u548cFile.getPath\u89c4\u5219\u4e0d\u4e00\u6837\uff1f[Root=" + this.m_sLocalJSPRootPath + ", CurrPath=" + tmp.getPath() + "]");
                continue;
            }
            path = path.substring(this.m_sLocalJSPRootPath.length());
            path = CMyString.replaceStr(path, "\\", "/");
            _jsps.add(path);
        }
        return _jsps;
    }

    private String getCookie() throws Exception {
        String cookieLine = null;
        Socket socket = new Socket(this.m_sAppHost, this.m_nAppPort);
        PrintWriter out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
        String target = this._authPage;
        out.print("POST " + target + " HTTP/1.0\r\n");
        out.print("Connection: close\r\n");
        out.print("Host: " + this.m_sAppHost + "\r\n");
        out.print("ContentTypeConfig-type: application/x-www-form-urlencoded\r\n");
        String postString = "j_username=" + this._username + "&j_password=" + this._password;
        out.print("ContentTypeConfig-length: " + postString.length() + "\r\n");
        out.print("\r\n");
        out.print(postString + "\r\n");
        out.print("\r\n");
        out.flush();
        BufferedReader buffreader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        String line = null;
        while ((line = buffreader.readLine()) != null) {
            this._logger.debug((Object)line);
            if (line.trim().length() == 0) break;
            if (!line.toLowerCase().startsWith("set-cookie:")) continue;
            cookieLine = line.substring("Set-Cookie:".length()).trim();
            int semicolon = cookieLine.indexOf(";");
            if (semicolon == -1) break;
            cookieLine = cookieLine.substring(0, semicolon).trim();
            break;
        }
        buffreader.close();
        out.close();
        socket.close();
        return cookieLine;
    }

    protected int getResponseCode(String file) throws Exception {
        int respCode = -1;
        Socket s = new Socket(this.m_sAppHost, this.m_nAppPort);
        PrintWriter out = new PrintWriter(new OutputStreamWriter(s.getOutputStream()));
        String target = file + "?jsp_precompile=true";
        out.print("GET " + target + " HTTP/1.0\r\n");
        out.print("Cookie: " + this._cookie + "\r\n");
        out.print("Connection: close\r\n");
        out.print("Host: " + this.m_sAppHost + "\r\n");
        out.print("\r\n");
        out.flush();
        BufferedReader buffreader = new BufferedReader(new InputStreamReader(s.getInputStream()));
        String line = buffreader.readLine();
        if (line != null) {
            StringTokenizer st = new StringTokenizer(line.trim());
            st.nextToken();
            respCode = Integer.parseInt(st.nextToken());
        }
        while ((line = buffreader.readLine()) != null && line.trim().length() != 0) {
        }
        StringBuffer buf = new StringBuffer();
        while ((line = buffreader.readLine()) != null) {
            buf.append(line).append("\n");
        }
        buffreader.close();
        out.close();
        s.close();
        return respCode;
    }

    private void storeBadJsps(List badJsps) throws Exception {
        if (this._needStore) {
            this._logger.info((Object)"creating summary file:badjsps.xml");
            String result = "./badjsps.txt";
            StringBuffer sbContent = new StringBuffer();
            sbContent.append("amount of badjsps:" + badJsps.size() + "\n");
            for (int i = 0; i < badJsps.size(); ++i) {
                sbContent.append((String)badJsps.get(i));
                sbContent.append("\n");
            }
            CMyFile.writeFile(result, sbContent.toString());
            this._logger.info((Object)"done,you can check the summary file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getResponseCodeForHttp(String file) throws Exception {
        HttpURLConnection urlconn = null;
        try {
            int respCode;
            String target = file + "?jsp_precompile=true";
            URL url = new URL("http", this.m_sAppHost, this.m_nAppPort, target);
            urlconn = (HttpURLConnection)url.openConnection();
            urlconn.connect();
            int n = respCode = urlconn.getResponseCode();
            return n;
        }
        finally {
            try {
                if (urlconn != null) {
                    urlconn.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }
}

