/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.dbcompare;

import com.trs.infra.util.upgrade.dbcompare.Column;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;

public class Table {
    public static final char ESCAPE_CHAR = '\"';
    private String tableName;
    private String[] primaryKey;
    private Map columns;

    public Table(String tableName) {
        this(tableName, null);
    }

    public Table(String tableName, String[] primaryKey) {
        this.tableName = tableName;
        this.primaryKey = primaryKey;
        this.columns = new HashMap(20, 0.5f);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String[] getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String[] primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Map getColumns() {
        return this.columns;
    }

    public void setColumns(SortedMap columns) {
        this.columns = columns;
    }

    public void addColumn(Column column) {
        if (column != null) {
            this.columns.put(column.name, column);
        }
    }

    public void removeColumn(Column column) {
        if (column != null) {
            this.columns.remove(column.name);
        }
    }

    public String toString() {
        int i;
        StringBuffer buff = new StringBuffer(128);
        buff.append("create table ");
        buff.append('\"');
        buff.append(this.tableName);
        buff.append('\"');
        buff.append(" (\n");
        Object[] cols = this.columns.values().toArray();
        Arrays.sort(cols, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Column col0 = (Column)arg0;
                Column col1 = (Column)arg1;
                return col0.order - col1.order;
            }
        });
        buff.append('\t').append(cols[0]);
        int len = cols.length;
        for (i = 1; i < len; ++i) {
            Column column = (Column)cols[i];
            buff.append(",\n");
            buff.append('\t').append(column);
        }
        if (this.primaryKey != null && this.primaryKey.length > 0) {
            buff.append(",\n\tprimary key(");
            len = this.primaryKey.length;
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    buff.append(',');
                }
                buff.append('\"');
                buff.append(this.primaryKey[i]);
                buff.append('\"');
            }
            buff.append(')');
        }
        buff.append("\n)");
        return buff.toString();
    }
}

