/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.uftp;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.uftp.ChainList;
import com.trs.infra.util.uftp.FtpConfig;
import com.trs.infra.util.uftp.FtpConnection;
import com.trs.infra.util.uftp.FtpConnectionImpFtp;
import com.trs.infra.util.uftp.FtpConnectionImpSSH;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class FtpConnectionCache
implements IClearable {
    private static Logger s_logger = Logger.getLogger(FtpConnectionCache.class);
    private static final int UPLOAD_RETRY_TIMES = 6;
    private boolean m_zRuning = false;
    private boolean m_zStoped = false;
    private Keeper m_oKeeper = null;
    private Object m_objectSync;
    private ChainList m_oQueueBusy;
    private ChainList m_oQueueIdle;
    private Vector m_oVectorAll;
    private FtpConfig m_oFtpConfig;
    private HashMap m_oUploading;

    public static final boolean verifyConfig(FtpConfig ftpConfig, String[] forReturn) {
        if (ftpConfig == null) {
            throw new IllegalArgumentException("Argument 'FtpConfig' is null.");
        }
        if (forReturn == null || forReturn.length < 1) {
            throw new IllegalArgumentException("Argument 'String[]' is null.");
        }
        try {
            FtpConnection conn = FtpConnectionCache.createConnection(ftpConfig.getProtocol());
            conn.setConfig(ftpConfig);
            forReturn[0] = conn.verifyConfig();
        }
        catch (IllegalArgumentException e) {
            forReturn[0] = I18NMessage.get(FtpConnectionCache.class, "FtpConnectionCache.label1", "\u4e0d\u652f\u6301\u7684\u7f51\u7edc\u534f\u8bae");
        }
        return forReturn[0] == null;
    }

    private static final FtpConnection createConnection(String sProtocol) {
        if ("FTP".equals(sProtocol)) {
            return new FtpConnectionImpFtp();
        }
        if ("FTPS".equals(sProtocol)) {
            // empty if block
        }
        if ("SFTP".equals(sProtocol)) {
            return new FtpConnectionImpSSH();
        }
        if ("GFTP".equals(sProtocol)) {
            // empty if block
        }
        throw new IllegalArgumentException("Not supported protocol:" + sProtocol);
    }

    public FtpConnectionCache(FtpConfig config) {
        this.m_oFtpConfig = config;
        this.m_objectSync = new Object();
        this.m_oQueueBusy = new ChainList();
        this.m_oQueueIdle = new ChainList();
        this.m_oVectorAll = new Vector();
        this.m_oUploading = new HashMap();
    }

    public FtpConfig getFtpConfig() {
        return this.m_oFtpConfig;
    }

    public void initialize() {
        if (this.m_oKeeper != null) {
            return;
        }
        this.m_oKeeper = new Keeper();
        this.m_oKeeper.start();
        this.m_zRuning = true;
    }

    public void clear() {
        if (this.m_oKeeper == null) {
            return;
        }
        this.m_oKeeper.terminate();
        this.m_oKeeper = null;
        this.m_zRuning = false;
        this.m_zStoped = true;
        for (int i = this.m_oVectorAll.size() - 1; i >= 0; --i) {
            try {
                this.destroyConnection((FtpConnection)this.m_oVectorAll.elementAt(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_oUploading.clear();
    }

    private FtpConnection assignConnection() throws Exception {
        if (this.m_zStoped) {
            throw new IllegalStateException("FtpConnectionCache closed.");
        }
        FtpConnection conn = (FtpConnection)this.m_oQueueIdle.get();
        if (conn != null) {
            this.m_oQueueBusy.put(conn);
            return conn;
        }
        while (this.getTotalCount() < this.getLimitCount()) {
            this.createConnection();
            conn = (FtpConnection)this.m_oQueueIdle.get();
            if (conn == null) continue;
            this.m_oQueueBusy.put(conn);
            return conn;
        }
        for (int i = 0; i < 100; ++i) {
            conn = (FtpConnection)this.m_oQueueIdle.get();
            if (conn != null) {
                this.m_oQueueBusy.put(conn);
                return conn;
            }
            this.waitforConnection();
        }
        throw new IllegalStateException("Too bufy, no idle connection.");
    }

    private void recycleConnection(FtpConnection conn) {
        if (this.m_zRuning) {
            try {
                conn.toHomeDirectory();
                conn.cutFromList();
                conn.setIdleTimestamp();
                this.m_oQueueIdle.put(conn);
                this.notifyConnection();
                return;
            }
            catch (Exception e) {
                s_logger.info((Object)"FtpConnectionCache.recycleConnection():toHomeDirectory():error", (Throwable)e);
            }
        }
        this.destroyConnection(conn);
    }

    private void createConnection() throws Exception {
        FtpConnection conn = FtpConnectionCache.createConnection(this.m_oFtpConfig.getProtocol());
        conn.setConfig(this.m_oFtpConfig);
        conn.open();
        this.m_oVectorAll.addElement(conn);
        this.m_oQueueIdle.put(conn);
        this.notifyConnection();
    }

    private void destroyConnection(FtpConnection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        conn.setConfig(null);
        conn.cutFromList();
        this.m_oVectorAll.removeElement(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConnection() {
        Object object = this.m_objectSync;
        synchronized (object) {
            try {
                this.m_objectSync.notify();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitforConnection() {
        Object object = this.m_objectSync;
        synchronized (object) {
            try {
                this.m_objectSync.wait(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean verifyConnection(FtpConnection conn) {
        block6: {
            if (conn == null) {
                return false;
            }
            if (conn.getIdleTimemills() < this.m_oFtpConfig.getMaxIdleMills()) {
                try {
                    conn.onIdle();
                    return true;
                }
                catch (Exception e) {
                    if (!s_logger.isDebugEnabled()) break block6;
                    try {
                        FtpConfig config = conn.getFtpConfig();
                        s_logger.info((Object)"onIdle():error");
                        s_logger.info((Object)("FTPInfo:" + config));
                        s_logger.info((Object)"exception:", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        this.destroyConnection(conn);
        return false;
    }

    public FtpConnection getConnectionWrapper() {
        return new Wrapper();
    }

    public int getBusyCount() {
        return this.m_oQueueBusy.size();
    }

    public int getIdleCount() {
        return this.m_oQueueIdle.size();
    }

    public int getLimitCount() {
        return this.m_oFtpConfig.getMaxClient();
    }

    public int getTotalCount() {
        return this.m_oVectorAll.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append("FtpConnectionCache ");
        sb.append('(');
        sb.append(this.m_oFtpConfig);
        sb.append(')');
        sb.append(", idle=");
        sb.append(this.m_oQueueIdle.size());
        sb.append(", busy=");
        sb.append(this.m_oQueueBusy.size());
        sb.append(", total=");
        sb.append(this.m_oVectorAll.size());
        sb.append(", max=");
        sb.append(this.m_oFtpConfig.getMaxClient());
        return sb.toString();
    }

    private synchronized boolean testAndRegister(String sFileName) {
        if (sFileName == null) {
            return false;
        }
        if (this.m_oUploading.get(sFileName) != null) {
            return false;
        }
        this.m_oUploading.put(sFileName, sFileName);
        return true;
    }

    private synchronized void unregister(String sFileName) {
        if (sFileName == null) {
            return;
        }
        this.m_oUploading.remove(sFileName);
    }

    private class Wrapper
    extends FtpConnection {
        private Wrapper() {
        }

        @Override
        protected String verifyConfig() {
            return null;
        }

        @Override
        protected void open() throws Exception {
        }

        @Override
        protected void close() {
        }

        @Override
        protected void toHomeDirectory() throws Exception {
        }

        @Override
        public void onIdle() throws Exception {
        }

        @Override
        public FtpConfig getFtpConfig() {
            return FtpConnectionCache.this.m_oFtpConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() throws Exception {
            boolean zResult = false;
            Exception onError = null;
            FtpConnection ftpConn = null;
            try {
                ftpConn = FtpConnectionCache.this.assignConnection();
                zResult = ftpConn.isReadOnly();
            }
            catch (Exception e) {
                onError = e;
                s_logger.error((Object)"FtpConnectionCache.Wrapper():isReadOnly():error", (Throwable)e);
            }
            finally {
                if (ftpConn != null) {
                    if (onError != null) {
                        FtpConnectionCache.this.destroyConnection(ftpConn);
                    } else {
                        FtpConnectionCache.this.recycleConnection(ftpConn);
                    }
                }
            }
            if (onError != null) {
                throw onError;
            }
            return zResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean deleteDirectory(String sPath) throws Exception {
            boolean zResult = false;
            Exception onError = null;
            FtpConnection ftpConn = null;
            try {
                ftpConn = FtpConnectionCache.this.assignConnection();
                zResult = ftpConn.deleteDirectory(sPath);
            }
            catch (Exception e) {
                onError = e;
                s_logger.error((Object)"FtpConnectionCache.Wrapper():deleteDirectory():error", (Throwable)e);
            }
            finally {
                if (ftpConn != null) {
                    if (onError != null) {
                        FtpConnectionCache.this.destroyConnection(ftpConn);
                    } else {
                        FtpConnectionCache.this.recycleConnection(ftpConn);
                    }
                }
            }
            if (onError != null) {
                throw onError;
            }
            return zResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean deleteFile(String sPath) throws Exception {
            boolean zResult = false;
            Exception onError = null;
            FtpConnection ftpConn = null;
            try {
                ftpConn = FtpConnectionCache.this.assignConnection();
                zResult = ftpConn.deleteFile(sPath);
            }
            catch (Exception e) {
                onError = e;
                s_logger.error((Object)"FtpConnectionCache.Wrapper():deleteFile():error", (Throwable)e);
            }
            finally {
                if (ftpConn != null) {
                    if (onError != null) {
                        FtpConnectionCache.this.destroyConnection(ftpConn);
                    } else {
                        FtpConnectionCache.this.recycleConnection(ftpConn);
                    }
                }
            }
            if (onError != null) {
                throw onError;
            }
            return zResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean renameFile(String sSourcePath, String sTargetFile) throws Exception {
            boolean zResult = false;
            Exception onError = null;
            FtpConnection ftpConn = null;
            try {
                ftpConn = FtpConnectionCache.this.assignConnection();
                zResult = ftpConn.renameFile(sSourcePath, sTargetFile);
            }
            catch (Exception e) {
                onError = e;
                s_logger.error((Object)"FtpConnectionCache.Wrapper():deleteFile():error", (Throwable)e);
            }
            finally {
                if (ftpConn != null) {
                    if (onError != null) {
                        FtpConnectionCache.this.destroyConnection(ftpConn);
                    } else {
                        FtpConnectionCache.this.recycleConnection(ftpConn);
                    }
                }
            }
            if (onError != null) {
                throw onError;
            }
            return zResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toAbsolutePath(String sRelativePath) throws Exception {
            String sResult = null;
            Exception onError = null;
            FtpConnection ftpConn = null;
            try {
                ftpConn = FtpConnectionCache.this.assignConnection();
                sResult = ftpConn.toAbsolutePath(sRelativePath);
            }
            catch (Exception e) {
                onError = e;
                s_logger.error((Object)"FtpConnectionCache.Wrapper():toAbsolutePath():error", (Throwable)e);
            }
            finally {
                if (ftpConn != null) {
                    if (onError != null) {
                        FtpConnectionCache.this.destroyConnection(ftpConn);
                    } else {
                        FtpConnectionCache.this.recycleConnection(ftpConn);
                    }
                }
            }
            if (onError != null) {
                throw onError;
            }
            return sResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean uploadFile(String sLocal, String sRemote) throws Exception {
            if (!FtpConnectionCache.this.testAndRegister(sRemote)) {
                return true;
            }
            boolean zResult = false;
            Exception onError = null;
            FtpConnection ftpConn = null;
            try {
                for (int iRetryCount = 0; iRetryCount <= 6; ++iRetryCount) {
                    if (iRetryCount > 0) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        onError = null;
                        ftpConn = FtpConnectionCache.this.assignConnection();
                        zResult = ftpConn.uploadFile(sLocal, sRemote);
                        if (!zResult) continue;
                        iRetryCount = 7;
                        continue;
                    }
                    catch (Exception e) {
                        onError = e;
                        s_logger.error((Object)"FtpConnectionCache.Wrapper():uploadFile():error", (Throwable)e);
                        continue;
                    }
                    finally {
                        if (ftpConn != null) {
                            if (onError != null) {
                                FtpConnectionCache.this.destroyConnection(ftpConn);
                            } else {
                                FtpConnectionCache.this.recycleConnection(ftpConn);
                            }
                        }
                    }
                }
            }
            finally {
                FtpConnectionCache.this.unregister(sRemote);
            }
            if (onError != null) {
                throw onError;
            }
            return zResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasTheFile(String sPath) throws Exception {
            boolean zResult = false;
            Exception onError = null;
            FtpConnection ftpConn = null;
            try {
                ftpConn = FtpConnectionCache.this.assignConnection();
                zResult = ftpConn.hasTheFile(sPath);
            }
            catch (Exception e) {
                onError = e;
                s_logger.error((Object)"FtpConnectionCache.Wrapper():hasTheFile():error", (Throwable)e);
            }
            finally {
                if (ftpConn != null) {
                    if (onError != null) {
                        FtpConnectionCache.this.destroyConnection(ftpConn);
                    } else {
                        FtpConnectionCache.this.recycleConnection(ftpConn);
                    }
                }
            }
            if (onError != null) {
                throw onError;
            }
            return zResult;
        }
    }

    private class Keeper
    extends Thread {
        private boolean m_zContinue;

        public Keeper() {
            super("FtpConnectionCache$Keeper");
            this.m_zContinue = true;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"FtpConnectionCache.Keeper():start");
            }
            while (this.m_zContinue) {
                FtpConnection conn;
                try {
                    Thread.sleep(60000L);
                }
                catch (Exception e) {
                    s_logger.error((Object)"FtpConnectionCache.Keeper():Thread.sleep():error", (Throwable)e);
                }
                if (!this.m_zContinue) break;
                for (int i = FtpConnectionCache.this.m_oQueueIdle.size(); i > 0 && (conn = (FtpConnection)FtpConnectionCache.this.m_oQueueIdle.get()) != null && this.m_zContinue; --i) {
                    if (!FtpConnectionCache.this.verifyConnection(conn)) continue;
                    FtpConnectionCache.this.m_oQueueIdle.put(conn);
                }
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"FtpConnectionCache.Keeper():terminate");
            }
        }

        void terminate() {
            this.m_zContinue = false;
        }
    }
}

