/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.COracleCLOB;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DataType;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.CLOB;

public class OracleDB
extends DBType {
    public static final DataType CHAR = new DataType("CHAR", 1, -4000);
    public static final DataType VARCHAR2 = new DataType("VARCHAR2", 12, -4000);
    public static final DataType NUMBER = new DataType("NUMBER", 2, -38);
    public static final DataType INT = new DataType("INT", 4, -9);
    public static final DataType SMALLINT = new DataType("SMALLINT", 5, -2);
    public static final DataType FLOAT = new DataType("FLOAT", 6, -38);
    public static final DataType NVARCHAR = new DataType("NVARCHAR", 12, -4000);
    public static final DataType LONG = new DataType("LONG", -1);
    public static final DataType ROWID = new DataType("ROWID", -2);
    public static final DataType DATE = new DataType("DATE", 93, 8);
    public static final DataType DATETIME = new DataType("DATETIME", 93);
    public static final DataType RAW = new DataType("RAW", -3);
    public static final DataType LONGRAW = new DataType("LONGRAW", -4);
    public static final DataType CLOB = new DataType("CLOB", 2005);
    public static final DataType BLOB = new DataType("BLOB", 2004);
    public static final DataType NCLOB = new DataType("NCLOB", 2005);
    public static final DataType BFILE = new DataType("BFILE", -4);
    private static final DataType[] m_allDataTypes = new DataType[]{CHAR, VARCHAR2, NUMBER, LONG, ROWID, DATE, RAW, LONGRAW, CLOB, BLOB, NCLOB, BFILE, INT, FLOAT, DATETIME, NVARCHAR, SMALLINT};
    static final DataType[] m_supportedDataTypes = new DataType[]{NUMBER, VARCHAR2, CLOB, DATE};

    public OracleDB() {
        super("Oracle", "oracle.jdbc.driver.OracleDriver", true);
    }

    public OracleDB(String _sName, String _sDriverClass) {
        super(_sName, _sDriverClass, true);
    }

    @Override
    protected void registerDBInfo() {
        this.registerColumnType(93, "date");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, 4000, "varchar2($l)");
        this.registerColumnType(-7, "number(1,0)");
        this.registerColumnType(-5, "number(19,0)");
        this.registerColumnType(5, "number(5,0)");
        this.registerColumnType(-6, "number(3,0)");
        this.registerColumnType(4, "number(10,0)");
        this.registerColumnType(1, "char(1 char)");
        this.registerColumnType(12, 4000, "varchar2($l char)");
        this.registerColumnType(12, "long");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "date");
        this.registerColumnType(93, "date");
        this.registerColumnType(-3, 2000, "raw($l)");
        this.registerColumnType(-3, "long raw");
        this.registerColumnType(2, "number($p,$s)");
        this.registerColumnType(3, "number($p,$s)");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
    }

    @Override
    public String encodeStrToWrite(String _strSrc) {
        return _strSrc;
    }

    @Override
    public boolean canWriteTextDirectly() {
        return false;
    }

    @Override
    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    @Override
    public DataType[] getSupportedDataTypes() {
        return m_supportedDataTypes;
    }

    @Override
    public String sqlConcatStr(String _strSQL1, String _strSQL2) {
        return "CONCAT(" + _strSQL1 + "," + _strSQL2 + ")";
    }

    @Override
    public String sqlConcatStr(String _strSQL1, String _strSQL2, String _strSQL3) {
        return "CONCAT(CONCAT(" + _strSQL1 + "," + _strSQL2 + ")," + _strSQL3 + ")";
    }

    @Override
    public String sqlConcatStr(String[] _strSQLs) {
        String sRet = "CONCAT(" + _strSQLs[0] + "," + _strSQLs[1] + ")";
        for (int i = 2; i < _strSQLs.length; ++i) {
            sRet = "CONCAT(" + sRet + "," + _strSQLs[i] + ")";
        }
        return sRet;
    }

    @Override
    public String sqlFilterForClob(String _sFieldName, String _sValue) {
        String sValue = _sValue.equals("?") ? "?" : "'" + CMyString.filterForSQL(_sValue) + "'";
        return " dbms_lob.instr(" + _sFieldName + "," + sValue + ", 1, 1)>0 ";
    }

    @Override
    public String sqlAddField(String _sTableName, String _sFieldName, String _sFieldType, int _nMaxLength, boolean _bNullable, String _sDefaultValue, int _nScale) {
        DataType dataType = this.getDataType(_sFieldType);
        if (dataType == null) {
            return null;
        }
        String sFieldType = _sFieldType;
        int nMaxLength = _nMaxLength;
        boolean zVarChar2 = false;
        switch (dataType.getType()) {
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                sFieldType = "NUMBER";
                nMaxLength = dataType.getMaxLength();
                break;
            }
            case 91: 
            case 93: {
                sFieldType = "DATE";
                break;
            }
            case 12: {
                sFieldType = "VARCHAR2";
                zVarChar2 = true;
                break;
            }
        }
        String strSQL = "ALTER TABLE " + _sTableName + " ADD( " + _sFieldName + " " + sFieldType;
        if (dataType.isLengthDefinedByUser()) {
            if (zVarChar2 && (nMaxLength *= 2) > 4000) {
                nMaxLength = 4000;
            }
            strSQL = _nScale > 0 ? strSQL + "(" + nMaxLength + ", " + _nScale + ")" : strSQL + "(" + nMaxLength + ")";
        }
        strSQL = strSQL + " NULL";
        return strSQL + ")";
    }

    @Override
    public String sqlRenameTable(String _sOldTableName, String _sNewTableName) {
        return "ALTER TABLE " + CMyString.filterForSQL(_sOldTableName) + " rename to " + CMyString.filterForSQL(_sNewTableName);
    }

    @Override
    public String sqlRenameField(String _sTableName, String _sOldFieldName, String _sNewFieldName) {
        return "ALTER TABLE " + CMyString.filterForSQL(_sTableName) + " rename column " + _sOldFieldName + " to " + _sNewFieldName;
    }

    @Override
    protected String keywordsModifyField() {
        return "modify";
    }

    @Override
    public String sqlGetSysDate() {
        return "SYSDATE";
    }

    @Override
    public String sqlFilterOneDay(String _sFieldName, String _sDateTime, String _sFormat) {
        return _sFieldName + " like to_date('" + _sDateTime + "','" + _sFormat + "')";
    }

    @Override
    public String sqlDateTime(String _sDateTime, String _sFormat) {
        return "to_date('" + _sDateTime + "','" + _sFormat + "')";
    }

    @Override
    public String sqlDate(String _sDateTime) {
        return this.sqlDateTime(_sDateTime, "yyyy-MM-dd HH24:MI:SS");
    }

    @Override
    public String sqlDateField(String _sDateField) {
        return _sDateField;
    }

    @Override
    public String initQuerySQL(String _strSql, int _nStartIndex, int _nSize) {
        StringBuffer querySQL = new StringBuffer();
        if (_nSize != 9999) {
            querySQL.append("select * from (select my_table.*,rownum as my_rownum from(").append(_strSql).append(") my_table where rownum<").append(_nStartIndex + _nSize).append(") where my_rownum>=").append(_nStartIndex);
        } else {
            querySQL.append("select * from (select my_table.*,rownum as my_rownum from(").append(_strSql).append(") my_table ").append(") where my_rownum>=").append(_nStartIndex);
        }
        return querySQL.toString();
    }

    @Override
    public String sqlQueryTableInfos(String _sUserOwner) {
        String strSQL = "SELECT * FROM ALL_TAB_COLUMNS WHERE OWNER='" + _sUserOwner.toUpperCase() + "' ORDER BY TABLE_NAME,COLUMN_ID";
        return strSQL;
    }

    @Override
    public String sqlQueryTableInfo(String _sUserOwner, String _sTableName) {
        String strSQL = "SELECT * FROM ALL_TAB_COLUMNS WHERE OWNER='" + _sUserOwner.toUpperCase() + "' AND TABLE_NAME='" + _sTableName.toUpperCase() + "' ORDER BY TABLE_NAME,COLUMN_ID";
        return strSQL;
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, int p_nFieldIndex) throws CMyException {
        return COracleCLOB.getClob(p_rsData, p_bJdbcIs2, p_nFieldIndex);
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, String p_sFieldName) throws CMyException {
        return COracleCLOB.getClob(p_rsData, p_bJdbcIs2, p_sFieldName);
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String p_sClobFieldName, String p_sValue) throws CMyException {
        return COracleCLOB.setClob(p_oConn, p_sTableName, p_sWhere, p_sIdFieldName, p_sClobFieldName, p_sValue);
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String[] p_asFieldsAndValues) throws CMyException {
        return COracleCLOB.setClob(p_oConn, p_sTableName, p_sWhere, p_sIdFieldName, p_asFieldsAndValues);
    }

    @Override
    public String sqlGetNextId() {
        return "{call sp_getNextId(?,?,?)}";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void setStringFieldValue(PreparedStatement _preStat, int _nIndex, String _sValue) throws Exception {
        if (_sValue == null || _sValue.length() <= 300) {
            _preStat.setString(_nIndex, _sValue);
            return;
        }
        StringReader stringReader = new StringReader(_sValue);
        _preStat.setCharacterStream(_nIndex, (Reader)stringReader, _sValue.length());
    }

    @Override
    public boolean canDropField() {
        return true;
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String sIdFieldName, int nObjId, String p_sClobFieldName, String p_sValue) throws CMyException {
        if (p_sValue == null) {
            return true;
        }
        return this.setClob(p_oConn, p_sTableName, sIdFieldName, nObjId, new String[]{p_sClobFieldName, p_sValue});
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sIdFieldName, int nObjId, String[] p_asFieldsAndValues) throws CMyException {
        int length = p_asFieldsAndValues.length;
        if ((length & 1) != 0) {
            throw new CMyException(10, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label6", "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548(COracleCLOB.setClob)"));
        }
        StringBuffer buff = new StringBuffer(128);
        buff.append("select ").append(p_sIdFieldName.toUpperCase());
        for (int i = 0; i < length; i += 2) {
            buff.append(',').append(p_asFieldsAndValues[i].toUpperCase());
        }
        buff.append(" from ").append(p_sTableName.toUpperCase());
        buff.append(" where ").append(p_sIdFieldName).append("=? for update");
        PreparedStatement pstmt = null;
        OracleResultSet rsData = null;
        boolean blFound = false;
        try {
            p_oConn.setAutoCommit(false);
            pstmt = p_oConn.prepareStatement(buff.toString());
            pstmt.setInt(1, nObjId);
            rsData = (OracleResultSet)pstmt.executeQuery();
            blFound = rsData.next();
            if (blFound) {
                int n = 2;
                int i = 1;
                while (i < length) {
                    void var11_13;
                    String sValue = p_asFieldsAndValues[i];
                    if (sValue != null) {
                        CLOB clob = rsData.getCLOB((int)var11_13);
                        Writer outx = clob.getCharacterOutputStream();
                        outx.write(sValue);
                        outx.close();
                    }
                    i += 2;
                    ++var11_13;
                }
            }
            rsData.close();
            rsData = null;
            pstmt.close();
            pstmt = null;
            p_oConn.commit();
            boolean bl = blFound;
            return bl;
        }
        catch (SQLException sQLException) {
            throw new CMyException(40, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label5", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.setClob)"), sQLException);
        }
        catch (Exception exception) {
            throw new CMyException(0, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label5", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.setClob)"), exception);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            try {
                p_oConn.setAutoCommit(true);
            }
            catch (Exception exception) {}
        }
    }
}

