/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyFile;
import java.io.File;

public class HttpGet {
    public static final int TRY_INTERVAL = 200;

    public static boolean isStarted(String _sFileName) {
        String sContent = "";
        try {
            sContent = CMyFile.readFile(_sFileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sContent.indexOf(I18NMessage.get(HttpGet.class, "HttpGet.label1", "\u5e94\u7528\u670d\u52a1\u5668\u542f\u52a8\u6210\u529f")) >= 0;
    }

    public static String get(String _sUrl) {
        return HttpGet.get(_sUrl, 0, true);
    }

    public static String get(String _sUrl, int _nTryCount) {
        return HttpGet.get(_sUrl, _nTryCount, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String _sUrl, int _nTryCount, boolean _bRetContent) {
        File file = null;
        if (_nTryCount < 0) {
            _nTryCount = 0;
        }
        while (_nTryCount >= 0) {
            try {
                file = File.createTempFile("WCMRunJsp", "log");
                String sFileName = file.getAbsolutePath();
                if (CMy3WLib.getFile(_sUrl, sFileName) && HttpGet.isStarted(sFileName)) {
                    if (_bRetContent) {
                        String string = CMyFile.readFile(sFileName);
                        return string;
                    }
                    String string = "Succesfully!";
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (file != null) {
                    try {
                        file.delete();
                    }
                    catch (Exception exception) {}
                }
            }
            if (--_nTryCount < 0) continue;
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println(I18NMessage.get(HttpGet.class, "HttpGet.label2", "\u7f3a\u5c11\u53c2\u6570\uff01(\u6b63\u786e\u793a\u4f8b\uff1ajava HttpGet http://www.sina.com.cn)"));
            return;
        }
        String sUrl = args[0];
        int nTryCount = 0;
        boolean bRetContent = true;
        if (args.length > 1) {
            try {
                nTryCount = Integer.parseInt(args[1]);
            }
            catch (Exception ex) {
                nTryCount = 0;
            }
        }
        if (args.length > 2) {
            try {
                bRetContent = Integer.parseInt(args[2]) != 0;
            }
            catch (Exception ex) {
                bRetContent = true;
            }
        }
        String sContent = HttpGet.get(sUrl, nTryCount, bRetContent);
        System.out.print("\n=========== Get " + sUrl + "============ \n\n");
        if (sContent == null) {
            System.out.println("Failed!");
        } else {
            System.out.println(sContent);
        }
    }
}

