/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.jazzlib.ZipEntry;
import com.trs.infra.util.jazzlib.ZipOutputStream;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;

public class CMyZip {
    public static boolean IS_DEBUG = false;
    private String m_sPath = "";
    private String m_sEntryPath = "";
    private String m_sDstZipFileName = "";
    private ZipOutputStream m_zos = null;
    private String encoding = null;
    private boolean m_bZipWithChildDirPath = false;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String _encoding) {
        this.encoding = _encoding;
    }

    public void setZipFileName(String p_sZipFileName) throws CMyException {
        if (this.m_zos != null) {
            throw new CMyException(1, I18NMessage.get(CMyZip.class, "CMyZip.label1", "\u975e\u6cd5\u64cd\u4f5c\uff1a\u672a\u5b8c\u6210\u4e0a\u6b21\u538b\u7f29\u64cd\u4f5c(CMyZip.setZipFileName)"));
        }
        this.m_sDstZipFileName = p_sZipFileName;
    }

    public void addToZip(String p_srcToZip) throws CMyException {
        this.addToZip(p_srcToZip, true);
    }

    public void addToZip(String p_srcToZip, String _sEntryName) throws CMyException {
        FileService file = new FileService(p_srcToZip);
        if (file.isDirectory()) {
            throw new CMyException("Accept file only.");
        }
        if (this.m_zos == null) {
            try {
                this.m_zos = new ZipOutputStream(new FileService(this.m_sDstZipFileName).getOutputStream());
                this.m_zos.setEncoding(this.encoding);
            }
            catch (Exception ex) {
                throw new CMyException(50, "\u521b\u5efazip\u8f93\u51fa\u6d41\u5931\u8d25(CMyZip.addToZip)", ex);
            }
            this.m_zos.setMethod(8);
        }
        this.m_sPath = p_srcToZip.replace(File.separatorChar, '/');
        this.m_sEntryPath = "";
        int nPos = this.m_sPath.lastIndexOf(47);
        if (nPos > 0) {
            this.m_sPath = this.m_sPath.substring(0, nPos);
            nPos = this.m_sPath.lastIndexOf(47);
            this.m_sEntryPath = nPos > 0 ? this.m_sPath.substring(nPos + 1) + "/" : this.m_sPath + "/";
            this.m_sPath = this.m_sPath + "/";
        }
        String name = file.getPath();
        name = this.makeEntryName(name, true);
        name = CMyString.replaceStr(name, CMyFile.extractMainFileName(file.getName()), _sEntryName);
        if (IS_DEBUG) {
            System.out.println("add to zip: " + name);
        }
        try {
            if (!(name.equals("") || name.equals(".") || name.equals(this.m_sPath))) {
                int len;
                long size = file.length();
                ZipEntry e = new ZipEntry(this.m_sEntryPath + name);
                e.setMethod(8);
                e.setTime(file.lastModified());
                e.setSize(size);
                this.m_zos.putNextEntry(e);
                byte[] buf = new byte[1024];
                BufferedInputStream is = new BufferedInputStream(file.getInputStream());
                while ((len = ((InputStream)is).read(buf, 0, buf.length)) != -1) {
                    this.m_zos.write(buf, 0, len);
                }
                ((InputStream)is).close();
                this.m_zos.closeEntry();
            }
        }
        catch (Exception ex) {
            throw new CMyException(1, "\u538b\u7f29\u6587\u4ef6\u6216\u76ee\u5f55\u5931\u8d25(CMyZip.addFile)", ex);
        }
    }

    public void addToZip(String p_srcToZip, boolean p_bAddPathToEntryName) throws CMyException {
        if (this.m_zos == null) {
            try {
                this.m_zos = new ZipOutputStream(new FileService(this.m_sDstZipFileName).getOutputStream());
                this.m_zos.setEncoding(this.encoding);
            }
            catch (Exception ex) {
                throw new CMyException(50, I18NMessage.get(CMyZip.class, "CMyZip.label2", "\u521b\u5efazip\u8f93\u51fa\u6d41\u5931\u8d25(CMyZip.addToZip)"), ex);
            }
            this.m_zos.setMethod(8);
        }
        this.m_sPath = p_srcToZip.replace(File.separatorChar, '/');
        this.m_sEntryPath = "";
        int nPos = this.m_sPath.lastIndexOf(47);
        if (nPos > 0) {
            this.m_sPath = this.m_sPath.substring(0, nPos);
            nPos = this.m_sPath.lastIndexOf(47);
            this.m_sEntryPath = nPos > 0 ? this.m_sPath.substring(nPos + 1) + "/" : this.m_sPath + "/";
            this.m_sPath = this.m_sPath + "/";
        }
        this.addFile(new FileService(p_srcToZip), p_bAddPathToEntryName);
    }

    public boolean done() throws CMyException {
        if (this.m_zos == null) {
            throw new CMyException(1, I18NMessage.get(CMyZip.class, "CMyZip.label3", "\u65e0\u6548\u8c03\u7528\uff1a\u672a\u8bbe\u5b9a\u76ee\u6807\u6587\u4ef6(CMyZip.done)"));
        }
        try {
            this.m_zos.finish();
            this.m_zos.close();
        }
        catch (Exception ex) {
            throw new CMyException(50, I18NMessage.get(CMyZip.class, "CMyZip.label4", "\u7ed3\u675fzip\u538b\u7f29\u65f6\u5931\u8d25(CMyZip.done)"), ex);
        }
        finally {
            this.m_zos = null;
        }
        return true;
    }

    public void zip(String p_srcToZip, String p_sZipFile) throws CMyException {
        this.setZipFileName(p_sZipFile);
        this.addToZip(p_srcToZip);
        this.done();
    }

    private void addFile(FileStore file, boolean p_bAddPathToEntryName) throws CMyException {
        String name = file.getPath();
        boolean isDir = file.isDirectory();
        if (isDir && !name.endsWith(File.separator)) {
            name = name + File.separator;
        }
        name = this.makeEntryName(name, p_bAddPathToEntryName);
        if (IS_DEBUG) {
            System.out.println("add to zip: " + name);
        }
        try {
            if (!(name.equals("") || name.equals(".") || name.equals(this.m_sPath))) {
                long size = isDir ? 0L : file.length();
                ZipEntry e = new ZipEntry((p_bAddPathToEntryName ? this.m_sEntryPath : "") + name);
                e.setMethod(8);
                e.setTime(file.lastModified());
                e.setSize(size);
                this.m_zos.putNextEntry(e);
                if (!isDir) {
                    int len;
                    byte[] buf = new byte[1024];
                    BufferedInputStream is = new BufferedInputStream(file.getInputStream());
                    while ((len = ((InputStream)is).read(buf, 0, buf.length)) != -1) {
                        this.m_zos.write(buf, 0, len);
                    }
                    ((InputStream)is).close();
                }
                this.m_zos.closeEntry();
            }
            if (isDir) {
                FileStore[] files = file.listFiles();
                if (this.m_bZipWithChildDirPath && !p_bAddPathToEntryName) {
                    this.m_sEntryPath = "";
                    for (int i = 0; i < files.length; ++i) {
                        this.addFile(files[i], true);
                    }
                } else {
                    for (int i = 0; i < files.length; ++i) {
                        this.addFile(files[i], p_bAddPathToEntryName);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new CMyException(1, I18NMessage.get(CMyZip.class, "CMyZip.label5", "\u538b\u7f29\u6587\u4ef6\u6216\u76ee\u5f55\u5931\u8d25(CMyZip.addFile)"), ex);
        }
    }

    private String makeEntryName(String p_srcName, boolean p_bAddPathToEntryName) {
        if (!p_bAddPathToEntryName) {
            return CMyFile.extractFileName(p_srcName);
        }
        String name = p_srcName.replace(File.separatorChar, '/');
        String matchPath = "";
        if (name.startsWith(this.m_sPath) && this.m_sPath.length() > 0) {
            matchPath = this.m_sPath;
        }
        if ((name = name.substring(matchPath.length())).startsWith("/")) {
            name = name.substring(1);
        } else if (name.startsWith("./")) {
            name = name.substring(2);
        }
        return name;
    }

    public static void main(String[] args) {
        String SRC_PATH = "d:\\test\\zip\\";
        try {
            CMyZip myZip = new CMyZip();
            myZip.setEncoding("UTF8");
            myZip.setZipFileName("d:\\test\\zip\\\u6d4b\u8bd5.zip");
            myZip.addToZip("d:\\test\\zip\\edit.htm", true);
            myZip.addToZip("d:\\test\\zip\\" + I18NMessage.get(CMyZip.class, "CMyZip.label6", "\u4e2d\u6587.txt"));
            myZip.done();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setZipWithChildDirPath(boolean _bZipWithChildDirPath) {
        this.m_bZipWithChildDirPath = _bZipWithChildDirPath;
    }
}

