/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wechat.filter;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wechat.IWeChatMgr;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMySign;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.RemoteAddrUtil;
import com.trs.webframework.controler.servlet.ServiceControler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class WechatAuthFilter
extends ServiceControler {
    private static final String APP_WECHAT_IP = "APP_WECHAT_IP";
    private static final String PARAM_NAME_ENCODE = "RandomInfo";
    public static final String KEY_PRIVATE_PLATFORM_LOGIN = ConfigConstants.DIR_APPROOT + "public_platform_log.key";
    private static final Logger LOG = Logger.getLogger(WechatAuthFilter.class);
    private IWeChatMgr m_WeChatMgr = (IWeChatMgr)DreamFactory.createObjectById("IWeChatMgr");
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.accessAble(request)) {
            response.setStatus(401);
            return;
        }
        if (!this.validAuth(request)) {
            response.setStatus(401);
            return;
        }
        PrintWriter writer = response.getWriter();
        writer.write("success");
        writer.flush();
    }

    public boolean validAuth(HttpServletRequest request) {
        String sEncodeInfo = request.getParameter(PARAM_NAME_ENCODE);
        return this.checkEncodeInfo(KEY_PRIVATE_PLATFORM_LOGIN, sEncodeInfo);
    }

    public boolean checkEncodeInfo(String sPublicKey, String sEncodeInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("sPublicKey:" + sPublicKey));
        }
        String sParam = "";
        try {
            int nSignLen;
            byte[] buff = sEncodeInfo.getBytes();
            CMySign verify = CMySign.getVerify(sPublicKey);
            buff = verify.decodeRadix64(buff);
            ByteArrayInputStream baoins = new ByteArrayInputStream(buff);
            DataInputStream dataInputStream = new DataInputStream(baoins);
            int nUserId = dataInputStream.readInt();
            User user = User.findById(nUserId);
            sParam = dataInputStream.readUTF();
            if (sParam == null) {
                sParam = "";
            }
            if (!verify.verify(buff, nSignLen = dataInputStream.readInt())) {
                LOG.error((Object)"Invalid random info: Signature doesn't matched.");
                return false;
            }
            Map<String, String> map = WechatAuthFilter.string2Map(sParam);
            String wxId = map.get("wxId");
            if (CMyString.isEmpty(wxId)) {
                return false;
            }
            Channel channel = Channel.findByName(this.m_WeChatMgr.getWXSite().getId(), wxId);
            int nRightIndex = 13;
            boolean flag = AuthServer.hasRight(user, (CMSObj)channel, nRightIndex);
            return flag;
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to check login.", (Throwable)ex);
            return false;
        }
    }

    public static Map<String, String> string2Map(String properties) {
        return WechatAuthFilter.string2Map(properties, "&", "=");
    }

    public static Map<String, String> string2Map(String properties, String outerSplitter, String innerSplitter) {
        if (CMyString.isEmpty(properties)) {
            return null;
        }
        Hashtable<String, String> outProperties = new Hashtable<String, String>();
        StringTokenizer tokenizerOuter = new StringTokenizer(properties, outerSplitter);
        while (tokenizerOuter.hasMoreTokens()) {
            String currProperty = tokenizerOuter.nextToken();
            int index = currProperty.indexOf(innerSplitter);
            if (index == -1) continue;
            String value = currProperty.substring(index + 1, currProperty.length());
            outProperties.put(currProperty.substring(0, index), value);
        }
        return outProperties;
    }

    private boolean accessAble(HttpServletRequest request) {
        String ip = RemoteAddrUtil.getRemoteAddr(request);
        try {
            String sAllowIP = ConfigServer.getServer().getSysConfigValue(APP_WECHAT_IP, "");
            LOG.debug((Object)("APP_WECHAT_IP:" + sAllowIP));
            LOG.debug((Object)("ip->" + ip));
            String[] pAllowIP = sAllowIP.split(",");
            return CMyString.isAllowIP(pAllowIP, ip);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to check the wechat ip.", (Throwable)e);
            return false;
        }
    }
}

